/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPool;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;

public class PoolPopulateThread
extends Thread {
    private static Logger log = Logger.getLogger(PoolPopulateThread.class);
    private RSPool pool = null;
    private Object synchMe = new Object();
    private ConcurrentLinkedQueue<RSPoolObject.PoolObjectType> typesToInclude = null;

    public PoolPopulateThread(RSPool pool, Object synchMe) {
        this.pool = pool;
        this.synchMe = synchMe;
        this.typesToInclude = new ConcurrentLinkedQueue();
    }

    public void addType(RSPoolObject.PoolObjectType type) {
        log.debug((Object)("Pool to be populated with " + type.toString()));
        this.typesToInclude.add(type);
    }

    public RSPoolObject.PoolObjectType getType() {
        return this.typesToInclude.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    RSPoolObject.PoolObjectType nextType = null;
                    Object object = this.synchMe;
                    synchronized (object) {
                        while ((nextType = this.getType()) == null) {
                            try {
                                log.debug((Object)"pool thread yielding");
                                this.synchMe.wait();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    log.debug((Object)"pool thread awake");
                    int toAdd = this.pool.getConfig().get((RSPoolObject.PoolObjectType)nextType).MaxSize - this.pool.poolSizeOfType(nextType);
                    log.debug((Object)("populating pool of " + nextType.toString() + " with " + toAdd + " objects"));
                    this.pool.addToPool(toAdd, nextType);
                }
            }
            catch (Exception e) {
                log.error((Object)"error populating pool. continuing", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

