/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning.commonvocabulary;

import java.util.HashMap;
import org.gcube.searchsystem.planning.exception.CQLUnsupportedException;

public class OperatorSemantics {
    private OperatorSemantics() {
    }

    public static String getOrOperationSemantics(String indication) throws CQLUnsupportedException {
        if (indication.equals("rank")) {
            return "mergesort";
        }
        if (indication.equals("default")) {
            return "merge";
        }
        throw new CQLUnsupportedException("Indication: " + indication + " is not supported for CQL OR.");
    }

    public static String getAndOperationSemantics(String indication) throws CQLUnsupportedException {
        if (indication.equals("rank")) {
            return "joinsort";
        }
        if (indication.equals("default")) {
            return "join";
        }
        throw new CQLUnsupportedException("Indication: " + indication + " is not supported for CQL OR.");
    }

    public static String getNotOperationSemantics(String indication) throws CQLUnsupportedException {
        if (indication.equals("rank")) {
            return "except";
        }
        if (indication.equals("default")) {
            return "except";
        }
        throw new CQLUnsupportedException("Indication: " + indication + " is not supported for CQL OR.");
    }

    public static HashMap<String, String> createAndOperationArgs(String semantics, String indication, String payloadSide) throws CQLUnsupportedException {
        HashMap<String, String> args = new HashMap<String, String>();
        if (semantics.equals("join") || semantics.equals("joinsort")) {
            args.put("payloadSide", payloadSide);
            return args;
        }
        throw new CQLUnsupportedException("semantics: " + semantics + ", are not supported for And Operation");
    }

    public static HashMap<String, String> createOrOperationArgs(String semantics, String mode, String indication) throws CQLUnsupportedException {
        HashMap<String, String> args = new HashMap<String, String>();
        if (semantics.equals("merge") || semantics.equals("mergesort")) {
            return args;
        }
        throw new CQLUnsupportedException("semantics: " + semantics + ", are not supported for Or Operation");
    }

    public static HashMap<String, String> createNotOperationArgs(String semantics, String mode, String indication) throws CQLUnsupportedException {
        HashMap<String, String> args = new HashMap<String, String>();
        if (semantics.equals("except")) {
            return args;
        }
        throw new CQLUnsupportedException("semantics: " + semantics + ", are not supported for Not Operation");
    }
}

