/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning.commonvocabulary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gcube.searchsystem.planning.exception.CQLUnsupportedException;
import org.gcube.searchsystem.planning.maxsubtree.AndTree;
import org.gcube.searchsystem.planning.maxsubtree.TreeTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLBooleanNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLRelation;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;

public class IndexRelationCommonSemantics {
    private static Logger logger = LoggerFactory.getLogger((String)IndexRelationCommonSemantics.class.getName());

    private IndexRelationCommonSemantics() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean examineCondition(TreeTransformer.GCQLCondition cond, AndTree result) throws CQLUnsupportedException {
        logger.trace("examine condition for relation: " + cond.getTerm().getRelation().getBase());
        if (cond.getTerm().getIndex().equals("gDocCollectionID")) {
            if (!cond.getTerm().getRelation().getBase().equals("==")) throw new CQLUnsupportedException("For field: " + cond.getTerm().getIndex() + ", found a relation: " + cond.getTerm().getRelation());
            if (IndexRelationCommonSemantics.checkCollection(result, cond.isNot(), cond.getTerm().getTerm())) return true;
            return false;
        }
        if (cond.getTerm().getIndex().equals("gDocCollectionLang")) {
            if (!cond.getTerm().getRelation().getBase().equals("==")) throw new CQLUnsupportedException("For field: " + cond.getTerm().getIndex() + ", found a relation: " + cond.getTerm().getRelation());
            if (IndexRelationCommonSemantics.checkLanguage(result, cond.isNot(), cond.getTerm().getTerm())) return true;
            return false;
        }
        if (cond.getTerm().getRelation().getBase().equals("geosearch")) {
            if (cond.isNot()) {
                cond.getTerm().getRelation().getModifiers().add(new Modifier("not"));
                cond.setNot(false);
            }
            Iterator modifierIter = cond.getTerm().getRelation().getModifiers().iterator();
            while (modifierIter.hasNext()) {
                String[] args;
                Modifier modifier = (Modifier)modifierIter.next();
                if (modifier.getType().equals("colID")) {
                    args = IndexRelationCommonSemantics.splitTerms(modifier.getValue());
                    if (args.length > 1 || args.length < 1) {
                        throw new CQLUnsupportedException("value of colid modifier for geosearch relation: " + modifier.getValue());
                    }
                    if (!IndexRelationCommonSemantics.checkCollection(result, false, args[0])) {
                        return false;
                    }
                    modifierIter.remove();
                }
                if (!modifier.getType().equals("lang")) continue;
                args = IndexRelationCommonSemantics.splitTerms(modifier.getValue());
                if (args.length > 1 || args.length < 1) {
                    throw new CQLUnsupportedException("value of lang modifier for geosearch relation: " + modifier.getValue());
                }
                if (!IndexRelationCommonSemantics.checkLanguage(result, false, args[0])) {
                    return false;
                }
                modifierIter.remove();
            }
            result.getConditions().add(cond);
            return true;
        } else {
            result.getConditions().add(cond);
        }
        return true;
    }

    private static boolean checkLanguage(AndTree result, boolean not, String language) {
        language = IndexRelationCommonSemantics.removeQuotes(language);
        if (not) {
            if (result.getLanguage() != null) {
                if (result.getLanguage().equals(language)) {
                    return false;
                }
            } else {
                result.getNotLanguages().add(language);
            }
        } else if (result.getLanguage() != null) {
            if (!result.getLanguage().equals(language)) {
                return false;
            }
        } else {
            result.setLanguage(language);
        }
        return true;
    }

    private static boolean checkCollection(AndTree result, boolean not, String collection) {
        collection = IndexRelationCommonSemantics.removeQuotes(collection);
        if (not) {
            if (result.getCollection() != null) {
                if (result.getCollection().equals(collection)) {
                    return false;
                }
            } else {
                result.getNotCollections().add(collection);
            }
        } else if (result.getCollection() != null) {
            if (!result.getCollection().equals(collection)) {
                return false;
            }
        } else {
            result.setCollection(collection);
        }
        return true;
    }

    private static String[] splitTerms(String term) {
        if (term.charAt(0) == '\"') {
            term = term.substring(1);
        }
        if (term.charAt(term.length() - 1) == '\"') {
            term = term.substring(0, term.length() - 1);
        }
        return term.trim().split("\\s+");
    }

    private static String removeQuotes(String term) {
        if (term.charAt(0) == '\"') {
            term = term.substring(1);
        }
        if (term.charAt(term.length() - 1) == '\"') {
            term = term.substring(0, term.length() - 1);
        }
        return term;
    }

    public static GCQLNode createGCQLNodeFromMatchedFactors(ArrayList<TreeTransformer.GCQLCondition> mFactors, HashMap<String, HashSet<String>> colLangs) {
        boolean allConditionsGeo = IndexRelationCommonSemantics.areAllConditionsGeo(mFactors);
        if (allConditionsGeo) {
            return IndexRelationCommonSemantics.createTreeFromGeoConditionsAndColLangs(mFactors, colLangs);
        }
        GCQLNode colLanguageNode = IndexRelationCommonSemantics.createColLangTree(colLangs);
        GCQLBooleanNode root = IndexRelationCommonSemantics.createRootFromAndConditions(mFactors);
        root.left = colLanguageNode;
        return root;
    }

    private static boolean areAllConditionsGeo(ArrayList<TreeTransformer.GCQLCondition> conditions) {
        boolean foundNonGeo = false;
        for (int i = 0; i < conditions.size(); ++i) {
            TreeTransformer.GCQLCondition current = conditions.get(i);
            if (current.getTerm().getRelation().getBase().equals("geosearch")) continue;
            foundNonGeo = true;
            if (i <= 0) break;
            logger.error("It appears that a source must answer mixed conditions(geo + something else)");
            break;
        }
        return !foundNonGeo;
    }

    private static GCQLNode createTreeFromGeoConditionsAndColLangs(ArrayList<TreeTransformer.GCQLCondition> geoConditions, HashMap<String, HashSet<String>> colLangs) {
        GCQLTermNode firstNode = null;
        GCQLOrNode orNode = null;
        for (Map.Entry<String, HashSet<String>> colLang : colLangs.entrySet()) {
            String collectionID = colLang.getKey();
            for (String language : colLang.getValue()) {
                GCQLTermNode leaf = null;
                GCQLTermNode andNode = null;
                for (TreeTransformer.GCQLCondition condition : geoConditions) {
                    GCQLTermNode newNode = TreeTransformer.GCQLCondition.cloneTerm(condition.getTerm());
                    Modifier colModifier = new Modifier("colID", "=", "\"" + collectionID + "\"");
                    Modifier langModifier = new Modifier("lang", "=", "\"" + language + "\"");
                    newNode.getRelation().getModifiers().add(colModifier);
                    newNode.getRelation().getModifiers().add(langModifier);
                    if (leaf == null) {
                        leaf = newNode;
                        continue;
                    }
                    if (andNode == null) {
                        andNode = new GCQLAndNode();
                        andNode.left = leaf;
                        andNode.right = newNode;
                        continue;
                    }
                    GCQLAndNode newAndNode = new GCQLAndNode();
                    newAndNode.left = andNode;
                    newAndNode.right = newNode;
                    andNode = newAndNode;
                }
                if (firstNode == null) {
                    if (andNode == null) {
                        firstNode = leaf;
                        continue;
                    }
                    firstNode = andNode;
                    continue;
                }
                if (orNode == null) {
                    orNode = new GCQLOrNode();
                    orNode.left = firstNode;
                    if (andNode == null) {
                        orNode.right = leaf;
                        continue;
                    }
                    orNode.right = andNode;
                    continue;
                }
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.left = orNode;
                newOrNode.right = andNode == null ? leaf : andNode;
                orNode = newOrNode;
            }
        }
        if (orNode == null) {
            return firstNode;
        }
        return orNode;
    }

    private static GCQLNode createColLangTree(HashMap<String, HashSet<String>> colLangs) {
        GCQLAndNode firstNode = null;
        GCQLOrNode colLanguageNode = null;
        for (Map.Entry<String, HashSet<String>> colLang : colLangs.entrySet()) {
            GCQLOrNode colLangOrNode;
            String collectionID = colLang.getKey();
            GCQLTermNode leaf = null;
            GCQLOrNode orNode = null;
            for (String language : colLang.getValue()) {
                GCQLTermNode current = new GCQLTermNode();
                current.setIndex("gDocCollectionLang");
                GCQLRelation newRelation = new GCQLRelation();
                newRelation.setBase("==");
                current.setRelation(newRelation);
                current.setTerm("\"" + language + "\"");
                if (leaf == null) {
                    leaf = current;
                    continue;
                }
                if (orNode == null) {
                    orNode = new GCQLOrNode();
                    orNode.left = leaf;
                    orNode.right = current;
                    continue;
                }
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.left = orNode;
                newOrNode.right = current;
                orNode = newOrNode;
            }
            GCQLTermNode collectionTermNode = new GCQLTermNode();
            collectionTermNode.setIndex("gDocCollectionID");
            GCQLRelation newRelation = new GCQLRelation();
            newRelation.setBase("==");
            collectionTermNode.setRelation(newRelation);
            collectionTermNode.setTerm("\"" + collectionID + "\"");
            GCQLAndNode andNode = new GCQLAndNode();
            andNode.left = collectionTermNode;
            andNode.right = orNode == null ? leaf : orNode;
            if (firstNode == null) {
                firstNode = andNode;
                continue;
            }
            if (colLanguageNode == null) {
                colLangOrNode = new GCQLOrNode();
                colLangOrNode.left = firstNode;
                colLangOrNode.right = andNode;
                colLanguageNode = colLangOrNode;
                continue;
            }
            colLangOrNode = new GCQLOrNode();
            colLangOrNode.left = colLanguageNode;
            colLangOrNode.right = andNode;
            colLanguageNode = colLangOrNode;
        }
        if (colLanguageNode == null) {
            return firstNode;
        }
        return colLanguageNode;
    }

    private static GCQLBooleanNode createRootFromAndConditions(ArrayList<TreeTransformer.GCQLCondition> conditions) {
        boolean foundAtLeastOne = false;
        int pos = 0;
        for (TreeTransformer.GCQLCondition cond : conditions) {
            if (!cond.isNot()) {
                foundAtLeastOne = true;
                break;
            }
            ++pos;
        }
        GCQLNotNode root = null;
        if (!foundAtLeastOne) {
            root = new GCQLNotNode();
        } else {
            root = new GCQLAndNode();
            TreeTransformer.GCQLCondition tmp = conditions.remove(pos);
            conditions.add(0, tmp);
        }
        GCQLTermNode firstNode = null;
        GCQLOrNode rightNode = null;
        for (TreeTransformer.GCQLCondition cond : conditions) {
            GCQLTermNode currentNode = TreeTransformer.GCQLCondition.cloneTerm(cond.getTerm());
            if (firstNode == null) {
                firstNode = currentNode;
                continue;
            }
            Object newNode = null;
            newNode = foundAtLeastOne ? (cond.isNot() ? new GCQLNotNode() : new GCQLAndNode()) : new GCQLOrNode();
            if (rightNode == null) {
                newNode.left = firstNode;
                newNode.right = currentNode;
                rightNode = newNode;
                continue;
            }
            newNode.left = rightNode;
            newNode.right = currentNode;
            rightNode = newNode;
        }
        root.right = rightNode == null ? firstNode : rightNode;
        return root;
    }

    public static GCQLNode createGCQLNodeFromAndTrees(ArrayList<AndTree> andTrees, HashMap<String, HashSet<String>> leafColLangs) {
        GCQLNode firstNode = null;
        GCQLOrNode orNode = null;
        for (AndTree tree : andTrees) {
            GCQLNode currentNode = null;
            String collectionID = tree.getCollection();
            String language = tree.getLanguage();
            HashMap<String, HashSet<String>> colLang = new HashMap<String, HashSet<String>>();
            HashSet<String> lang = new HashSet<String>();
            lang.add(language);
            colLang.put(collectionID, lang);
            HashSet<String> languageSet = leafColLangs.get(collectionID);
            if (languageSet == null) {
                languageSet = new HashSet();
                leafColLangs.put(collectionID, languageSet);
            }
            languageSet.add(language);
            if (IndexRelationCommonSemantics.areAllConditionsGeo(tree.getConditions())) {
                currentNode = IndexRelationCommonSemantics.createTreeFromGeoConditionsAndColLangs(tree.getConditions(), colLang);
            } else {
                GCQLNode colLanguageNode = IndexRelationCommonSemantics.createColLangTree(colLang);
                GCQLBooleanNode newNode = IndexRelationCommonSemantics.createRootFromAndConditions(tree.getConditions());
                newNode.left = colLanguageNode;
                currentNode = newNode;
            }
            if (firstNode == null) {
                firstNode = currentNode;
                continue;
            }
            if (orNode == null) {
                orNode = new GCQLOrNode();
                orNode.left = firstNode;
                orNode.right = currentNode;
                continue;
            }
            GCQLOrNode newNode = new GCQLOrNode();
            newNode.left = orNode;
            newNode.right = currentNode;
            orNode = newNode;
        }
        if (orNode == null) {
            return firstNode;
        }
        return orNode;
    }
}

