package org.gcube.searchsystem.workflow;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import gr.uoa.di.madgik.workflow.adaptor.search.WorkflowSearchAdaptor;
import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.PlanNode;
import gr.uoa.di.madgik.workflow.adaptor.search.utils.wrappers.datasource.DataSourceWrapperFactoryConfig;

public class PE2ngWorkflowAdaptor implements WorkflowEngineAdaptor {

	//the workflow engine instance
	private WorkflowSearchAdaptor workflowSearchAdaptor;
	
	/**
	 * creates a new WorkflowEngine adaptor for PE2ng
	 * @param scope - the working scope of the adaptor 
	 * @throws Exception 
	 */
	public PE2ngWorkflowAdaptor(EnvHintCollection hints) throws Exception {
		this.workflowSearchAdaptor = new WorkflowSearchAdaptor(hints);
	}
	
	/**
	 * creates a new WorkflowEngine adaptor for PE2ng
	 * @param cfg - the configuration for the data source wrapper factory
	 * @param scope - the working scope of the adaptor 
	 * @throws Exception 
	 */
	public PE2ngWorkflowAdaptor(DataSourceWrapperFactoryConfig cfg, EnvHintCollection hints) throws Exception {
		this.workflowSearchAdaptor = new WorkflowSearchAdaptor(cfg,hints);
	}
	@Override
	public String getExecutionResult(PlanNode plan) throws Exception{
		
		//set the plan to the workflow adaptor instance
		this.workflowSearchAdaptor.SetInputPlan(plan);
		
		//create the plan
		this.workflowSearchAdaptor.CreatePlan();
		
		//execute the plan 
		String resultsetEpr = this.workflowSearchAdaptor.ExecutePlan();
		
		//get the exception if any
		ExecutionException exception = this.workflowSearchAdaptor.GetCompletionError();
		
		if(exception != null) {
			throw exception;
		} else {
			return resultsetEpr;
		}
			
	}

	@Override
	public Object getExecutionPlan(PlanNode plan) throws Exception{
		
		//set the plan to the workflow adaptor instance
		this.workflowSearchAdaptor.SetInputPlan(plan);
		
		//create the workflow plan
		this.workflowSearchAdaptor.CreatePlan();
		
		//return the workflow plan for the execution engine
		return this.workflowSearchAdaptor.GetCreatedPlan();
		
	}

}
