/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.environmentadaptor;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.bridge.RegistryBridge;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import gr.uoa.di.madgik.rr.element.search.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryAdapter
implements EnvironmentAdaptor {
    private String scope;
    private static Logger logger = LoggerFactory.getLogger((String)ResourceRegistryAdapter.class.getName());

    public static boolean initializeAdapter() throws Exception {
        try {
            ResourceRegistry.startBridging();
        }
        catch (Exception e) {
            logger.error("Could not start bridging", (Throwable)e);
            return false;
        }
        return true;
    }

    public ResourceRegistryAdapter(EnvHintCollection hints) {
        if (hints.HintExists("GCubeActionScope")) {
            this.scope = hints.GetHint((String)"GCubeActionScope").Hint.Payload;
        }
    }

    public Map<String, String> getFieldsMapping(String scope) throws Exception {
        Map<String, Set<String>> fieldsPerCollection = this.getAllFieldsPerCollection(scope);
        HashSet allFields = Sets.newHashSet();
        for (Set<String> f : fieldsPerCollection.values()) {
            allFields.addAll(f);
        }
        HashMap fieldsMapping = Maps.newHashMap();
        for (String f : allFields) {
            String fId = this.getFieldIDFromName(f);
            fieldsMapping.put(f, fId);
        }
        return fieldsMapping;
    }

    public String getFieldIDFromName(String fieldName) throws Exception {
        List fields = Field.getFieldsWithName((boolean)false, (String)fieldName);
        if (fields == null || fields.size() == 0) {
            throw new Exception("Could not find fieldId for fieldName: " + fieldName);
        }
        return ((Field)fields.get(0)).getID();
    }

    public Map<String, String> getAllCollections(String scope) throws Exception {
        return QueryHelper.getAllSearchableCollections((String)scope);
    }

    public Map<String, String> getAllCollectionsTypes(String scope) throws Exception {
        return QueryHelper.getAllCollectionsTypes((String)scope);
    }

    public Map<String, Set<String>> getAllFieldsPerCollection(String scope) throws Exception {
        return QueryHelper.getAllSearchableFieldsPerCollection((String)scope);
    }

    @Override
    public HashMap<String, HashSet<String>> getProjectionsPerSource(Set<String> sources, Set<String> projectionsNeeded, HashMap<String, HashSet<String>> colLangs) throws Exception {
        return QueryHelper.getProjectionsPerSource(sources, projectionsNeeded, colLangs, (String)this.scope);
    }

    @Override
    public Map<String, Set<String>> getCollectionLangsByFieldRelation(Map<String, List<String>> fieldRelationMap, List<String> projections) throws Exception {
        return QueryHelper.getCollectionLangsByFieldRelation(fieldRelationMap, projections, (String)this.scope);
    }

    @Override
    public Set<String> getCollectionByFieldRelationLang(Map<String, List<String>> fieldRelationMap, String language, List<String> projections) throws Exception {
        return QueryHelper.getCollectionByFieldRelationLang(fieldRelationMap, (String)language, projections, (String)this.scope);
    }

    @Override
    public Set<String> getLanguageByFieldRelationCol(Map<String, List<String>> fieldRelationMap, String collection, List<String> projections) throws Exception {
        return QueryHelper.getLanguageByFieldRelationCol(fieldRelationMap, (String)collection, projections, (String)this.scope);
    }

    @Override
    public Set<String> getSourceIdsForFieldRelationCollectionLanguage(String field, String relation, String collection, String language, String indication) throws Exception {
        return new HashSet<String>(QueryHelper.getSourceIdsForFieldRelationCollectionLanguage((String)field, (String)relation, (String)collection, (String)language, (String)this.scope));
    }

    @Override
    public long getLastUpdate() {
        return RegistryBridge.getLastUpdate();
    }
}

