/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search;

import com.google.common.io.Resources;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.ChannelTCPConnManagerEntry;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngCallbackTCPConnManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngTCPConnManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceContext {
    private static final int MAXATTEMPTS = 10;
    private static final Logger logger = LoggerFactory.getLogger(ServiceContext.class);
    public static final String PROPERTIES_FILE = "deploy.properties";
    public static final String ServiceClass = "Search";
    public static final String ServiceName = "SearchSystemService";
    EnvHintCollection adaptorHints = null;
    String scope = null;

    public ServiceContext() throws Exception {
        this.initialize();
    }

    EnvHintCollection getHints() {
        return this.adaptorHints;
    }

    String getScope() {
        return this.scope;
    }

    void initialize() throws Exception {
        this.adaptorHints = new EnvHintCollection();
        this.adaptorHints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass", new EnvHint("Search")));
        this.adaptorHints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName", new EnvHint("SearchSystemService")));
        this.adaptorHints = new EnvHintCollection();
        this.adaptorHints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass", new EnvHint("Search")));
        this.adaptorHints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName", new EnvHint("SearchSystemService")));
        Map map = ServiceContext.readProperties();
        this.scope = (String)map.get("scope");
        ServiceContext.initializeTCPManager((Map)map);
        ServiceContext.initializeExecutionEngineEnvironment();
        ServiceContext.initializeExecutionEngine();
        ServiceContext.initializeRR();
        this.setAdaptorHint("MaxCollocationCost", map);
        this.setAdaptorHint("OperatorNodeSelectorThreshold", map);
        this.setAdaptorHint("ExcludeLocal", map);
        this.setAdaptorHint("DataSourceNodeSelector", map);
        this.setAdaptorHint("DataSourceNodeSelectorTieBreaker", map);
        this.setAdaptorHint("NodeAssignmentPolicy", map);
        this.setAdaptorHint("ComplexPlanLevels", map);
        this.setAdaptorHint("ComplexPlanNumNodes", map);
    }

    void setAdaptorHint(String propName, Map<String, String> map) {
        if (map.get(propName) == null) {
            logger.info("property : " + propName + " not in map");
            return;
        }
        this.adaptorHints.AddHint(new NamedEnvHint(propName, new EnvHint(map.get(propName).trim())));
    }

    private static Map<String, String> readProperties() throws FileNotFoundException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            prop.load(is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
        for (String key : prop.stringPropertyNames()) {
            String value = prop.getProperty(key);
            if (value == null) continue;
            map.put(key, value);
        }
        logger.info("properties read : " + map);
        return map;
    }

    static void addMapToHints(Map<String, String> map, EnvHintCollection hints) {
        for (Map.Entry<String, String> en : map.entrySet()) {
            hints.AddHint(new NamedEnvHint(en.getKey(), new EnvHint(en.getValue())));
        }
    }

    private static String getHostName(Map<String, String> map) {
        return map.get("hostname").trim();
    }

    private static void initializeRR() throws InterruptedException, Exception {
        for (int attempts = 0; attempts < 10; ++attempts) {
            if (ResourceRegistryAdapter.initializeAdapter()) {
                return;
            }
            Thread.sleep(1000L);
        }
    }

    private static void initializeTCPManager(Map<String, String> props) {
        logger.info("Initalizing TCPManager");
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(ServiceContext.getHostName(props), Arrays.asList(new PortRange(4000, 4100)), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    private static void initializeExecutionEngineEnvironment() {
        logger.info("Initalizing Execution Engine Environment");
        logger.info("Registering entries");
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngCallbackTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ChannelTCPConnManagerEntry());
    }

    private static void initializeExecutionEngine() {
        logger.info("Initializing Execution Engine");
        ExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0));
    }
}

