/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.service.helpers;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import gr.uoa.di.madgik.rr.element.search.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RRHelper {
    private static final Logger logger = LoggerFactory.getLogger(RRHelper.class);

    public static Map<String, String> getFieldsMapping(String scope) throws Exception {
        Map searchableFieldsPerCollection = RRHelper.getAllSearchableFieldsPerCollection((String)scope);
        Map presentableFieldsPerCollection = RRHelper.getAllPresentableFieldsPerCollection((String)scope);
        HashSet allFields = Sets.newHashSet();
        for (Set f : searchableFieldsPerCollection.values()) {
            allFields.addAll(f);
        }
        for (Set f : presentableFieldsPerCollection.values()) {
            allFields.addAll(f);
        }
        HashMap fieldsMapping = Maps.newHashMap();
        for (String f : allFields) {
            String fId = RRHelper.getFieldIDFromName((String)f);
            fieldsMapping.put(f, fId);
        }
        return fieldsMapping;
    }

    public static String getFieldIDFromName(String fieldName) throws Exception {
        List fields = Field.getFieldsWithName((boolean)false, (String)fieldName);
        if (fields == null || fields.size() == 0) {
            throw new Exception("Could not find fieldId for fieldName: " + fieldName);
        }
        return ((Field)fields.get(0)).getID();
    }

    public static Map<String, Set<String>> getAllSearchableFieldsPerCollection(String scope) throws Exception {
        return QueryHelper.getAllSearchableFieldsPerCollection((String)scope);
    }

    public static Map<String, Set<String>> getAllPresentableFieldsPerCollection(String scope) throws Exception {
        return QueryHelper.getAllPresentableFieldsPerCollection((String)scope);
    }

    public static Map<String, String> getAllCollectionsTypes(String scope) throws Exception {
        return QueryHelper.getAllCollectionsTypes((String)scope);
    }

    public static Map<String, Set<String>> getAllFieldsPerCollection(String scope) throws Exception {
        return QueryHelper.getAllSearchableFieldsPerCollection((String)scope);
    }

    public static void init() throws ResourceRegistryException {
        ResourceRegistry.startBridging();
    }

    public static void waitInit(boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        RRHelper.init();
        if (useRRAdaptor) {
            logger.info("Initializing ResourceRegistry");
            try {
                ResourceRegistry.startBridging();
                TimeUnit.SECONDS.sleep(1L);
                while (!ResourceRegistry.isInitialBridgingComplete()) {
                    TimeUnit.SECONDS.sleep(10L);
                }
            }
            catch (ResourceRegistryException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            catch (InterruptedException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            logger.info("Initializing ResourceRegistry is DONE");
        } else {
            logger.info("ResourceRegistry will NOT be initialized as configured");
        }
    }
}

