/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.ecoscope;

import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.ecoscope.EcoscopeResult;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.retriever.ResultsRetriever;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EcoscopeRetriever
implements ResultsRetriever {
    private final String url = "http://ecoscopebc.mpl.ird.fr/EcoscopeKB/GetOpensearchGenesiDec?freeText=";
    private String query;
    private ArrayList<SearchResult> results;
    ArrayList<EcoscopeResult> ecoscopeResults;
    private int desiredNumber;
    private HashMap<String, String> parameters;

    public EcoscopeRetriever(String query, int desiredNumber) {
        this.query = query;
        this.desiredNumber = desiredNumber;
        this.results = new ArrayList();
        this.ecoscopeResults = new ArrayList();
        this.parameters = new HashMap();
    }

    public void retrieveResults() {
        try {
            if (this.desiredNumber <= 0) {
                this.desiredNumber = Resources.MAX_NUM_OF_RESULTS_FROM_WSE;
            }
            String enc_query = URLEncoder.encode(this.query.trim(), "utf-8");
            String queryPath = "http://ecoscopebc.mpl.ird.fr/EcoscopeKB/GetOpensearchGenesiDec?freeText=" + enc_query;
            if (!this.parameters.isEmpty()) {
                String paramsString = "";
                for (String paramKey : this.parameters.keySet()) {
                    String paramValue = (String)this.parameters.get(paramKey);
                    paramsString = paramsString + "&" + paramKey + "=" + paramValue;
                }
                queryPath = queryPath + paramsString;
            }
            System.out.println("QUERY PATH: " + queryPath);
            URL theurl = new URL(queryPath);
            HTMLTag tagger1 = new HTMLTag(theurl, true);
            int n = tagger1.getFirstTagIndex("rdf:Description");
            int num = 0;
            while (n != -1) {
                EcoscopeResult ecoscopeResult = new EcoscopeResult();
                SearchResult result = new SearchResult();
                result.setRank(num);
                String aboutStr = tagger1.getFirstTagContent("rdf:Description", n - 1);
                String about = HTMLTag.getContentAttribute((String)"rdf:about", (String)aboutStr);
                if (about == null) {
                    about = "";
                }
                if (about.equals("")) {
                    about = "{-}";
                }
                ecoscopeResult.setUri(about);
                result.setUrl(about);
                String descrData = tagger1.getFirstTagData("rdf:Description", n - 1);
                HTMLTag tagger2 = new HTMLTag(descrData);
                HashMap<String, String> prefLabels = new HashMap<String, String>();
                int i_pl = tagger2.getFirstTagIndex("j.1:prefLabel");
                String title = "";
                while (i_pl != -1) {
                    String label_cont;
                    String label_attr = tagger2.getFirstTagContent("j.1:prefLabel", i_pl - 1);
                    if (label_attr == null) {
                        label_attr = "";
                    }
                    if ((label_cont = tagger2.getFirstTagData("j.1:prefLabel", i_pl - 1)) == null) {
                        label_cont = "";
                    }
                    label_cont = label_cont.trim();
                    String lang = HTMLTag.getContentAttribute((String)"xml:lang", (String)label_attr);
                    if (lang == null) {
                        lang = "";
                    }
                    lang = lang.trim().toLowerCase();
                    prefLabels.put(lang, label_cont);
                    if (lang.equals("en") || lang.equals("")) {
                        title = label_cont;
                    }
                    i_pl = tagger2.getFirstTagIndex("j.1:prefLabel", i_pl + 2);
                }
                ecoscopeResult.setPrefLabels(prefLabels);
                if (title.equals("")) {
                    title = (String)prefLabels.get("fr");
                }
                if (title == null) {
                    title = "";
                }
                result.setTitle(title);
                if (prefLabels.isEmpty()) {
                    HashMap<String, String> dcTitles = new HashMap<String, String>();
                    int i_dc = tagger2.getFirstTagIndex("dc:title");
                    while (i_dc != -1) {
                        String lang;
                        String dcTitle_cont;
                        String dcTitle_attr = tagger2.getFirstTagContent("dc:title", i_dc - 1);
                        if (dcTitle_attr == null) {
                            dcTitle_attr = "";
                        }
                        if ((dcTitle_cont = tagger2.getFirstTagData("dc:title", i_dc - 1)) == null) {
                            dcTitle_cont = "";
                        }
                        if ((lang = HTMLTag.getContentAttribute((String)"xml:lang", (String)dcTitle_attr)) == null) {
                            lang = "";
                        }
                        lang = lang.trim().toLowerCase();
                        dcTitles.put(lang, dcTitle_cont);
                        if (lang.equals("en") || lang.equals("")) {
                            title = dcTitle_cont;
                        }
                        i_dc = tagger2.getFirstTagIndex("dc:title", i_dc + 2);
                    }
                    ecoscopeResult.setTitles(dcTitles);
                    if (title.equals("")) {
                        title = (String)dcTitles.get("fr");
                    }
                    if (title == null) {
                        title = "";
                    }
                    result.setTitle(title);
                }
                HashMap<String, String> prefDescriptions = new HashMap<String, String>();
                int i_d = tagger2.getFirstTagIndex("dc:description");
                String descr = "";
                while (i_d != -1) {
                    String lang;
                    String descr_cont;
                    String descr_attr = tagger2.getFirstTagContent("dc:description", i_d - 1);
                    if (descr_attr == null) {
                        descr_attr = "";
                    }
                    if ((descr_cont = tagger2.getFirstTagData("dc:description", i_d - 1)) == null) {
                        descr_cont = "";
                    }
                    if ((lang = HTMLTag.getContentAttribute((String)"xml:lang", (String)descr_attr)) == null) {
                        lang = "";
                    }
                    lang = lang.trim().toLowerCase();
                    prefDescriptions.put(lang, descr_cont);
                    if (lang.equals("en") || lang.equals("")) {
                        descr = descr_cont;
                    }
                    i_d = tagger2.getFirstTagIndex("dc:description", i_d + 2);
                }
                ecoscopeResult.setDescriptions(prefDescriptions);
                if (descr.equals("")) {
                    descr = (String)prefDescriptions.get("fr");
                }
                if (descr == null) {
                    descr = "";
                }
                result.setDescription(descr);
                if (prefDescriptions.isEmpty()) {
                    HashMap<String, String> comments = new HashMap<String, String>();
                    int i_c = tagger2.getFirstTagIndex("rdfs:comment");
                    while (i_c != -1) {
                        String lang;
                        String comment_cont;
                        String comment_attr = tagger2.getFirstTagContent("rdfs:comment", i_c - 1);
                        if (comment_attr == null) {
                            comment_attr = "";
                        }
                        if ((comment_cont = tagger2.getFirstTagData("rdfs:comment", i_c - 1)) == null) {
                            comment_cont = "";
                        }
                        if ((lang = HTMLTag.getContentAttribute((String)"xml:lang", (String)comment_attr)) == null) {
                            lang = "";
                        }
                        lang = lang.trim().toLowerCase();
                        comments.put(lang, comment_cont);
                        if (lang.equals("en") || lang.equals("")) {
                            descr = comment_cont;
                        }
                        i_c = tagger2.getFirstTagIndex("rdfs:comment", i_c + 2);
                    }
                    ecoscopeResult.setComments(comments);
                    if (descr.equals("")) {
                        descr = (String)comments.get("fr");
                    }
                    if (descr == null) {
                        descr = "";
                    }
                    result.setDescription(descr);
                }
                result.setContent(result.getTitle() + " " + result.getDescription());
                if (result.getContent().trim().equals("")) {
                    result.setContent("- - -");
                }
                this.ecoscopeResults.add(ecoscopeResult);
                this.results.add(result);
                if (++num != this.desiredNumber) {
                    n = tagger1.getFirstTagIndex("rdf:Description", n + 2);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            IOSLog.writeErrorToLog((Exception)ex, (String)"EcoscopeRetriever Error 1");
            System.out.println("*** COULD NOT RETRIEVE RESULTS FROM iMarine!");
            Logger.getLogger(EcoscopeRetriever.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ArrayList<SearchResult> getResults() {
        return this.results;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setDesiredNumber(int desiredNumber) {
        this.desiredNumber = desiredNumber;
    }

    public int getDesiredNumber() {
        return this.desiredNumber;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public String getUrl() {
        return "http://ecoscopebc.mpl.ird.fr/EcoscopeKB/GetOpensearchGenesiDec?freeText=";
    }

    public void setResults(ArrayList<SearchResult> results) {
        this.results = results;
    }

    public ArrayList<EcoscopeResult> getEcoscopeResults() {
        return this.ecoscopeResults;
    }

    public void setEcoscopeResults(ArrayList<EcoscopeResult> ecoscopeResults) {
        this.ecoscopeResults = ecoscopeResults;
    }
}

