/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.helloworld.rest;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.gcube.service.helloworld.annotation.PURGE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="guest")
public class ExcludeAuthorizationService {
    private final Logger logger = LoggerFactory.getLogger(ExcludeAuthorizationService.class);

    @GET
    public String exludedMethod() {
        this.logger.info("executed whithout any authorization");
        return "executed whithout any authorization";
    }

    @GET
    @Path(value="bad-request")
    public String badRequest() throws WebApplicationException {
        throw new BadRequestException("Your request is not valid");
    }

    @GET
    @Path(value="not-found")
    public String notFound() throws WebApplicationException {
        throw new NotFoundException("Not found sorry");
    }

    @PURGE
    @Path(value="test-purge")
    public Response testPurge() throws WebApplicationException {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

