/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.events.Observes;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.embedded.HeaderImpl;
import org.gcube.informationsystem.impl.entity.facet.CPUFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.ContainerStateFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.MemoryFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.NetworkingFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.SimplePropertyFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.SoftwareFacetImpl;
import org.gcube.informationsystem.impl.entity.resource.HostingNodeImpl;
import org.gcube.informationsystem.impl.relation.IsIdentifiedByImpl;
import org.gcube.informationsystem.impl.relation.consistsof.HasPersistentMemoryImpl;
import org.gcube.informationsystem.impl.relation.consistsof.HasVolatileMemoryImpl;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.entity.facet.CPUFacet;
import org.gcube.informationsystem.model.entity.facet.ContainerStateFacet;
import org.gcube.informationsystem.model.entity.facet.MemoryFacet;
import org.gcube.informationsystem.model.entity.facet.SimplePropertyFacet;
import org.gcube.informationsystem.model.entity.resource.HostingNode;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.consistsof.HasPersistentMemory;
import org.gcube.informationsystem.model.relation.consistsof.HasVolatileMemory;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.library.SmartGearsConfiguration;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="resource-management")
public class HostingNodeManager
extends ContainerHandler {
    private static Logger logger = LoggerFactory.getLogger(HostingNodeManager.class);
    public static final String MEMORY_TYPE = "memoryType";
    public static final String MEMORY_TYPE_RAM = "RAM";
    public static final String MEMORY_TYPE_JVM = "JVM";
    public static final String JVM_MAX_MEMORY = "jvmMaxMemory";
    public static final String MESSAGE = "message";
    private ContainerContext context;
    private AuthorizationProxy authorizationProxy = ProviderFactory.provider().authorizationProxy();
    private ScheduledFuture<?> periodicUpdates;
    public static final String CPU_PROCESSOR = "processor";
    public static final String CPU_VENDOR_ID = "vendor_id";
    public static final String CPU_MODEL_NAME = "model name";
    public static final String CPU_CPU_MHZ = "cpu MHz";
    public static final String CPU_MODEL_T = "model\t";
    public static final String CPU_MODEL_B = "model\b";
    public static final String CPU_MODEL_NUMBER = "modelNumber";

    private void setContextFromToken(String token) {
        if (token == null || token.compareTo("") == 0) {
            SecurityTokenProvider.instance.reset();
            ScopeProvider.instance.reset();
        } else {
            SecurityTokenProvider.instance.set(token);
            String scope = this.getCurrentContextName(token);
            ScopeProvider.instance.set(scope);
        }
    }

    public void onStart(ContainerLifecycleEvent.Start e) {
        try {
            logger.info("onStart started");
            this.context = (ContainerContext)e.context();
            HostingNode hostingNode = this.instantiateHostingNode();
            hostingNode = this.publishHostingNode(hostingNode);
            this.registerObservers();
            this.schedulePeriodicUpdates();
            logger.info("onStart finished");
        }
        catch (Throwable re) {
            logger.error("onStart failed", re);
        }
    }

    private void share(HostingNode hostingNode) {
        logger.trace("sharing {} {}", (Object)"HostingNode", (Object)"Resource");
        this.context.properties().add(new Property[]{new Property("HostingNode", (Object)hostingNode)});
    }

    private void registerObservers() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "part_activation", "shutdown", "stop", "failure"})
            void onChanged(ContainerLifecycle lc) {
                HostingNode hostingNode = (HostingNode)HostingNodeManager.this.context.properties().lookup("HostingNode").value(HostingNode.class);
                HostingNodeManager.this.updateHostingNode(hostingNode);
            }

            @Observes(value={"addToContext"})
            void addTo(String token) {
                HostingNode hostingNode = (HostingNode)HostingNodeManager.this.context.properties().lookup("HostingNode").value(HostingNode.class);
                HostingNodeManager.this.addToContext(hostingNode, token);
            }

            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                HostingNode hostingNode = (HostingNode)HostingNodeManager.this.context.properties().lookup("HostingNode").value(HostingNode.class);
                HostingNodeManager.this.removeFromContext(hostingNode, token);
            }
        });
    }

    private void schedulePeriodicUpdates() {
        this.context.events().subscribe(new Object(){
            final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);

            @Observes(value={"activation", "part_activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(ContainerLifecycle lc) {
                if (HostingNodeManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ContainerState.active) {
                    logger.info("scheduling periodic updates of {}", (Object)"HostingNode");
                } else {
                    logger.info("resuming periodic updates of {}", (Object)"HostingNode");
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        HostingNode hostingNode = (HostingNode)HostingNodeManager.this.context.properties().lookup("HostingNode").value(HostingNode.class);
                        try {
                            HostingNodeManager.this.updateHostingNode(hostingNode);
                        }
                        catch (Exception e) {
                            logger.error("cannot complete periodic update of {}", (Object)"HostingNode", (Object)e);
                        }
                    }
                };
                HostingNodeManager.this.periodicUpdates = this.service.scheduleAtFixedRate(updateTask, 3L, HostingNodeManager.this.context.configuration().publicationFrequency(), TimeUnit.SECONDS);
            }

            @Observes(value={"stop", "failure", "shutdown"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (HostingNodeManager.this.periodicUpdates != null) {
                    logger.trace("stopping periodic updates of {}", (Object)"HostingNode");
                    try {
                        HostingNodeManager.this.periodicUpdates.cancel(true);
                        this.service.shutdownNow();
                        HostingNodeManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        logger.warn("could not stop periodic updates of {}", (Object)"HostingNode", (Object)e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostingNode publishHostingNode(HostingNode hostingNode) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(HostingNodeManager.class.getClassLoader());
            boolean create = true;
            List startTokens = this.context.configuration().startTokens();
            for (String token : startTokens) {
                this.setContextFromToken(token);
                try {
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    if (create) {
                        try {
                            hostingNode = (HostingNode)resourceRegistryPublisher.createResource((Resource)hostingNode);
                            this.share(hostingNode);
                        }
                        catch (ResourceAlreadyPresentException e) {
                            ResourceRegistryClient registryClient = ResourceRegistryClientFactory.create();
                            hostingNode = (HostingNode)registryClient.getInstance(HostingNode.class, hostingNode.getHeader().getUUID());
                            this.updateHostingNode(hostingNode);
                        }
                        catch (ResourceAvailableInAnotherContextException e) {
                            this.addToContext(hostingNode, token);
                        }
                        create = false;
                        continue;
                    }
                    this.addToContext(hostingNode, token);
                }
                catch (Exception e) {
                    logger.error("Unable to add {} to current context ({})", new Object[]{hostingNode, this.getCurrentContextName(token), e});
                }
            }
        }
        catch (Throwable e) {
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        logger.info("hosting node published");
        return hostingNode;
    }

    private String getCurrentContextName(String token) {
        try {
            return this.authorizationProxy.get(token).getContext();
        }
        catch (Exception e) {
            logger.error("Error retrieving context form token {}, it should never happen", (Object)token, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromContext(HostingNode hostingNode, String token) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(HostingNodeManager.class.getClassLoader());
            this.setContextFromToken(token);
            boolean removed = false;
            ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
            removed = resourceRegistryPublisher.removeResourceFromContext((Resource)hostingNode);
            if (removed) {
                logger.info("{} successfully removed from current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName(token));
                this.share(hostingNode);
            } else {
                logger.error("Unable to remove {} from current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName(token));
            }
            this.share(hostingNode);
        }
        catch (Exception e) {
            logger.error("Unable to remove {} from current context ({})", new Object[]{hostingNode, this.getCurrentContextName(token), e});
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToContext(HostingNode hostingNode, String token) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(HostingNodeManager.class.getClassLoader());
            this.setContextFromToken(token);
            ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
            boolean added = resourceRegistryPublisher.addResourceToContext((Resource)hostingNode);
            if (added) {
                logger.info("{} successfully added to current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName(token));
                this.share(hostingNode);
            } else {
                logger.error("Unable to add {} to current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName(token));
            }
            this.share(hostingNode);
        }
        catch (Exception e) {
            logger.error("Unable to add {} to current context ({})", new Object[]{hostingNode, this.getCurrentContextName(token), e});
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostingNode updateHostingNode(HostingNode hostingNode) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            if (previousToken == null) {
                this.setContextFromToken((String)this.context.configuration().startTokens().toArray()[0]);
            }
            Thread.currentThread().setContextClassLoader(HostingNodeManager.class.getClassLoader());
            hostingNode = this.updateFacets(hostingNode);
            this.share(hostingNode);
        }
        catch (Exception e) {
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        return hostingNode;
    }

    private HostingNode updateFacets(HostingNode hostingNode) throws ResourceRegistryException {
        logger.debug("Updating HostingNode");
        ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
        ContainerStateFacet containerStateFacet = null;
        MemoryFacet ramFacet = null;
        MemoryFacet jvmMemoryFacet = null;
        MemoryFacet disk = null;
        ArrayList<ConsistsOf> consistsOfToRemove = new ArrayList<ConsistsOf>();
        List consistsOfList = hostingNode.getConsistsOf();
        for (ConsistsOf c : consistsOfList) {
            if (c.getTarget() instanceof ContainerStateFacet) {
                containerStateFacet = (ContainerStateFacet)c.getTarget();
                containerStateFacet = this.getContainerStateFacet(containerStateFacet);
                continue;
            }
            if (c instanceof HasVolatileMemory) {
                String memoryType = (String)c.getAdditionalProperty(MEMORY_TYPE);
                if (memoryType.compareTo(MEMORY_TYPE_RAM) == 0) {
                    ramFacet = (MemoryFacet)c.getTarget();
                    ramFacet = this.getRamInfo(ramFacet);
                    continue;
                }
                if (memoryType.compareTo(MEMORY_TYPE_JVM) == 0) {
                    jvmMemoryFacet = (MemoryFacet)c.getTarget();
                    jvmMemoryFacet = this.getJVMMemoryInfo(jvmMemoryFacet);
                    continue;
                }
            }
            if (c instanceof HasPersistentMemory) {
                disk = (MemoryFacet)c.getTarget();
                disk = this.getDiskSpace(disk);
                continue;
            }
            consistsOfToRemove.add(c);
        }
        consistsOfList.removeAll(consistsOfToRemove);
        try {
            hostingNode = (HostingNode)resourceRegistryPublisher.updateResource((Resource)hostingNode);
        }
        catch (ResourceNotFoundException e) {
            consistsOfList.addAll(consistsOfToRemove);
            hostingNode = (HostingNode)resourceRegistryPublisher.createResource((Resource)hostingNode);
        }
        catch (ResourceAvailableInAnotherContextException | RelationAvailableInAnotherContextException e) {
            this.addToContext(hostingNode, SecurityTokenProvider.instance.get());
            hostingNode = (HostingNode)resourceRegistryPublisher.updateResource((Resource)hostingNode);
        }
        catch (ResourceRegistryException e) {
            logger.error("error trying to publish hosting node", (Throwable)e);
        }
        return hostingNode;
    }

    private HostingNode instantiateHostingNode() {
        logger.info("Creating {} {}", (Object)"HostingNode", (Object)"Resource");
        ContainerConfiguration containerConfiguration = this.context.configuration();
        UUID uuid = UUID.fromString(this.context.id());
        HostingNodeImpl hostingNode = new HostingNodeImpl();
        HeaderImpl header = new HeaderImpl(uuid);
        hostingNode.setHeader((Header)header);
        NetworkingFacetImpl networkingFacet = new NetworkingFacetImpl();
        try {
            networkingFacet.setIPAddress(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            logger.warn("unable to detect the IP address of the host");
        }
        String hostname = containerConfiguration.hostname();
        networkingFacet.setHostName(hostname);
        networkingFacet.setDomainName(HostingNodeManager.getDomain(hostname));
        networkingFacet.setAdditionalProperty("Port", (Object)containerConfiguration.port());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)hostingNode, (Facet)networkingFacet, null);
        hostingNode.addFacet((ConsistsOf)isIdentifiedBy);
        List<CPUFacet> cpuFacets = HostingNodeManager.getCPUFacets();
        for (CPUFacet cpuFacet : cpuFacets) {
            hostingNode.addFacet((Facet)cpuFacet);
        }
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        OperatingSystemMXBean mxbean = ManagementFactory.getOperatingSystemMXBean();
        softwareFacet.setGroup(mxbean.getName());
        softwareFacet.setName(mxbean.getArch());
        softwareFacet.setVersion(mxbean.getVersion());
        hostingNode.addFacet((Facet)softwareFacet);
        SimplePropertyFacet simplePropertyFacet = this.addEnvironmentVariables();
        hostingNode.addFacet((Facet)simplePropertyFacet);
        ContainerStateFacet containerStateFacet = this.getContainerStateFacet(null);
        hostingNode.addFacet((Facet)containerStateFacet);
        MemoryFacet ramFacet = this.getRamInfo(null);
        HasVolatileMemoryImpl hasVolatileRAMMemory = new HasVolatileMemoryImpl((Resource)hostingNode, ramFacet, null);
        hasVolatileRAMMemory.setAdditionalProperty(MEMORY_TYPE, (Object)MEMORY_TYPE_RAM);
        hostingNode.addFacet((ConsistsOf)hasVolatileRAMMemory);
        MemoryFacet jvmMemoryFacet = this.getJVMMemoryInfo(null);
        HasVolatileMemoryImpl hasVolatileJVMMemory = new HasVolatileMemoryImpl((Resource)hostingNode, jvmMemoryFacet, null);
        hasVolatileJVMMemory.setAdditionalProperty(MEMORY_TYPE, (Object)MEMORY_TYPE_JVM);
        hostingNode.addFacet((ConsistsOf)hasVolatileJVMMemory);
        MemoryFacet diskFacet = this.getDiskSpace(null);
        HasPersistentMemoryImpl hasPersistentMemory = new HasPersistentMemoryImpl((Resource)hostingNode, diskFacet, null);
        hostingNode.addFacet((ConsistsOf)hasPersistentMemory);
        logger.info("hostingNode instanciated");
        return hostingNode;
    }

    private ContainerStateFacet getContainerStateFacet(ContainerStateFacet containerStateFacet) {
        if (containerStateFacet == null) {
            containerStateFacet = new ContainerStateFacetImpl();
        }
        containerStateFacet.setValue(((ContainerState)this.context.lifecycle().state()).remoteForm());
        return containerStateFacet;
    }

    private MemoryFacet getDiskSpace(MemoryFacet memoryFacet) {
        if (memoryFacet == null) {
            memoryFacet = new MemoryFacetImpl();
        }
        long free = 0L;
        long total = 0L;
        try {
            FileStore fileStore = Files.getFileStore(Paths.get(this.context.configuration().persistence().location(), new String[0]));
            free = fileStore.getUsableSpace() / 0x100000L;
            total = fileStore.getTotalSpace() / 0x100000L;
        }
        catch (IOException ioe) {
            logger.warn("Unable to detect disk space information", (Throwable)ioe);
            memoryFacet.setAdditionalProperty(MESSAGE, (Object)"Unable to detect disk space information.");
        }
        memoryFacet.setUnit(MemoryFacet.MemoryUnit.MB);
        memoryFacet.setSize(total);
        memoryFacet.setUsed(total - free);
        return memoryFacet;
    }

    private MemoryFacet getRamInfo(MemoryFacet memoryFacet) {
        if (memoryFacet == null) {
            memoryFacet = new MemoryFacetImpl();
        }
        OperatingSystemMXBean mxbean = ManagementFactory.getOperatingSystemMXBean();
        com.sun.management.OperatingSystemMXBean sunmxbean = (com.sun.management.OperatingSystemMXBean)mxbean;
        long freeMemory = sunmxbean.getFreePhysicalMemorySize() / 0x100000L;
        long totalMemory = sunmxbean.getTotalPhysicalMemorySize() / 0x100000L;
        memoryFacet.setUnit(MemoryFacet.MemoryUnit.MB);
        memoryFacet.setSize(totalMemory);
        memoryFacet.setUsed(totalMemory - freeMemory);
        return memoryFacet;
    }

    private MemoryFacet getJVMMemoryInfo(MemoryFacet memoryFacet) {
        if (memoryFacet == null) {
            memoryFacet = new MemoryFacetImpl();
        }
        long jvmFreeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        long jvmTotalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        long jvmMaxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        memoryFacet.setUnit(MemoryFacet.MemoryUnit.MB);
        memoryFacet.setSize(jvmTotalMemory);
        memoryFacet.setUsed(jvmTotalMemory - jvmFreeMemory);
        memoryFacet.setAdditionalProperty(JVM_MAX_MEMORY, (Object)jvmMaxMemory);
        return memoryFacet;
    }

    private static String sanitizeKey(String key) {
        return key.trim().replace(" ", "_");
    }

    private SimplePropertyFacet addEnvironmentVariables() {
        ContainerConfiguration cfg = this.context.configuration();
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(cfg.properties());
        map.putAll(System.getenv());
        SimplePropertyFacetImpl simplePropertyFacet = new SimplePropertyFacetImpl();
        simplePropertyFacet.setName("ENVIRONMENT_VARIABLES");
        simplePropertyFacet.setValue("");
        for (Map.Entry entry : map.entrySet()) {
            String varname = (String)entry.getKey();
            if (varname.compareToIgnoreCase("CLASSPATH") == 0 || varname.compareToIgnoreCase("PATH") == 0 || varname.contains("SSH") || varname.contains("MAIL") || varname.compareToIgnoreCase("LS_COLORS") == 0) continue;
            simplePropertyFacet.setAdditionalProperty(HostingNodeManager.sanitizeKey((String)entry.getKey()), entry.getValue());
        }
        simplePropertyFacet.setAdditionalProperty("Java", (Object)System.getProperty("java.version"));
        SmartGearsConfiguration config = ProviderFactory.provider().smartgearsConfiguration();
        simplePropertyFacet.setAdditionalProperty("SmartGears", (Object)config.version());
        simplePropertyFacet.setAdditionalProperty("ghn-update-interval-in-secs", (Object)String.valueOf(cfg.publicationFrequency()));
        return simplePropertyFacet;
    }

    private static String getDomain(String hostname) {
        try {
            Pattern pattern = Pattern.compile("([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
            Matcher regexMatcher = pattern.matcher(hostname);
            if (regexMatcher.matches()) {
                return hostname;
            }
            return hostname.substring(hostname.indexOf(".") + 1);
        }
        catch (Exception e) {
            logger.warn("Error while getting domain from hostname");
            return hostname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CPUFacet> getCPUFacets() {
        ArrayList<CPUFacet> cpuFacets = new ArrayList<CPUFacet>();
        File file = new File("/proc/cpuinfo");
        if (!file.exists()) {
            logger.warn("cannot acquire CPU info (no /proc/cpuinfo)");
            return cpuFacets;
        }
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            CPUFacetImpl cpuFacet = null;
            while ((line = input.readLine()) != null) {
                if (line.startsWith(CPU_PROCESSOR)) {
                    cpuFacet = new CPUFacetImpl();
                    cpuFacets.add((CPUFacet)cpuFacet);
                }
                try {
                    if (line.contains(CPU_VENDOR_ID)) {
                        cpuFacet.setVendor(line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    if (line.contains(CPU_MODEL_NAME)) {
                        cpuFacet.setModel(line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    if (line.contains(CPU_CPU_MHZ)) {
                        cpuFacet.setClockSpeed(line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    if (line.contains(CPU_MODEL_T) || line.contains(CPU_MODEL_B)) {
                        cpuFacet.setAdditionalProperty(CPU_MODEL_NUMBER, (Object)line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    String[] nameValue = line.split(":");
                    cpuFacet.setAdditionalProperty(HostingNodeManager.sanitizeKey(nameValue[0]), (Object)line.split(":")[1].trim());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            logger.warn("unable to acquire CPU info", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.warn("unable to close stream", (Throwable)e);
                }
            }
        }
        return cpuFacets;
    }

    public String toString() {
        return "resource-management";
    }
}

