/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.events.Observes;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handler.resourceregistry.Constants;
import org.gcube.smartgears.handler.resourceregistry.ContextUtility;
import org.gcube.smartgears.handler.resourceregistry.resourcemanager.EServiceManager;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="resource-management")
public class EServiceHandler
extends ApplicationLifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(EServiceHandler.class);
    private ApplicationContext applicationContext;
    private ScheduledFuture<?> periodicUpdates;
    protected EServiceManager eServiceManager;

    public void onStart(ApplicationLifecycleEvent.Start event) {
        try {
            logger.info("{} onStart started", (Object)((Object)((Object)this)).getClass().getSimpleName());
            this.applicationContext = (ApplicationContext)event.context();
            this.init();
            this.registerObservers();
            this.schedulePeriodicUpdates();
            logger.info("{} onStart terminated", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
        catch (Throwable re) {
            logger.error("onStart failed", re);
        }
    }

    protected void removeResourceFromOldContexts(Set<UUID> startContexts, Set<UUID> resourceContexts) {
        HashSet<UUID> contextsToRemove = new HashSet<UUID>(resourceContexts);
        contextsToRemove.removeAll(startContexts);
        for (UUID contextToRemove : contextsToRemove) {
            try {
                this.eServiceManager.removeFromContext(contextToRemove);
            }
            catch (Exception e) {
                try {
                    String contextFullName = ContextCache.getInstance().getContextFullNameByUUID(contextToRemove);
                    logger.warn("Unable to remove {} from Context {} UUID {}", new Object[]{"EService", contextFullName, contextsToRemove, e});
                }
                catch (Exception ex) {
                    logger.warn("Unable to remove {} from Context with UUID {}.", new Object[]{"EService", contextsToRemove, e});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(EServiceHandler.class.getClassLoader());
            boolean create = true;
            Set startTokens = this.applicationContext.configuration().startTokens();
            HashSet<UUID> startContextsUUID = new HashSet<UUID>();
            ContextCache contextCache = ContextCache.getInstance();
            for (String token : startTokens) {
                ContextUtility.setContextFromToken(token);
                String contextFullName = ContextUtility.getContextName(token);
                UUID contextUUID = contextCache.getUUIDByFullName(contextFullName);
                startContextsUUID.add(contextUUID);
                try {
                    if (create) {
                        this.eServiceManager = new EServiceManager(this.applicationContext);
                        this.eServiceManager.createEService();
                        this.applicationContext.properties().add(new Property[]{new Property(Constants.ESERVICE_MANAGER_PROPERTY, (Object)this.eServiceManager)});
                        create = false;
                        continue;
                    }
                    this.eServiceManager.addToContext();
                }
                catch (Exception e) {
                    logger.error("Unable to add {} to current context ({})", new Object[]{this.eServiceManager.getEService(), ContextUtility.getContextName(token), e});
                }
            }
            Set<UUID> resourceContextsUUID = this.eServiceManager.getContextsUUID();
            this.removeResourceFromOldContexts(startContextsUUID, resourceContextsUUID);
        }
        catch (Throwable e) {
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            ContextUtility.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        logger.info("{} init() terminated", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    private void registerObservers() {
        this.applicationContext.events().subscribe(new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"activation", "stop", "failure"})
            void onChanged(ApplicationLifecycle lc) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                if (previousToken == null) {
                    ContextUtility.setContextFromToken((String)EServiceHandler.this.applicationContext.configuration().startTokens().iterator().next());
                }
                try {
                    Thread.currentThread().setContextClassLoader(EServiceHandler.class.getClassLoader());
                    EServiceHandler.this.eServiceManager.updateServiceStateFacet();
                }
                catch (Exception e) {
                    logger.error("Failed to update {} State", (Object)"EService", (Object)e);
                }
                finally {
                    ContextUtility.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"addToContext"})
            void addTo(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                if (previousToken == null) {
                    ContextUtility.setContextFromToken((String)EServiceHandler.this.applicationContext.configuration().startTokens().iterator().next());
                }
                try {
                    Thread.currentThread().setContextClassLoader(EServiceHandler.class.getClassLoader());
                    ContextUtility.setContextFromToken(token);
                    EServiceHandler.this.eServiceManager.addToContext();
                }
                catch (Exception e) {
                    logger.error("Failed to add {} to current context ({})", new Object[]{"EService", ContextUtility.getCurrentContextName(), e});
                }
                finally {
                    ContextUtility.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                if (previousToken == null) {
                    ContextUtility.setContextFromToken((String)EServiceHandler.this.applicationContext.configuration().startTokens().iterator().next());
                }
                try {
                    Thread.currentThread().setContextClassLoader(EServiceHandler.class.getClassLoader());
                    EServiceHandler.this.eServiceManager.removeFromContext();
                }
                catch (Exception e) {
                    logger.error("Failed to remove {} from current context ({})", new Object[]{"EService", ContextUtility.getCurrentContextName(), e});
                }
                finally {
                    ContextUtility.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }
        });
    }

    private void schedulePeriodicUpdates() {
        this.applicationContext.events().subscribe(new Object(){

            @Observes(value={"activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(ApplicationLifecycle lc) {
                if (EServiceHandler.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ApplicationState.active) {
                    logger.info("scheduling periodic updates of application {} EService", (Object)EServiceHandler.this.applicationContext.name());
                } else {
                    logger.info("resuming periodic updates of application {} EService", (Object)EServiceHandler.this.applicationContext.name());
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        String previousToken = SecurityTokenProvider.instance.get();
                        if (previousToken == null) {
                            ContextUtility.setContextFromToken((String)EServiceHandler.this.applicationContext.configuration().startTokens().iterator().next());
                        }
                        try {
                            EServiceHandler.this.eServiceManager.updateServiceStateFacet();
                        }
                        catch (Exception e) {
                            logger.error("Cannot complete periodic update of EService", (Throwable)e);
                        }
                        finally {
                            ContextUtility.setContextFromToken(previousToken);
                        }
                    }
                };
                EServiceHandler.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 20L, 20L, TimeUnit.MINUTES);
            }

            @Observes(value={"stop", "failure"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (EServiceHandler.this.periodicUpdates != null) {
                    logger.trace("stopping periodic updates of EService for application {} ", (Object)EServiceHandler.this.applicationContext.name());
                    try {
                        EServiceHandler.this.periodicUpdates.cancel(true);
                        EServiceHandler.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        logger.warn("could not stop periodic updates of EService for application {}", (Object)EServiceHandler.this.applicationContext.name(), (Object)e);
                    }
                }
            }
        });
    }

    public String toString() {
        return "resource-management";
    }
}

