package org.gcube.social_networking.social_networking_client_library;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.GenericType;

import org.apache.commons.lang.Validate;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.social_networking.social_networking_client_library.utils.HttpClient;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Posts client.
 * @author Ahmed Ibrahim at ISTI-CNR (ahmed.ibrahim@isti.cnr.it)
 */
public class CommentClient extends BaseClient{

    private static final String SUB_SERVICE_PATH = "2/comments/";
    private static Logger logger = LoggerFactory.getLogger(CommentClient.class);


    public CommentClient() throws Exception {
        super(SUB_SERVICE_PATH);
    }

    public Boolean addCommentLib(Comment comment){
        Validate.isTrue(comment != null, "Comment to write cannot be null");

        logger.debug("Request for writing comment");
        String thisMethodSignature = "add-comment-lib";
        String request =  getServiceEndpoint() + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, comment);
    }
    public Comment readCommentByIdLib(String commentid){
        Validate.isTrue(commentid != null, "Commentid to read cannot be null");

        logger.debug("Request for reading commentid");
        String thisMethodSignature = "read-comment-by-id-lib";
        String request =  getServiceEndpoint() + thisMethodSignature + "?commentid=" + commentid;
        return HttpClient.get(new GenericType<ResponseBean<Comment>>(){}, request);
    }
    public List<Comment> getAllCommentsByPostIdLib(String postid){
        Validate.isTrue(postid != null, "Postid to read cannot be null");

        logger.debug("Request for reading comments of post");
        String thisMethodSignature = "get-comments-by-post-id-lib";
        String request =  getServiceEndpoint() + thisMethodSignature + "?postid=" + postid;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Comment>>>(){}, request);
    }
    public List<Comment> getRecentCommentsByUserAndDateLib(final String userid,
                                                        final long timeInMillis){

        Validate.isTrue(userid != null, "username to read cannot be null");

        logger.debug("Request for reading recent comments of user");
        String thisMethodSignature = "get-recent-comments-by-user-and-date-lib";
        String request =  getServiceEndpoint() + thisMethodSignature + "?time=" + timeInMillis + "&username=" + userid;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Comment>>>(){}, request);
    }

    public Boolean editCommentLib(Comment comment){
        Validate.isTrue(comment != null, "Comment to write cannot be null");

        logger.debug("Request for writing comment");
        String thisMethodSignature = "edit-comment-lib";
        String request =  getServiceEndpoint() + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, comment);
    }

    public boolean deleteCommentLib(String commentid, String postid){
        Validate.isTrue(commentid != null, "Comment to write cannot be null");

        logger.debug("Request for del comment");
        String thisMethodSignature = "delete-comment-lib";
        String request =  getServiceEndpoint() + thisMethodSignature + "?commentid=" + commentid + "&postid=" + postid;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, postid);
    }
}
