package org.gcube.social_networking.social_networking_client_library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ws.rs.core.GenericType;

import org.apache.commons.lang.Validate;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.ex.*;
import org.gcube.social_networking.social_networking_client_library.utils.HttpClient;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * HashTags client.
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 * @author Ahmed Ibrahim at ISTI-CNR (ahmed.ibrahim@isti.cnr.it)
 */
public class HashTagClient extends BaseClient{

	private static final String SUB_SERVICE_PATH = "2/hashtags/";
	private static Logger logger = LoggerFactory.getLogger(HashTagClient.class);


	public HashTagClient() throws Exception {
		super(SUB_SERVICE_PATH);
	}

	/**
	 * Get hashtags and their count
	 * @return a map of type hashtag -> number
	 */
	public Map<String, Integer> getHashtagsCount(){
		logger.debug("Request for hastags");
		String thisMethodSignature = "get-hashtags-and-occurrences";
		String request =  getServiceEndpoint() + thisMethodSignature;
		return HttpClient.get(new GenericType<ResponseBean<HashMap<String, Integer>>>(){}, request);
	}





	//library api calls
	public boolean saveHashTagsLib(String feedid, String vreid, List<String> hashtags) {
		Validate.isTrue(hashtags != null, "hashtags to write cannot be null");

		logger.debug("Request for saving hashtags");
		String thisMethodSignature = "save-hashtag-lib";
		String request =  getServiceEndpoint() + thisMethodSignature + "?feedid=" + feedid + "&vreid=" + vreid;
		return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, hashtags);
	}

	public boolean deleteHashTagsLib(String feedid, String vreid, List<String> hashtags) {
		Validate.isTrue(hashtags != null, "hashtags to delete cannot be null");

		logger.debug("Request for deleting hashtags");
		String thisMethodSignature = "delete-hashtag-lib";
		String request =  getServiceEndpoint() + thisMethodSignature + "?feedid=" + feedid + "&vreid=" + vreid;
		return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, hashtags);
	}

	public boolean saveHashTagsCommentLib(String commentId, String vreid, List<String> hashtags){
		Validate.isTrue(hashtags != null, "hashtags to comment cannot be null");

		logger.debug("Request for saving hashtags comment");
		String thisMethodSignature = "save-hashtag-comment-lib";
		String request =  getServiceEndpoint() + thisMethodSignature + "?commentid=" + commentId + "&vreid=" + vreid;
		return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, hashtags);
	}

	public boolean deleteHashTagsCommentLib(String commentId, String vreid, List<String> hashtags) {
		Validate.isTrue(hashtags != null, "hashtags to comment delete cannot be null");

		logger.debug("Request for deleting hashtags comment");
		String thisMethodSignature = "delete-hashtag-comment-lib";
		String request =  getServiceEndpoint() + thisMethodSignature + "?commentid=" + commentId + "&vreid=" + vreid;
		return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, hashtags);
	}

	public Map<String, Integer> getVREHashtagsWithOccurrenceLib(String vreid) {
		logger.debug("Request for vre hashtags occurrences");
		String thisMethodSignature = "get-vre-hashtags-occurrences-lib";
		String request =  getServiceEndpoint() + thisMethodSignature + "?vreid=" + vreid;
		return HttpClient.get(new GenericType<ResponseBean<HashMap<String, Integer>>>(){}, request);
	}

	public Map<String, Integer> getVREHashtagsWithOccurrenceFilteredByTimeLib(String vreid, long timestamp){
		logger.debug("Request for vre hashtags occurrences with time");
		String thisMethodSignature = "get-vre-hashtags-occurrences-time-lib";
		String request =  getServiceEndpoint() + thisMethodSignature + "?vreid=" + vreid + "&time=" + timestamp;
		return HttpClient.get(new GenericType<ResponseBean<HashMap<String, Integer>>>(){}, request);
	}


	public List<Post> getVREPostsByHashtagLib(String vreid, String hashtag){
		hashtag = hashtag.substring(1);
		logger.debug("Request for vre of hashtags");
		String thisMethodSignature = "get-vre-post-by-hashtag-lib";
		String request =  getServiceEndpoint() + thisMethodSignature + "?vreid=" + vreid + "&hashtag=" + hashtag;
		return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
	}

}
