/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.social_networking_client_library;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.Validate;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteOperationResult;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.social_networking.social_networking_client_library.BaseClient;
import org.gcube.social_networking.social_networking_client_library.utils.HttpClient;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InviteClient
extends BaseClient {
    private static final String SUB_SERVICE_PATH = "2/invites/";
    private static Logger logger = LoggerFactory.getLogger(InviteClient.class);

    public InviteClient() throws Exception {
        super(SUB_SERVICE_PATH);
    }

    public String isExistingInviteLib(String vreid, String email) {
        Validate.isTrue((email != null ? 1 : 0) != 0, (String)"email to invite cannot be null");
        logger.debug("Request for inviting to vre");
        String thisMethodSignature = "is-existing-invite-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?vreid=" + vreid + "&email=" + email;
        return HttpClient.get(new GenericType<ResponseBean<String>>(){}, request);
    }

    public InviteOperationResult saveInviteLib(Invite invite) {
        Validate.isTrue((invite != null ? 1 : 0) != 0, (String)"likeid to unlike cannot be null");
        logger.debug("Request for saving invite");
        String thisMethodSignature = "save-invite-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<InviteOperationResult>>(){}, request, invite);
    }

    public Invite readInviteLib(String inviteid) {
        Validate.isTrue((inviteid != null ? 1 : 0) != 0, (String)"inviteid to read likes cannot be null");
        logger.debug("Request for reading invite");
        String thisMethodSignature = "read-invite-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?inviteid=" + inviteid;
        return HttpClient.get(new GenericType<ResponseBean<Invite>>(){}, request);
    }

    public boolean setInviteStatusLib(String vreid, String email, InviteStatus status) {
        Validate.isTrue((status != null ? 1 : 0) != 0, (String)"status to set cannot be null");
        logger.debug("Request for setting invite status");
        String thisMethodSignature = "set-invite-status-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?vreid=" + vreid + "&email=" + email;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, status);
    }

    public List<Invite> getInvitedEmailsByVRELib(String vreid, InviteStatus ... status) {
        Validate.isTrue((status != null ? 1 : 0) != 0, (String)"status to get cannot be null");
        logger.debug("Request for getting email invites");
        String thisMethodSignature = "get-invited-email-by-vre-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?vreid=" + vreid;
        return HttpClient.post(new GenericType<ResponseBean<ArrayList<Invite>>>(){}, request, status);
    }
}

