/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.social_networking_client_library;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.Validate;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.RangePosts;
import org.gcube.social_networking.social_networking_client_library.BaseClient;
import org.gcube.social_networking.social_networking_client_library.utils.HttpClient;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostClient
extends BaseClient {
    private static final String SUB_SERVICE_PATH = "2/posts/";
    private static Logger logger = LoggerFactory.getLogger(PostClient.class);

    public PostClient() throws Exception {
        super(SUB_SERVICE_PATH);
    }

    public List<Post> getUserPostsSinceDate(long timeInMillis) {
        Validate.isTrue((timeInMillis >= 0L ? 1 : 0) != 0, (String)"time cannot be negative");
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-user-since";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?time=" + timeInMillis;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getAllUserPosts() {
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-user";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getUserPostsQuantity(int quantity) {
        Validate.isTrue((quantity >= 0 ? 1 : 0) != 0, (String)"quantity cannot be negative");
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-user-quantity";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?quantity=" + quantity;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public Post writeUserPost(PostInputBean toWrite) {
        Validate.isTrue((toWrite != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for writing post");
        String thisMethodSignature = "write-post-user";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Post>>(){}, request, toWrite);
    }

    public List<Post> getAllApplicationPosts() {
        logger.debug("Request for getting posts");
        String thisMethodSignature = "get-posts-app";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public Post writeApplicationPost(PostInputBean toWrite) {
        Validate.isTrue((toWrite != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for writing application post");
        String thisMethodSignature = "write-post-app";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Post>>(){}, request, toWrite);
    }

    public List<Feed> getPostsVRE() {
        logger.debug("Request for getting posts vre");
        String thisMethodSignature = "get-posts-vre";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Feed>>>(){}, request);
    }

    public List<Post> getVREPosts() {
        logger.debug("Request for getting posts vre");
        String thisMethodSignature = "get-posts-vre";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getHashtagPosts(String hashtag) throws UnsupportedEncodingException {
        Validate.isTrue((hashtag != null ? 1 : 0) != 0, (String)"hashtag cannot be null");
        logger.debug("Request for getting posts with hashtag " + hashtag);
        String thisMethodSignature = "get-posts-by-hashtag";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?hashtag=" + URLEncoder.encode(hashtag, "UTF-8");
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getUserLikedPost() {
        logger.debug("Request for getting posts liked");
        String thisMethodSignature = "get-liked-posts";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<String> getUserLikedPostIds() {
        logger.debug("Request for getting posts liked");
        String thisMethodSignature = "get-id-liked-posts";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
    }

    public boolean saveUserPostLib(Post post) {
        Validate.isTrue((post != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for save user post");
        String thisMethodSignature = "save-user-post-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, post);
    }

    public boolean saveUserPostLib(Post post, List<Attachment> attachments) {
        Validate.isTrue((post != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for saving application post");
        String thisMethodSignature = "save-user-post-attachments-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        HashMap<Post, List<Attachment>> obj = new HashMap<Post, List<Attachment>>();
        obj.put(post, attachments);
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, obj);
    }

    public boolean saveAppPostLib(Post post, List<Attachment> attachments) {
        Validate.isTrue((post != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for saving application post");
        String thisMethodSignature = "save-app-post-attachments-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        HashMap<Post, List<Attachment>> obj = new HashMap<Post, List<Attachment>>();
        obj.put(post, attachments);
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, obj);
    }

    public boolean saveAppPostLib(Post post) {
        Validate.isTrue((post != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for saving application post");
        String thisMethodSignature = "save-app-post-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, post);
    }

    public boolean savePostToVRETimelineLib(String postkey, String vreid) {
        Validate.isTrue((postkey != null ? 1 : 0) != 0, (String)"Post to write cannot be null");
        logger.debug("Request for writing post to vretimeline");
        String thisMethodSignature = "save-post-to-vretimeline-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?postid=" + postkey + "&vreid=" + vreid;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, postkey);
    }

    public Post readPostLib(String postid) {
        logger.debug("Request for getting post with id");
        String thisMethodSignature = "read-post-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?postid=" + postid;
        return HttpClient.get(new GenericType<ResponseBean<Post>>(){}, request);
    }

    public List<Post> getRecentPostsByUserAndDateLib(String userid, long timeinmillis) {
        logger.debug("Request for getting recent posts by user");
        String thisMethodSignature = "get-recent-posts-by-user-date-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?userid=" + userid + "&time=" + timeinmillis;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public boolean deletePostLib(String postid) {
        Validate.isTrue((postid != null ? 1 : 0) != 0, (String)"feed to delete cannot be null");
        logger.debug("Request for delete user post");
        String thisMethodSignature = "delete-post-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?postid=" + postid;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, postid);
    }

    public List<Post> getAllPostsByUserLib(String userid) {
        logger.debug("Request for getting all posts by user");
        String thisMethodSignature = "get-all-posts-by-user-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?userid=" + userid;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getAllPostsByAppLib(String appid) {
        logger.debug("Request for getting all posts by app");
        String thisMethodSignature = "get-all-posts-by-app-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?appid=" + appid;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getRecentCommentedPostsByUserAndDateLib(String userid, long timeInMillis) {
        logger.debug("Request for getting recent commented posts by user and date");
        String thisMethodSignature = "get-recent-commented-posts-by-user-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?userid=" + userid + "&time=" + timeInMillis;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getAllPortalPrivacyLevelPostsLib() {
        logger.debug("Request for getting portal privacy level posts");
        String thisMethodSignature = "get-portal-privacy-level-posts-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getRecentPostsByUserLib(String userid, int quantity) {
        logger.debug("Request for getting recent posts by user");
        String thisMethodSignature = "get-recent-posts-by-user-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?userid=" + userid + "&quantity=" + quantity;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getAllPostsByVRELib(String vreid) {
        logger.debug("Request for getting all posts by vre");
        String thisMethodSignature = "get-all-posts-by-vre-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?vreid=" + vreid;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public List<Post> getRecentPostsByVRELib(String vreid, int quantity) {
        logger.debug("Request for getting recent posts by vre");
        String thisMethodSignature = "get-recent-posts-by-vre-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?vreid=" + vreid + "&quantity=" + quantity;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Post>>>(){}, request);
    }

    public RangePosts getRecentPostsByVREAndRangeLib(String vreid, int from, int quantity) {
        logger.debug("Request for getting recent posts by vre and range");
        String thisMethodSignature = "get-recent-posts-by-vre-range-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?vreid=" + vreid + "&from=" + from + "&quantity=" + quantity;
        return HttpClient.get(new GenericType<ResponseBean<RangePosts>>(){}, request);
    }

    public List<Attachment> getAttachmentsByFeedIdLib(String feedId) {
        logger.debug("Request for getting attachment by postid");
        String thisMethodSignature = "get-attachment-by-postid-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?postid=" + feedId;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Attachment>>>(){}, request);
    }

    public List<String> getAllVREIdsLib() {
        logger.debug("Request for getting all vre ids");
        String thisMethodSignature = "get-all-vre-ids-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
    }
}

