/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.socialnetworking.model.beans;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gcube.social_networking.socialnetworking.model.beans.Recipient;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="subject")
    @NotNull
    @Size(min=1, message="subject cannot be empty")
    private String subject;
    @JsonProperty(value="body")
    @NotNull
    @Size(min=1, message="body cannot be empty")
    private String body;
    @JsonProperty(value="sender")
    private String senderId;
    @JsonProperty(value="send_time")
    private Calendar sendTime;
    @JsonProperty(value="read")
    private boolean read;
    @JsonProperty(value="attachment_ids")
    private List<String> attachmentIds;
    @JsonProperty(value="recipients")
    @NotNull
    @Size(min=1, message="recipient cannot be empty")
    private List<Recipient> recipients;

    public Message() {
    }

    public Message(String id, String subject, String body, String senderId, Calendar sendTime, boolean read, List<String> attachmentIds, List<Recipient> recipients) {
        this.id = id;
        this.subject = subject;
        this.body = body;
        this.senderId = senderId;
        this.sendTime = sendTime;
        this.read = read;
        this.attachmentIds = attachmentIds;
        this.recipients = recipients;
    }

    public Message(String subject, String body, ArrayList<Recipient> recipients) {
        this.subject = subject;
        this.body = body;
        this.recipients = recipients;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public Calendar getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Calendar sendTime) {
        this.sendTime = sendTime;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public List<String> getAttachmentIds() {
        return this.attachmentIds;
    }

    public void setAttachmentIds(List<String> attachmentIds) {
        this.attachmentIds = attachmentIds;
    }

    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<Recipient> recipients) {
        this.recipients = recipients;
    }

    public String toString() {
        return "Message [id=" + this.id + ", subject=" + this.subject + ", body=" + this.body + ", senderId=" + this.senderId + ", sendTime=" + this.sendTime + ", read=" + this.read + ", attachmentIds=" + this.attachmentIds + ", recipients=" + this.recipients + "]";
    }
}

