package org.gcube.social_networking.socialnetworking.model.beans;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WorkspaceFileItemBean {

	@JsonProperty("id")
	@NotNull
	private String id;
	
	@JsonProperty("name")
	@NotNull
	private String name; 
	
	@JsonProperty("title")
	@NotNull
	private String title; 
	
	@JsonProperty("path")
	@NotNull
	private String path;
	
	@JsonProperty("parent")
	@NotNull
	private WorkspaceFolderBean parent;
	
	public WorkspaceFileItemBean() {
		super();
	}

	public WorkspaceFileItemBean(String id, String name, String title, String path, WorkspaceFolderBean parent) {
		super();
		this.id = id;
		this.name = name;
		this.title = title;
		this.path = path;
		this.parent = parent;
	}


	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public WorkspaceFolderBean getParent() {
		return parent;
	}

	public void setParent(WorkspaceFolderBean parent) {
		this.parent = parent;
	}

	public String getTitle() {
		return title;
	}


	public void setTitle(String title) {
		this.title = title;
	}


	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("WorkspaceFileItemBean [id=");
		builder.append(id);
		builder.append(", name=");
		builder.append(name);
		builder.append(", title=");
		builder.append(title);
		builder.append(", path=");
		builder.append(path);
		builder.append(", parent=");
		builder.append(parent);
		builder.append("]");
		return builder.toString();
	}



}
