package org.gcube.social_networking.socialnetworking.model.beans.workspace;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("ITEM_NEW")
public class AddedItemEvent extends WorkspaceEvent {
	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("fileItem")
	@NotNull(message="fileItem cannot be missing")
	private FileItemBean item;
	
	public AddedItemEvent() {
		super(WorkspaceEventType.ITEM_NEW);
		// TODO Auto-generated constructor stub
	}

	public AddedItemEvent(String userIdToNotify, FileItemBean item) {
		super(WorkspaceEventType.ITEM_NEW);
		this.userIdToNotify = userIdToNotify;
		this.item = item;
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public FileItemBean getItem() {
		return item;
	}

	public void setItem(FileItemBean item) {
		this.item = item;
	}

	@Override
	public String toString() {
		return "AddedItemEvent [userIdToNotify=" + userIdToNotify + ", item=" + item + "]";
	}

	
}
