package org.gcube.social_networking.socialnetworking.model.beans.workspace;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("FOLDER_UNSHARE")
public class UnsharedFolderEvent extends WorkspaceEvent {
	

	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("unsharedFolderId")
	@NotNull(message="folderid cannot be missing")
	private String unsharedFolderId;
	
	@JsonProperty("unsharedFolderName")
	@NotNull(message="unsharedFolderName cannot be missing")
	private String unsharedFolderName;	


	public UnsharedFolderEvent() {
		super(WorkspaceEventType.FOLDER_UNSHARE);
		// TODO Auto-generated constructor stub
	}

	public UnsharedFolderEvent(String userIdToNotify, String unsharedFolderId, String unsharedFolderName) {
		super(WorkspaceEventType.FOLDER_UNSHARE);
		this.userIdToNotify = userIdToNotify;
		this.unsharedFolderId = unsharedFolderId;
		this.unsharedFolderName = unsharedFolderName;
	}



	
	
	@Override
	public String toString() {
		return "UnsharedFolderEvent [userIdToNotify=" + userIdToNotify + ", unsharedFolderId="
				+ unsharedFolderId + ", unsharedFolderName=" + unsharedFolderName + ", Type=" + TYPE + "]";
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public String getUnsharedFolderId() {
		return unsharedFolderId;
	}

	public void setUnsharedFolderId(String unsharedFolderId) {
		this.unsharedFolderId = unsharedFolderId;
	}

	public String getUnsharedFolderName() {
		return unsharedFolderName;
	}

	public void setUnsharedFolderName(String unsharedFolderName) {
		this.unsharedFolderName = unsharedFolderName;
	}
}
	