package org.gcube.social_networking.socialnetworking.model.beans.workspace;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;

/**
 * The WorkspaceEvent super class
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, 
include = As.PROPERTY, property = "type") @JsonSubTypes({   
@JsonSubTypes.Type(value = SharedFolderEvent.class, name = "FOLDER_SHARE"),
@JsonSubTypes.Type(value = UnsharedFolderEvent.class, name = "FOLDER_UNSHARE"),
@JsonSubTypes.Type(value = AddedItemEvent.class, name = "ITEM_NEW") 
})
public abstract class WorkspaceEvent {
	protected final WorkspaceEventType TYPE;
	
	WorkspaceEvent(WorkspaceEventType TYPE) {
		this.TYPE = TYPE;
	}
	
	public WorkspaceEventType getType() {
		return TYPE;
	}
}
