package org.gcube.social_networking.socialnetworking.model.beans.workspace;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;


@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("FOLDER_SHARE")
public class SharedFolderEvent extends WorkspaceEvent {

	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("folderItem")
	@NotNull(message="folderItem cannot be missing")
	private FolderBean folder;
	
	
	public SharedFolderEvent() {
		super(WorkspaceEventType.FOLDER_SHARE);
	}

	public SharedFolderEvent(String userIdToNotify, FolderBean folder) {
		super(WorkspaceEventType.FOLDER_SHARE);
		this.userIdToNotify = userIdToNotify;
		this.folder = folder;
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public FolderBean getFolder() {
		return folder;
	}

	public void setFolder(FolderBean folder) {
		this.folder = folder;
	}

	@Override
	public String toString() {
		return "SharedFolderEvent [userIdToNotify=" + userIdToNotify + ", folder=" + folder + "]";
	}	
}
