/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.liferay.ws;

import jakarta.ws.rs.NotFoundException;
import java.rmi.ServerException;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.security.secrets.Secret;
import org.gcube.idm.common.is.InfrastrctureServiceClient;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.social_networking.liferay.ws.ServletContextClass;
import org.gcube.social_networking.utils.InfrastructureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayJSONWsCredentials {
    private static final Logger logger = LoggerFactory.getLogger(LiferayJSONWsCredentials.class);
    private static LiferayJSONWsCredentials singleton = new LiferayJSONWsCredentials();
    private String host;
    private String schema;
    private String user;
    private String password;
    private int port;
    private String notifierUserToken;
    private static final String RUNTIME_RESOURCE_NAME = "D4Science Infrastructure Gateway";
    private static final String CATEGORY = "Portal";
    private static final String END_POINT_NAME = "JSONWSUser";
    private static final boolean IS_ROOT_SERVICE = true;

    private LiferayJSONWsCredentials() {
        logger.debug("Building LiferayJSONWsCredentials object");
        this.loadNotifierToken();
        this.lookupPropertiesFromIs();
        logger.debug("LiferayJSONWsCredentials object built");
    }

    private void loadNotifierToken() {
        try {
            this.notifierUserToken = ServletContextClass.getNotifierToken();
            logger.debug("Token read " + this.notifierUserToken.substring(0, 5) + "*********************");
        }
        catch (Exception e) {
            logger.error("Failed to read notifier user token!", (Throwable)e);
        }
    }

    private void lookupPropertiesFromIs() {
        IsServerConfig cfg;
        Secret secret = InfrastructureUtils.getSecretForInfrastructure();
        try {
            cfg = InfrastrctureServiceClient.serviceConfigFromIS((String)RUNTIME_RESOURCE_NAME, (String)CATEGORY, (String)END_POINT_NAME, (boolean)true, (Secret)secret);
        }
        catch (NotFoundException | ServerException e) {
            logger.error("Unable to retrieve such service endpoint information!", e);
            e.printStackTrace();
            return;
        }
        this.host = cfg.getServerUrl();
        this.schema = cfg.getProperty("schema");
        this.user = cfg.getProperty("username");
        this.password = cfg.getProperty("password");
        this.port = Integer.valueOf(cfg.getProperty("port"));
        logger.debug("Bean built " + this.toString());
    }

    private List<ServiceEndpoint> getConfigurationFromIS() throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'D4Science Infrastructure Gateway'");
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        return toReturn;
    }

    public static LiferayJSONWsCredentials getSingleton() {
        return singleton;
    }

    public String getHost() {
        return this.host;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getNotifierUserToken() {
        return this.notifierUserToken;
    }

    public String toString() {
        return "LiferayJSONWsCredentials [host=" + this.host + ", schema=" + this.schema + ", user=" + this.user + ", password=" + this.password + ", port=" + this.port + ", notifierUserToken=" + this.notifierUserToken + "]";
    }
}

