/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class HelloWorldExceptionMapper
implements ExceptionMapper<Exception> {
    public Response toResponse(Exception exception) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        String exceptionMessage = exception.getMessage();
        try {
            if (exception.getCause() != null) {
                exceptionMessage = exception.getCause().getMessage();
            }
        }
        catch (Exception e) {
            exceptionMessage = exception.getMessage();
        }
        MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        if (WebApplicationException.class.isAssignableFrom(exception.getClass())) {
            Response gotResponse = ((WebApplicationException)exception).getResponse();
            status = Response.Status.fromStatusCode((int)gotResponse.getStatusInfo().getStatusCode());
        }
        return Response.status((Response.Status)status).entity((Object)exceptionMessage).type(mediaType).build();
    }
}

