/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.rmi.ServerException;
import java.util.HashMap;
import java.util.List;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.idm.client.IdmClientFactory;
import org.gcube.idm.client.IdmMeClient;
import org.gcube.idm.client.IdmUsersClient;
import org.gcube.idm.client.SearchUsersParams;
import org.gcube.idm.client.model.UserInfo;
import org.gcube.idm.common.models.IdmUser;
import org.gcube.social_networking.utils.InfrastructureUtils;

@Path(value="/idm")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class IdmRest {
    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    public Response test() throws ServerException {
        IdmClientFactory factory = IdmClientFactory.getSingleton();
        String token = InfrastructureUtils.getAccessToken();
        IdmMeClient client = factory.meClient(token);
        UserInfo user = client.getMe();
        HashMap<String, UserInfo> resp = new HashMap<String, UserInfo>();
        resp.put("result", user);
        try {
            String jsonData = new ObjectMapper().writeValueAsString(resp);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/{username}/")
    @Produces(value={"application/json"})
    public Response getUser(@PathParam(value="username") String username) throws ServerException {
        IdmClientFactory factory = IdmClientFactory.getSingleton();
        String token = InfrastructureUtils.getAccessToken();
        IdmUsersClient client = factory.userClient(token);
        UserInfo user = client.getUser(username);
        HashMap<String, UserInfo> resp = new HashMap<String, UserInfo>();
        resp.put("result", user);
        try {
            String jsonData = new ObjectMapper().writeValueAsString(resp);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/{search}/")
    @Produces(value={"application/json"})
    public Response searchUsers(@QueryParam(value="format") @DefaultValue(value="username") IdmUser.USERS_REPR format, @QueryParam(value="exact") @DefaultValue(value="true") Boolean exact, @QueryParam(value="username") String username, @QueryParam(value="firstName") String firstName, @QueryParam(value="lastName") String lastName, @QueryParam(value="email") String email, @QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="enabled") @DefaultValue(value="true") Boolean enabled) throws ServerException {
        List users;
        IdmClientFactory factory = IdmClientFactory.getSingleton();
        String token = InfrastructureUtils.getAccessToken();
        IdmUsersClient client = factory.userClient(token);
        SearchUsersParams params = new SearchUsersParams();
        if (exact != null) {
            params.exact = exact;
        }
        if (username != null) {
            params.username = username;
        }
        if (firstName != null) {
            params.firstName = firstName;
        }
        if (lastName != null) {
            params.lastName = lastName;
        }
        if (email != null) {
            params.email = email;
        }
        if (enabled != null) {
            params.enabled = enabled;
        }
        List resp = null;
        if (format.equals((Object)IdmUser.USERS_REPR.compact)) {
            resp = users = client.searchUsers(Integer.valueOf(firstResult), Integer.valueOf(maxResults), params);
        }
        if (format.equals((Object)IdmUser.USERS_REPR.full)) {
            resp = users = client.searchFullUsers(Integer.valueOf(firstResult), Integer.valueOf(maxResults), params);
        }
        if (format.equals((Object)IdmUser.USERS_REPR.username)) {
            resp = users = client.searchUsernames(Integer.valueOf(firstResult), Integer.valueOf(maxResults), params);
        }
        if (format.equals((Object)IdmUser.USERS_REPR.email)) {
            resp = users = client.searchEmails(Integer.valueOf(firstResult), Integer.valueOf(maxResults), params);
        }
        try {
            String jsonData = new ObjectMapper().writeValueAsString((Object)resp);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }
}

