/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.collections;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceGroup;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.gcube.social_networking.rest.collections.Collection;
import org.gcube.social_networking.socialnetworking.model.shared.Comment;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.socialnetworking.model.shared.Like;
import org.gcube.social_networking.socialnetworking.model.shared.Post;
import org.gcube.social_networking.socialnetworking.model.shared.PostWithAttachment;
import org.gcube.social_networking.socialnetworking.model.shared.PrivacyLevel;
import org.gcube.social_networking.utils.ResourceNames;
import org.gcube.social_networking.utils.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="posts")
@ResourceGroup(value="Posts APIs")
@ResourceLabel(value="Posts APIs")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class Posts
extends Collection {
    private static final Logger logger = LoggerFactory.getLogger(Posts.class);

    private Response ErrorHandler(Exception e, String action, String id) {
        ResponseBean responseBean = new ResponseBean();
        logger.info("Unable to " + action + " post {}.", (Object)id);
        logger.info(e.getMessage());
        responseBean.setMessage(e.getMessage());
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity(responseBean).build();
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPost(PostWithAttachment postWithAttachment) {
        try {
            logger.info("Creating post with id {}.", (Object)postWithAttachment.getId());
            return super.create((IdResource)postWithAttachment);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "create", postWithAttachment.getId());
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readPost(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Reading post with id {}.", (Object)id);
            return super.read(id, ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch", id);
        }
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response readPostsWithPrivacyLevel(@QueryParam(value="privacy") String privacyLevel) {
        try {
            if (privacyLevel == null || privacyLevel.isEmpty()) {
                privacyLevel = PrivacyLevel.PORTAL.toString();
            }
            logger.info("Reading post with privacy level = " + privacyLevel);
            return super.readWithParameter("privacy", privacyLevel, ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch", "portal privacy level");
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deletePost(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Deleting post with id {}.", (Object)id);
            return super.delete(id, ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "delete", id);
        }
    }

    @POST
    @Path(value="/{id}/comments")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createComment(@NotNull @PathParam(value="id") String id, @NotNull Comment comment) {
        try {
            logger.info("Creating comment with id {}.", (Object)comment.getId());
            return super.createChildOf(id, (IdResource)comment, ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "create comment to post", id);
        }
    }

    @GET
    @Path(value="/{id}/comments")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getCommentsOfPost(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Reading comments of post with id " + id);
            return super.readChildOf(id, ResourceNames.POST, ResourceNames.COMMENT);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch comments of", id);
        }
    }

    @DELETE
    @Path(value="/{id}/comments/{commentid}")
    @Produces(value={"application/json"})
    public Response deleteCommentOfPost(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="commentid") String commentid) {
        try {
            logger.info("Deleting comment of post with id {}.", (Object)id);
            return super.deleteChildOf(id, commentid, ResourceNames.POST, ResourceNames.COMMENT);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "delete comment of", id);
        }
    }

    @POST
    @Path(value="/{id}/likes")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createLike(@NotNull @PathParam(value="id") String id, @NotNull Like like) {
        try {
            logger.info("Creating like with id {}.", (Object)like.getId());
            return super.createChildOf(id, (IdResource)like, ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "create like to post", id);
        }
    }

    @GET
    @Path(value="/{id}/likes")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getLikesOfPost(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Reading likes of post with id " + id);
            return super.readChildOf(id, ResourceNames.POST, ResourceNames.LIKE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch likes of", id);
        }
    }

    @GET
    @Path(value="/{id}/attachments")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getAttachmentsOfPost(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Reading attachments of post with id " + id);
            return super.readChildOf(id, ResourceNames.POST, ResourceNames.Attachment);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "fetch attachments of", id);
        }
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePost(@NotNull @PathParam(value="id") String id, @NotNull Post post) {
        try {
            logger.info("Updating post with id {}", (Object)id);
            return super.update(id, (IdResource)post);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "update", id);
        }
    }

    @DELETE
    @Path(value="/{id}/likes/{likeid}")
    @Produces(value={"application/json"})
    public Response unlikePost(@NotNull @PathParam(value="id") String id, @NotNull @PathParam(value="likeid") String likeid) {
        try {
            String username = "";
            logger.info("Unliking post with id {}", (Object)id);
            return super.deleteChildOfWithParameter(id, likeid, "User", username, ResourceNames.POST, ResourceNames.LIKE);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "unlike", id);
        }
    }
}

