/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.server;

import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.social_networking.server.SocialDBDatastaxDriver;
import org.gcube.social_networking.server.SocialDBDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraConnection {
    private static final Logger logger = LoggerFactory.getLogger(CassandraConnection.class);
    private static SocialDBDriver store;
    private static CassandraConnection singleton;

    private CassandraConnection() {
        ApplicationContext ctx = ContextProvider.get();
        logger.info("Getting connection to cassandra");
        store = new SocialDBDatastaxDriver(ctx.container().configuration().infrastructure());
        logger.info("Connection to cassandra created");
    }

    public SocialDBDriver getDatabookStore() {
        return store;
    }

    public static CassandraConnection getInstance() {
        return singleton;
    }

    static {
        singleton = new CassandraConnection();
    }
}

