/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.server;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import java.rmi.ServerException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.NullArgumentException;
import org.gcube.social_networking.server.CassandraClusterConnection;
import org.gcube.social_networking.server.SocialDBDriver;
import org.gcube.social_networking.socialnetworking.model.shared.Attachment;
import org.gcube.social_networking.socialnetworking.model.shared.Comment;
import org.gcube.social_networking.socialnetworking.model.shared.Hashtag;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.socialnetworking.model.shared.Invite;
import org.gcube.social_networking.socialnetworking.model.shared.InviteOperationResult;
import org.gcube.social_networking.socialnetworking.model.shared.InviteStatus;
import org.gcube.social_networking.socialnetworking.model.shared.Like;
import org.gcube.social_networking.socialnetworking.model.shared.Notification;
import org.gcube.social_networking.socialnetworking.model.shared.NotificationChannelType;
import org.gcube.social_networking.socialnetworking.model.shared.NotificationPreference;
import org.gcube.social_networking.socialnetworking.model.shared.NotificationType;
import org.gcube.social_networking.socialnetworking.model.shared.Post;
import org.gcube.social_networking.socialnetworking.model.shared.PostType;
import org.gcube.social_networking.socialnetworking.model.shared.PostWithAttachment;
import org.gcube.social_networking.socialnetworking.model.shared.PrivacyLevel;
import org.gcube.social_networking.socialnetworking.model.shared.Vre;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.ColumnNameNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.CommentIDNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.InviteIDNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.InviteStatusNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.LikeIDNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.NotificationChannelTypeNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.NotificationIDNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.NotificationTypeNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.PostIDNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.PostTypeNotFoundException;
import org.gcube.social_networking.socialnetworking.model.shared.exceptions.PrivacyLevelTypeNotFoundException;
import org.gcube.social_networking.utils.ResourceNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocialDBDatastaxDriver
implements SocialDBDriver {
    private static final Logger _log = LoggerFactory.getLogger(SocialDBDatastaxDriver.class);
    private CassandraClusterConnection conn;

    protected CassandraClusterConnection getConnection() {
        return this.conn;
    }

    protected SocialDBDatastaxDriver(boolean dropSchema) {
        try {
            this.conn = new CassandraClusterConnection(dropSchema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SocialDBDatastaxDriver() {
        try {
            this.conn = new CassandraClusterConnection(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SocialDBDatastaxDriver(String infrastructureName) {
        try {
            this.conn = new CassandraClusterConnection(false, infrastructureName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Boolean create(IdResource resource) {
        String resourceName = resource.getClass().getSimpleName();
        if (resourceName.equals(ResourceNames.POST)) {
            try {
                return this.savePost((PostWithAttachment)resource);
            }
            catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (resourceName.equals(ResourceNames.NOTIFICATION)) {
            return this.saveNotification((Notification)resource);
        }
        return null;
    }

    @Override
    public Boolean createChildOf(String parentid, IdResource childResource, String parentResourceName) {
        String resourceName = childResource.getClass().getSimpleName();
        if (parentResourceName.equals(ResourceNames.VRE)) {
            if (resourceName.equals(ResourceNames.POST)) {
                try {
                    this.savePostToVRETimeline(parentid, (Post)childResource);
                }
                catch (PostIDNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            if (resourceName.equals(ResourceNames.COMMENT)) {
                try {
                    return this.saveComment(parentid, (Comment)childResource);
                }
                catch (PostIDNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (resourceName.equals(ResourceNames.LIKE)) {
                try {
                    return this.like(parentid, (Like)childResource);
                }
                catch (PostIDNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public Boolean BatchCreateChildOfWithParameter(String parentid, String parameterName, String parameterValue, List<IdResource> childResource, String parentResourceName, String childResourceName) {
        if (parentResourceName.equals(ResourceNames.VRE) && childResourceName.equals(ResourceNames.HASHTAG)) {
            ArrayList<String> hashtags = new ArrayList<String>();
            for (IdResource r : childResource) {
                Hashtag h = (Hashtag)r;
                hashtags.add(h.getHashtag());
            }
            if (parameterName.equals(ResourceNames.POST)) {
                try {
                    return this.saveHashTags(parameterValue, parentid, hashtags);
                }
                catch (PostIDNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (parameterName.equals(ResourceNames.COMMENT)) {
                try {
                    return this.saveHashTagsComment(parameterValue, parentid, hashtags);
                }
                catch (CommentIDNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public IdResource read(String id, String resourceName) {
        if (resourceName.equals(ResourceNames.POST)) {
            try {
                return this.readPost(id);
            }
            catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (resourceName.equals(ResourceNames.NOTIFICATION)) {
            try {
                return this.readNotification(id);
            }
            catch (ColumnNameNotFoundException | NotificationIDNotFoundException | NotificationTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (resourceName.equals(ResourceNames.COMMENT)) {
            try {
                return this.readComment(id);
            }
            catch (CommentIDNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (resourceName.equals(ResourceNames.INVITE)) {
            try {
                return this.readInvite(id);
            }
            catch (InviteIDNotFoundException | InviteStatusNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Boolean check(String id, String parameterName, String parameterValue, String resourceName) {
        return null;
    }

    @Override
    public Boolean checkChildOf(String parentid, String parameterName, String parameterValue, String parentResourceName, String childResourceName) {
        if (parentResourceName.equals("User") && childResourceName.equals(ResourceNames.NOTIFICATION)) {
            if (parameterName.equals("unread_message")) {
                if (parameterValue.equals(String.valueOf(true))) {
                    try {
                        return this.checkUnreadMessagesNotifications(parentid);
                    }
                    catch (ColumnNameNotFoundException | NotificationIDNotFoundException | NotificationTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (parameterName.equals("unread") && parameterValue.equals(String.valueOf(true))) {
                try {
                    return this.checkUnreadNotifications(parentid);
                }
                catch (ColumnNameNotFoundException | NotificationTypeNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public List<IdResource> readAll(String resourceName) {
        if (resourceName.equals(ResourceNames.VRE)) {
            return new ArrayList<Vre>(this.getAllVREIds());
        }
        return null;
    }

    @Override
    public List<IdResource> readChildOf(String parentid, String parentResourceName, String childResourceName) {
        if (parentResourceName.equals(ResourceNames.POST)) {
            if (childResourceName.equals(ResourceNames.COMMENT)) {
                return this.getAllChildrenByPost(parentid, "Comments");
            }
            if (childResourceName.equals(ResourceNames.LIKE)) {
                return this.getAllChildrenByPost(parentid, "Likes");
            }
            if (childResourceName.equals(ResourceNames.Attachment)) {
                return this.getAllChildrenByPost(parentid, "Attachments");
            }
        } else if (parentResourceName.equals(ResourceNames.VRE)) {
            if (childResourceName.equals(ResourceNames.POST)) {
                try {
                    return new ArrayList<Post>(this.getAllPostsByVRE(parentid));
                }
                catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (childResourceName.equals(ResourceNames.HASHTAG)) {
                return new ArrayList<Hashtag>(this.getVREHashtagsWithOccurrence(parentid));
            }
        } else if (parentResourceName.equals("User")) {
            if (childResourceName.equals(ResourceNames.POST)) {
                try {
                    return new ArrayList<Post>(this.getAllPostsByUser(parentid));
                }
                catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (childResourceName.equals(ResourceNames.NOTIFICATION_PREFERENCES)) {
                try {
                    return new ArrayList<NotificationPreference>(this.getUserNotificationPreferences(parentid));
                }
                catch (NotificationChannelTypeNotFoundException | NotificationTypeNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (parentResourceName.equals("App") && childResourceName.equals(ResourceNames.POST)) {
            try {
                return new ArrayList<Post>(this.getAllPostsByApp(parentid));
            }
            catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public List<IdResource> readChildOfWithParameter(String parentid, String parameterName, String parameterValue, String parentResourceName, String childResourceName) {
        if (parentResourceName.equals(ResourceNames.VRE)) {
            if (childResourceName.equals(ResourceNames.POST)) {
                if (parameterName.equals("recent_limit")) {
                    try {
                        return new ArrayList<Post>(this.getRecentPostsByVRE(parentid, Integer.parseInt(parameterValue)));
                    }
                    catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (parameterName.equals("hashtag")) {
                    try {
                        return new ArrayList<Post>(this.getVREPostsByHashtag(parentid, parameterValue));
                    }
                    catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (childResourceName.equals(ResourceNames.HASHTAG)) {
                if (parameterName.equals("time")) {
                    return new ArrayList<Hashtag>(this.getVREHashtagsWithOccurrenceFilteredByTime(parentid, Long.parseLong(parameterValue)));
                }
            } else if (childResourceName.equals(ResourceNames.INVITE)) {
                if (parameterName.equals("status")) {
                    String status = parameterValue.replace("[", "");
                    status = status.replace("]", "");
                    status = status.replace(" ", "");
                    String[] statusArray = status.split(",");
                    ArrayList<InviteStatus> inviteStatusList = new ArrayList<InviteStatus>();
                    for (String s : statusArray) {
                        inviteStatusList.add(InviteStatus.valueOf((String)s));
                    }
                    try {
                        return new ArrayList<Invite>(this.getInvitedEmailsByVRE(parentid, inviteStatusList));
                    }
                    catch (InviteIDNotFoundException | InviteStatusNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (parameterName.equals("email")) {
                    ArrayList<Invite> toReturn = new ArrayList<Invite>();
                    toReturn.add(this.isExistingInvite(parentid, parameterValue));
                    return new ArrayList<IdResource>(toReturn);
                }
            }
        } else if (parentResourceName.equals("User")) {
            if (childResourceName.equals(ResourceNames.POST)) {
                if (parameterName.equals("recent_comment")) {
                    try {
                        return new ArrayList<Post>(this.getRecentCommentedPostsByUserAndDate(parentid, Long.parseLong(parameterValue)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (parameterName.equals("recent_like")) {
                    return new ArrayList<Post>(this.getRecentLikedPostsByUserAndDate(parentid, Integer.parseInt(parameterValue)));
                }
                if (parameterName.equals("all_like")) {
                    try {
                        return new ArrayList<Post>(this.getAllLikedPostsByUser(parentid, Integer.parseInt(parameterValue)));
                    }
                    catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (parameterName.equals("recent_limit")) {
                    try {
                        return new ArrayList<Post>(this.getRecentPostsByUser(parentid, Integer.parseInt(parameterValue)));
                    }
                    catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (parameterName.equals("time")) {
                    return new ArrayList<Post>(this.getRecentPostsByUserAndDate(parentid, Long.parseLong(parameterValue)));
                }
            } else if (childResourceName.equals(ResourceNames.NOTIFICATION)) {
                if (parameterName.equals("recent_limit")) {
                    try {
                        return new ArrayList<Notification>(this.getAllNotificationByUser(parentid, Integer.parseInt(parameterValue)));
                    }
                    catch (ColumnNameNotFoundException | NotificationTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (parameterName.equals("unread")) {
                    try {
                        return new ArrayList<Notification>(this.getUnreadNotificationsByUser(parentid));
                    }
                    catch (ColumnNameNotFoundException | NotificationIDNotFoundException | NotificationTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (parameterName.equals("notification_type")) {
                    try {
                        ArrayList<IdResource> resources = new ArrayList<IdResource>();
                        List<NotificationChannelType> notificationChannelTypes = this.getUserNotificationChannels(parentid, NotificationType.valueOf((String)parameterName));
                        for (final NotificationChannelType n : notificationChannelTypes) {
                            IdResource x = new IdResource(){
                                String notChannel;
                                {
                                    this.notChannel = n.toString();
                                }

                                public String getId() {
                                    return this.notChannel;
                                }
                            };
                            resources.add(x);
                        }
                        return resources;
                    }
                    catch (NotificationChannelTypeNotFoundException | NotificationTypeNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (childResourceName.equals(ResourceNames.COMMENT) && parameterName.equals("time")) {
                try {
                    return new ArrayList<Comment>(this.getRecentCommentsByUserAndDate(parentid, Integer.parseInt(parameterValue)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public List<IdResource> readWithParameter(String parameterName, String parameterValue, String resourceName) {
        block4: {
            if (resourceName.equals(Post.class.getSimpleName())) {
                try {
                    if (parameterName.equals("privacy")) {
                        return new ArrayList<Post>(this.getAllPostsWithPrivacy(parameterValue));
                    }
                    break block4;
                }
                catch (ColumnNameNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public Boolean delete(String id, String resourceName) {
        if (resourceName.equals(Post.class.getSimpleName())) {
            try {
                return this.deletePost(id);
            }
            catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Boolean deleteChildOf(String parentid, String childid, String childResourceName) {
        if (childResourceName.equals(Comment.class.getSimpleName())) {
            try {
                return this.deleteComment(parentid, childid);
            }
            catch (ColumnNameNotFoundException | CommentIDNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Boolean deleteWithParameter(String parameterName, String parameterValue, String resourceName) {
        return null;
    }

    @Override
    public Boolean BatchDeleteChildOfWithParameter(String parentid, String parameterName, String parameterValue, List<IdResource> childResource, String parentResourceName, String childResourceName) {
        if (parentResourceName.equals(ResourceNames.VRE) && childResourceName.equals(ResourceNames.HASHTAG)) {
            ArrayList<String> hashtags = new ArrayList<String>();
            for (IdResource r : childResource) {
                Hashtag h = (Hashtag)r;
                hashtags.add(h.getHashtag());
            }
            if (parameterName.equals(ResourceNames.POST)) {
                try {
                    return this.deleteHashTags(parameterValue, parentid, hashtags);
                }
                catch (PostIDNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (parameterName.equals(ResourceNames.COMMENT)) {
                try {
                    return this.deleteHashTagsComment(parameterValue, parentid, hashtags);
                }
                catch (CommentIDNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public Boolean deleteChildOfWithParameter(String parentid, String childid, String parameterName, String parameterValue, String parentResourceName, String childResourceName) {
        if (parentResourceName.equals(ResourceNames.POST) && childResourceName.equals(ResourceNames.LIKE) && parameterName.equals("User")) {
            try {
                return this.unlike(parameterValue, childid, parentid);
            }
            catch (ColumnNameNotFoundException | LikeIDNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Boolean update(IdResource resource) {
        String resourceName = resource.getClass().getSimpleName();
        if (resourceName.equals(Notification.class.getSimpleName())) {
            try {
                return this.setNotificationRead(resource.getId());
            }
            catch (ColumnNameNotFoundException | NotificationIDNotFoundException | NotificationTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (resourceName.equals(Comment.class.getSimpleName())) {
            try {
                return this.editComment((Comment)resource);
            }
            catch (ColumnNameNotFoundException | CommentIDNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Boolean updateChildOf(String parentid, String childid, IdResource childResource, String parentResourceName) {
        String childResourceName;
        if (parentResourceName.equals("User") && (childResourceName = childResource.getClass().getSimpleName()).equals(ResourceNames.NOTIFICATION)) {
            Notification notification = (Notification)childResource;
            try {
                if (notification.isRead()) {
                    return this.setAllNotificationReadByUser(parentid);
                }
            }
            catch (ColumnNameNotFoundException | NotificationTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Boolean BatchUpdateChildOf(String parentid, List<IdResource> childResource, String parentResourceName) {
        String childResourceName;
        if (parentResourceName.equals("User") && (childResourceName = childResource.get(0).getClass().getSimpleName()).equals(ResourceNames.NOTIFICATION_PREFERENCES)) {
            ArrayList<NotificationPreference> notificationPreferences = new ArrayList<NotificationPreference>();
            for (IdResource r : childResource) {
                notificationPreferences.add((NotificationPreference)r);
            }
            return this.setUserNotificationPreferences(parentid, notificationPreferences);
        }
        return null;
    }

    @Override
    public Boolean updateWithParameter(String parameterName, String parameterValue, IdResource resource) {
        return null;
    }

    @Override
    public Boolean updateChildOfWithParameter(String parentid, String parameterName, String parameterValue, IdResource childResource, String parentResourceName) {
        String childResourceName;
        if (parentResourceName.equals(ResourceNames.VRE) && (childResourceName = childResource.getClass().getSimpleName()).equals(ResourceNames.INVITE) && parameterName.equals("email")) {
            Invite invite = (Invite)childResource;
            try {
                return this.setInviteStatus(parentid, parameterValue, invite.getStatus());
            }
            catch (InviteIDNotFoundException | InviteStatusNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean savePost(PostWithAttachment postWithAttachment) throws PostTypeNotFoundException, ColumnNameNotFoundException, PostIDNotFoundException, PrivacyLevelTypeNotFoundException {
        CqlSession session;
        Post post = postWithAttachment.getPost();
        List attachments = postWithAttachment.getAttachments();
        if (attachments != null && !attachments.isEmpty()) {
            post.setMultiFileUpload(true);
        }
        if (SocialDBDatastaxDriver.existRecordbyId(session = this.conn.getKeyspaceSession(), post.getKey(), "Posts", "postid")) {
            return false;
        }
        List<BoundStatement> boundStatements = this.insertIntoPosts(session, post);
        BoundStatement stmt2 = post.isApplicationPost() ? SocialDBDatastaxDriver.createAppTimelineEntry(session).bind(new Object[]{post.getEntityId(), post.getTime().toInstant(), UUID.fromString(post.getKey())}) : SocialDBDatastaxDriver.createUserTimelineEntry(session).bind(new Object[]{post.getEntityId(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
        boundStatements.add(stmt2);
        if (post.getVreid() != null && post.getVreid().compareTo("") != 0) {
            BoundStatement stmt3 = SocialDBDatastaxDriver.createVreTimelineEntry(session).bind(new Object[]{post.getVreid(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
            boundStatements.add(stmt3);
        }
        for (Attachment attachment : attachments) {
            boundStatements.addAll(this.insertIntoAttachments(session, attachment, post.getKey()));
        }
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().addAll(boundStatements);
        try {
            boolean savePostResult = session.execute((Statement)writeBatch).wasApplied();
            return savePostResult;
        }
        catch (Exception e) {
            _log.error("Failed to save post with id {} because {} ", (Object)post.getKey(), (Object)e.getMessage());
            _log.info("Cleaning the mess");
            ArrayList<BoundStatement> cleanMess = new ArrayList<BoundStatement>();
            if (SocialDBDatastaxDriver.existRecordbyId(session, post.getKey(), "Posts", "postid")) {
                cleanMess.add(SocialDBDatastaxDriver.deletePostEntry(session).bind(new Object[]{UUID.fromString(post.getKey())}));
            }
            for (Attachment attachment : attachments) {
                if (!SocialDBDatastaxDriver.existRecordbyId(session, attachment.getId(), "Attachments", "attachid")) continue;
                cleanMess.add(SocialDBDatastaxDriver.deleteAttachmentEntry(session).bind(new Object[]{UUID.fromString(attachment.getId())}));
            }
            BatchStatement cleanMessBatch = SocialDBDatastaxDriver.getBatch().addAll(cleanMess);
            boolean clean = false;
            while (!clean) {
                clean = session.execute((Statement)cleanMessBatch).wasApplied();
            }
            e.printStackTrace();
            return false;
        }
    }

    private Post readPost(String postid) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, PostIDNotFoundException, ColumnNameNotFoundException {
        Post post;
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            post = SocialDBDatastaxDriver.findPostById(postid, session).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return post;
    }

    private List<Post> getAllPostsWithPrivacy(String privacyLevel) throws PostTypeNotFoundException, ColumnNameNotFoundException, PrivacyLevelTypeNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Posts").all().whereColumn("privacy").isEqualTo((Term)QueryBuilder.bindMarker())).limit(20).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{privacyLevel}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            Post toAdd = SocialDBDatastaxDriver.readPostFromRow(row);
            if (toAdd.getType() != PostType.TWEET && toAdd.getType() != PostType.SHARE && toAdd.getType() != PostType.PUBLISH) continue;
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    private boolean deletePost(String postid) throws PostIDNotFoundException, PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException {
        Post toDelete = this.readPost(postid);
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.updatePostEntry(session, "type").bind(new Object[]{PostType.DISABLED.toString(), UUID.fromString(toDelete.getKey())}));
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            _log.error("Delete Post ERROR for postid " + postid);
            return false;
        }
        _log.info("Delete Post OK");
        return true;
    }

    private List<IdResource> getAllChildrenByPost(String postid, String childType) {
        ResultSet result = null;
        ArrayList<IdResource> toReturn = new ArrayList<IdResource>();
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)childType).all().whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(postid)}));
            for (Row row : result) {
                Like toAdd;
                Object object = childType.equals("Likes") ? SocialDBDatastaxDriver.readLikeFromRow(row) : (childType.equals("Comments") ? SocialDBDatastaxDriver.readCommentFromRow(row) : (toAdd = childType.equals("Attachments") ? SocialDBDatastaxDriver.readAttachmentFromRow(row) : null));
                if (toAdd == null) {
                    throw new Exception("No child resource named " + childType);
                }
                toReturn.add((IdResource)toAdd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private boolean saveNotification(Notification n) {
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoNotifications(session, n);
        BoundStatement stmt2 = SocialDBDatastaxDriver.createUserNotificationsEntry(session).bind(new Object[]{n.getUserid(), n.getTime().toInstant(), UUID.fromString(n.getKey())});
        boundStatements.add(stmt2);
        BoundStatement stmt3 = SocialDBDatastaxDriver.createUnreadNotificationEntry(session).bind(new Object[]{n.getUserid(), n.getTime().toInstant(), UUID.fromString(n.getKey())});
        boundStatements.add(stmt3);
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().addAll(boundStatements);
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Notification readNotification(String notificationid) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        Notification toReturn = new Notification();
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            toReturn = SocialDBDatastaxDriver.findNotById(notificationid, session).get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private boolean setNotificationRead(String notificationidToSet) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        Notification toSet = this.readNotification(notificationidToSet);
        if (toSet == null) {
            throw new NotificationIDNotFoundException("The specified notification to set Read with id: " + notificationidToSet + " does not exist");
        }
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.updateNotificationEntry(session, "isread").bind(new Object[]{true, UUID.fromString(notificationidToSet)})).add((BatchableStatement)SocialDBDatastaxDriver.deleteUnreadNotEntry(session).bind(new Object[]{toSet.getUserid(), toSet.getTime().toInstant()}));
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            return res;
        }
        catch (Exception e) {
            _log.error("ERROR while setting Notification " + notificationidToSet + " to read.");
            return false;
        }
    }

    private boolean saveComment(String postid, Comment comment) throws PostIDNotFoundException {
        Post toComment = null;
        comment.setPostid(postid);
        try {
            toComment = this.readPost(postid);
            if (toComment == null) {
                throw new PostIDNotFoundException("Could not find Post with id " + postid + " to associate this comment", postid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        _log.info("Writing comment : {}", (Object)comment.toString());
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoComments(session, comment);
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().addAll(boundStatements);
        try {
            ResultSet res = session.execute((Statement)writeBatch);
            for (ExecutionInfo ex : res.getExecutionInfos()) {
                _log.info("Writing comment result errors: {}", (Object)ex.getErrors());
                _log.info("Writing comment result payload: {}", (Object)ex.getIncomingPayload());
            }
            _log.info("Writing comment result executed?: {}", (Object)res.wasApplied());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        boolean updateCommentNoResult = this.updatePostCommentsCount(toComment, true);
        return updateCommentNoResult;
    }

    private Comment readComment(String commentId) throws CommentIDNotFoundException {
        Comment toReturn = null;
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Comments").all().whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(commentId)}));
            toReturn = SocialDBDatastaxDriver.readCommentFromRow((Row)result.one());
            if (toReturn == null) {
                throw new CommentIDNotFoundException("The requested commentId: " + commentId + " is not existing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private boolean editComment(Comment comment2Edit) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, PostIDNotFoundException {
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.updateCommentEntry(session, "comment").bind(new Object[]{comment2Edit.getText(), UUID.fromString(comment2Edit.getKey())})).add((BatchableStatement)SocialDBDatastaxDriver.updateCommentEntry(session, "isedit").bind(new Object[]{true, UUID.fromString(comment2Edit.getKey())})).add((BatchableStatement)SocialDBDatastaxDriver.updateCommentEntry(session, "lastedittime").bind(new Object[]{new Date().toInstant(), UUID.fromString(comment2Edit.getKey())}));
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            _log.info("Comments update OK to: " + comment2Edit.getText());
            return res;
        }
        catch (Exception e) {
            _log.error("Comments update NOT OK ");
            return false;
        }
    }

    private boolean deleteComment(String Postid, String commentid) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, PostIDNotFoundException {
        Post toUpdate = this.readPost(Postid);
        boolean updateCommentNoResult = false;
        updateCommentNoResult = this.updatePostCommentsCount(toUpdate, false);
        if (updateCommentNoResult) {
            CqlSession session = this.conn.getKeyspaceSession();
            BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.deleteCommentEntry(session).bind(new Object[]{UUID.fromString(commentid)}));
            try {
                session.execute((Statement)writeBatch);
            }
            catch (Exception e) {
                _log.error("Comment Delete FAILED for " + commentid + " from Post " + Postid);
                e.printStackTrace();
            }
            _log.trace("Comment Deleted " + commentid + " from Post " + Postid);
        }
        return updateCommentNoResult;
    }

    private boolean like(String postid, Like like) throws PostIDNotFoundException {
        Post toLike = null;
        like.setPostid(postid);
        try {
            toLike = this.readPost(postid);
            if (toLike == null) {
                throw new PostIDNotFoundException("Could not find post with id " + postid + " to associate this like", postid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.isPostLiked(like.getUserid(), postid)) {
            _log.info("User " + like.getUserid() + " already liked post " + postid);
            return true;
        }
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoLikes(session, like);
        BoundStatement stmt2 = SocialDBDatastaxDriver.createNewUserLikesEntry(session).bind(new Object[]{like.getUserid(), UUID.fromString(like.getKey()), UUID.fromString(like.getPostid())});
        boundStatements.add(stmt2);
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().addAll(boundStatements);
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return this.updatePostLikesCount(toLike, true);
    }

    private boolean unlike(String userid, String likeid, String postId) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, LikeIDNotFoundException, PostIDNotFoundException {
        Post toUpdate = this.readPost(postId);
        boolean updateLikeNoResult = false;
        updateLikeNoResult = this.updatePostLikesCount(toUpdate, false);
        if (updateLikeNoResult) {
            CqlSession session = this.conn.getKeyspaceSession();
            BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.deleteLikeEntry(session).bind(new Object[]{UUID.fromString(likeid)})).add((BatchableStatement)SocialDBDatastaxDriver.deleteUserLikeEntry(session).bind(new Object[]{userid, UUID.fromString(likeid)}));
            try {
                session.execute((Statement)writeBatch);
            }
            catch (Exception e) {
                _log.error("Like Delete FAILED for " + likeid + " from post " + postId);
                e.printStackTrace();
            }
            _log.trace("Unlike ok for " + likeid + " from post " + postId);
        }
        return updateLikeNoResult;
    }

    private List<Post> getAllPostsByVRE(String vreid) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, PostIDNotFoundException {
        return this.getPostsByIds(this.getVREPostIds(vreid));
    }

    private List<Vre> getAllVREIds() {
        HashSet<String> ids = new HashSet<String>();
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(QueryBuilder.selectFrom((String)"VRETimeline").column("vreid").all().build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            ids.add(row.getString("vreid"));
        }
        ArrayList<Vre> toReturn = new ArrayList<Vre>();
        for (String id : ids) {
            Vre vre = new Vre(id);
            toReturn.add(vre);
        }
        _log.debug("VRE ids are " + ids);
        return toReturn;
    }

    private boolean savePostToVRETimeline(String vreid, Post post) throws PostIDNotFoundException {
        Post toCheck;
        try {
            toCheck = this.readPost(post.getKey());
            if (toCheck == null) {
                throw new PostIDNotFoundException("Could not find Post with id " + post.getKey(), post.getKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.createVreTimelineEntry(session).bind(new Object[]{vreid, toCheck.getTime().toInstant(), UUID.fromString(toCheck.getKey())}));
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private List<Hashtag> getVREHashtagsWithOccurrence(String vreid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtagsCounter").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Hashtag> toReturn = new ArrayList<Hashtag>();
        List rows = result.all();
        for (Row row : rows) {
            Integer curValue = (int)row.getLong("count");
            if (curValue <= 0) continue;
            Hashtag hashtag = new Hashtag(row.getString("hashtag"));
            hashtag.setOccurrence(curValue.intValue());
            toReturn.add(hashtag);
        }
        return toReturn;
    }

    private List<Hashtag> getVREHashtagsWithOccurrenceFilteredByTime(String vreid, long timestamp) {
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtagsCounter").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Integer> check = new HashMap<String, Integer>();
        ArrayList<Hashtag> toReturn = new ArrayList<Hashtag>();
        List rows = result.all();
        for (Row row : rows) {
            int curValue;
            String hashtag = row.getString("hashtag");
            List<Post> posts = null;
            try {
                posts = this.getVREPostsByHashtag(vreid, hashtag);
            }
            catch (Exception e) {
                _log.error("Unable to retrieve the list of posts for hashtag" + hashtag + " in vre " + vreid);
                continue;
            }
            if (posts.isEmpty()) {
                _log.info("There are no posts containing hashtag " + hashtag + " in  vre " + vreid);
                continue;
            }
            Collections.sort(posts, Collections.reverseOrder());
            if (posts.get(0).getTime().getTime() < timestamp || (curValue = (int)row.getLong("count")) <= 0) continue;
            check.put(row.getString("hashtag"), curValue);
        }
        Set keys = check.keySet();
        for (String key : keys) {
            toReturn.add(new Hashtag(key, ((Integer)check.get(key)).intValue()));
        }
        return toReturn;
    }

    private List<Post> getRecentPostsByVRE(String vreid, int quantity) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, PostIDNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        ArrayList<String> postIDs = this.getVREPostIds(vreid);
        quantity = quantity > postIDs.size() ? postIDs.size() : quantity;
        for (int i = postIDs.size() - 1; i >= postIDs.size() - quantity; --i) {
            Post toAdd = this.readPost(postIDs.get(i));
            if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent Post: " + postIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped Post: " + postIDs.get(i) + " (Removed Post) .");
            quantity = ++quantity > postIDs.size() ? postIDs.size() : quantity;
        }
        return toReturn;
    }

    private List<Post> getVREPostsByHashtag(String vreid, String hashtag) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, PostIDNotFoundException, ColumnNameNotFoundException {
        ArrayList<Post> toReturn = new ArrayList();
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet resultPost = null;
        PreparedStatement stmtFind1 = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtaggedPosts").all().whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            resultPost = session.execute((Statement)stmtFind1.bind(new Object[]{hashtag}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PreparedStatement stmtFind2 = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtaggedComments").all().whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet resultComment = null;
        try {
            resultComment = session.execute((Statement)stmtFind2.bind(new Object[]{hashtag}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashSet<String> postIds = new HashSet<String>();
        List rowsPost = resultPost.all();
        for (Row row : rowsPost) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            postIds.add(row.getUuid("postid").toString());
        }
        List rowsComment = resultComment.all();
        for (Row row : rowsComment) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            try {
                Comment c = this.readComment(row.getUuid("commentid").toString());
                postIds.add(c.getPostid());
            }
            catch (CommentIDNotFoundException e) {
                _log.warn("Failed to fetch comment with id " + row.getString("commentid"));
            }
        }
        toReturn = this.getPostsByIds(new ArrayList<String>(postIds));
        return toReturn;
    }

    private List<Invite> getInvitedEmailsByVRE(String vreid, List<InviteStatus> status) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"VREInvites").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> invitesIds = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            if (status != null) {
                for (int i = 0; i < status.size(); ++i) {
                    if (row.getString("status").compareTo(status.get(i).toString()) != 0) continue;
                    invitesIds.add(row.getUuid("inviteid").toString());
                }
                continue;
            }
            invitesIds.add(row.getUuid("inviteid").toString());
        }
        return this.getInvitesById(invitesIds);
    }

    private Invite isExistingInvite(String vreid, String email) {
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind1 = session.prepare(((Select)QueryBuilder.selectFrom((String)"EmailInvites").all().whereColumn("email").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind1.bind(new Object[]{email}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            Invite invite = new Invite();
            invite.setVreid(vreid);
            invite.setInvitedEmail(email);
            invite.setKey(row.getUuid("inviteid").toString());
            return invite;
        }
        return null;
    }

    private boolean setInviteStatus(String vreid, String email, InviteStatus status) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        String inviteid = this.isExistingInvite(vreid, email).getId();
        Invite toSet = this.readInvite(inviteid);
        if (toSet == null) {
            throw new InviteIDNotFoundException("The specified invite to set with id: " + inviteid + " does not exist");
        }
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.updateInviteEntry(session, "status").bind(new Object[]{status.toString(), UUID.fromString(inviteid)})).add((BatchableStatement)SocialDBDatastaxDriver.updateVreInviteEntry(session, "status").bind(new Object[]{status.toString(), vreid, UUID.fromString(inviteid)}));
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            _log.error("ERROR while setting Invite " + inviteid + " to " + status.toString());
            return false;
        }
        _log.trace("Invite Status Set to " + status.toString() + " OK");
        return true;
    }

    private boolean saveHashTags(String postId, String vreid, List<String> hashtags) throws PostIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstInsert = session.execute((Statement)SocialDBDatastaxDriver.createNewHashtagTimelineEntry(session).bind(new Object[]{lowerCaseHashtag, UUID.fromString(postId), vreid})).wasApplied();
            boolean secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, true);
            if (firstInsert && secondInsert) continue;
            _log.error("saveHashTags: Could not save the hashtag(s)");
            return false;
        }
        return true;
    }

    private boolean deleteHashTags(String postId, String vreid, List<String> hashtags) throws PostIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstDelete = session.execute((Statement)SocialDBDatastaxDriver.deleteHashtagEntry(session).bind(new Object[]{lowerCaseHashtag, UUID.fromString(postId)})).wasApplied();
            boolean secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, false);
            if (firstDelete && secondInsert) continue;
            _log.error("deleteHashTags: Could not delete the hashtag(s)");
            return false;
        }
        return true;
    }

    private boolean saveHashTagsComment(String commentId, String vreid, List<String> hashtags) throws CommentIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstInsert = session.execute((Statement)SocialDBDatastaxDriver.createNewHashtagCommentEntry(session).bind(new Object[]{hashtag, UUID.fromString(commentId), vreid})).wasApplied();
            boolean secondInsert = false;
            if (firstInsert) {
                secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, true);
            }
            if (firstInsert && secondInsert) continue;
            _log.error("saveHashTags: Could not save the hashtag(s)");
            return false;
        }
        return true;
    }

    private boolean deleteHashTagsComment(String commentId, String vreid, List<String> hashtags) throws CommentIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstDelete = session.execute((Statement)SocialDBDatastaxDriver.deleteHashtagCommentEntry(session).bind(new Object[]{lowerCaseHashtag, UUID.fromString(commentId)})).wasApplied();
            if (firstDelete) {
                boolean secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, false);
                if (firstDelete && secondInsert) continue;
                _log.error("deleteHashTags: Could not delete the hashtag(s)");
                return false;
            }
            _log.error("deleteHashTags: Could not delete the hashtag(s)");
            return false;
        }
        return true;
    }

    private List<Post> getAllPostsByUser(String userid) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, PostIDNotFoundException {
        return this.getPostsByIds(this.getUserPostIds(userid));
    }

    private List<Post> getRecentPostsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        ResultSet result = null;
        try {
            CqlSession session = this.conn.getKeyspaceSession();
            PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserTimeline").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<Post> toReturn = new ArrayList<Post>();
        for (Row row : rows) {
            Instant postTime = row.getInstant("timestamp");
            if (Date.from(postTime).getTime() <= timeInMillis) continue;
            try {
                Post toCheck = this.readPost(row.getUuid("postid").toString());
                if (toCheck.getType() == PostType.DISABLED) continue;
                toReturn.add(toCheck);
            }
            catch (ColumnNameNotFoundException | PostIDNotFoundException | PostTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private List<Post> getRecentPostsByUser(String userid, int quantity) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, PostIDNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        ArrayList<String> postIDs = this.getUserPostIds(userid);
        quantity = quantity > postIDs.size() ? postIDs.size() : quantity;
        for (int i = postIDs.size() - 1; i >= postIDs.size() - quantity; --i) {
            Post toAdd = this.readPost(postIDs.get(i));
            if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent post: " + postIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped post: " + postIDs.get(i) + " (Removed Post)");
            quantity = ++quantity > postIDs.size() ? postIDs.size() : quantity;
        }
        return toReturn;
    }

    private List<Post> getRecentCommentedPostsByUserAndDate(String userid, long timeInMillis) throws Exception {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<Comment> lastComments = this.getRecentCommentsByUserAndDateBody(userid, timeInMillis, false);
        HashSet<String> postIds = new HashSet<String>();
        for (Comment comment : lastComments) {
            String postId = comment.getPostid();
            try {
                if (postIds.contains(postId)) continue;
                postIds.add(postId);
                toReturn.add(this.readPost(postId));
            }
            catch (Exception e) {
                _log.error("Unable to retrieve post with id " + postId, (Throwable)e);
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    private List<Notification> getUnreadNotificationsByUser(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException {
        ArrayList<Notification> toReturn = new ArrayList<Notification>();
        ArrayList<String> notificationsIDs = this.getUnreadUserNotificationsIds(userid);
        for (int i = notificationsIDs.size() - 1; i >= 0; --i) {
            try {
                toReturn.add(this.readNotification(notificationsIDs.get(i)));
                continue;
            }
            catch (Exception e) {
                _log.error("Unable to read notification with key " + notificationsIDs.get(i));
            }
        }
        return toReturn;
    }

    private boolean setAllNotificationReadByUser(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<String> notificationsIDs = this.getUnreadUserNotificationsIds(userid);
        for (int i = notificationsIDs.size() - 1; i >= 0; --i) {
            try {
                this.setNotificationRead(notificationsIDs.get(i));
                continue;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Could not set read notification with id =" + notificationsIDs.get(i));
            }
        }
        return true;
    }

    private List<Notification> getAllNotificationByUser(String userid, int limit) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<Notification> toReturn = new ArrayList<Notification>();
        ArrayList<String> notificationsIDs = this.getUserNotificationsIds(userid);
        limit = limit > notificationsIDs.size() ? notificationsIDs.size() : limit;
        for (int i = notificationsIDs.size() - 1; i >= notificationsIDs.size() - limit; --i) {
            Notification toAdd = null;
            try {
                toAdd = this.readNotification(notificationsIDs.get(i));
                toReturn.add(toAdd);
                continue;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Notification not found id=" + notificationsIDs.get(i));
            }
        }
        return toReturn;
    }

    private List<Post> getRecentLikedPostsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<String> likedPostsIdsByUser = this.getAllLikedPostIdsByUser(userid);
        if (likedPostsIdsByUser != null && !likedPostsIdsByUser.isEmpty()) {
            for (int i = likedPostsIdsByUser.size() - 1; i >= 0; --i) {
                String postid = likedPostsIdsByUser.get(i);
                try {
                    boolean isPostOk;
                    Post toCheck = this.readPost(postid);
                    boolean bl = isPostOk = toCheck.getType() == PostType.TWEET || toCheck.getType() == PostType.SHARE || toCheck.getType() == PostType.PUBLISH;
                    if (!isPostOk) continue;
                    List<IdResource> likes = this.getAllChildrenByPost(postid, "Likes");
                    for (IdResource x : likes) {
                        Like like = (Like)x;
                        if (like.getTime().getTime() < timeInMillis || !like.getUserid().equals(userid)) continue;
                        toReturn.add(toCheck);
                    }
                    continue;
                }
                catch (Exception e) {
                    _log.error("Skipped post with id " + postid, (Throwable)e);
                }
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    private boolean checkUnreadNotifications(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<String> unreadNotifications = this.getUnreadUserNotificationsIds(userid);
        for (int i = unreadNotifications.size() - 1; i >= 0; --i) {
            try {
                Notification toAdd = this.readNotification(unreadNotifications.get(i));
                if (toAdd.getType() == NotificationType.MESSAGE) continue;
                return true;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Notification not found with id = " + unreadNotifications.get(i));
            }
        }
        return false;
    }

    private boolean checkUnreadMessagesNotifications(String userid) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<String> unreadNotifications = this.getUnreadUserNotificationsIds(userid);
        for (int i = unreadNotifications.size() - 1; i >= 0; --i) {
            try {
                Notification toAdd = this.readNotification(unreadNotifications.get(i));
                if (toAdd.getType() != NotificationType.MESSAGE) continue;
                return true;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Notification not found with id = " + unreadNotifications.get(i));
            }
        }
        return false;
    }

    private List<String> getAllLikedPostIdsByUser(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserLikes").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : result) {
            toReturn.add(row.getUuid("postid").toString());
        }
        return toReturn;
    }

    private List<Post> getAllLikedPostsByUser(String userid, int limit) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, PostIDNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        List<String> likedPostIDs = this.getAllLikedPostIdsByUser(userid);
        limit = limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
        for (int i = likedPostIDs.size() - 1; i >= likedPostIDs.size() - limit; --i) {
            Post toAdd = this.readPost(likedPostIDs.get(i));
            if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent post: " + likedPostIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped post: " + likedPostIDs.get(i) + " (Removed post)");
            limit = ++limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
        }
        return toReturn;
    }

    private List<Comment> getRecentCommentsByUserAndDate(String userid, long timeInMillis) throws Exception {
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<Comment> commentsByUser = this.getRecentCommentsByUserAndDateBody(userid, timeInMillis, true);
        return commentsByUser;
    }

    private List<NotificationChannelType> getUserNotificationChannels(String userid, NotificationType notificationType) throws NotificationChannelTypeNotFoundException, NotificationTypeNotFoundException {
        _log.info("Asking for Single Notification preference of  " + userid + " Type: " + notificationType);
        ArrayList<NotificationChannelType> toReturn = new ArrayList<NotificationChannelType>();
        List<NotificationPreference> notificationPreferences = this.getUserNotificationPreferences(userid);
        NotificationPreference notificationPreference = new NotificationPreference();
        for (NotificationPreference notPref : notificationPreferences) {
            if (!notPref.getNotificationType().equals(notificationType.toString())) continue;
            notificationPreference = notPref;
            break;
        }
        String[] toProcess = notificationPreference.getNotificationChannelType();
        _log.info("size of user notification preferences" + toProcess.length);
        if (toProcess == null) {
            _log.info("Single Notification preference of  " + userid + " Type: " + notificationType + " not existing ... creating default");
            return this.createNewNotificationType(userid, notificationType);
        }
        if (toProcess.length == 0) {
            return toReturn;
        }
        for (int i = 0; i < toProcess.length; ++i) {
            toReturn.add(NotificationChannelType.valueOf((String)toProcess[i]));
        }
        return toReturn;
    }

    private List<NotificationPreference> getUserNotificationPreferences(String userid) throws NotificationTypeNotFoundException, NotificationChannelTypeNotFoundException {
        _log.trace("Asking for Notification preferences of  " + userid);
        ArrayList<NotificationPreference> notificationPreferences = new ArrayList<NotificationPreference>();
        HashMap<NotificationType, NotificationChannelType[]> toReturn = new HashMap<NotificationType, NotificationChannelType[]>();
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserNotificationsPreferences").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List results = result.all();
        if (results.isEmpty()) {
            _log.info("Userid " + userid + " settings not found, initiating its preferences...");
            HashMap<NotificationType, NotificationChannelType[]> toCreate = new HashMap<NotificationType, NotificationChannelType[]>();
            for (int i = 0; i < NotificationType.values().length; ++i) {
                if (NotificationType.values()[i].toString().startsWith("WP_")) {
                    NotificationChannelType[] wpTypes = new NotificationChannelType[]{NotificationChannelType.PORTAL};
                    toCreate.put(NotificationType.values()[i], wpTypes);
                    continue;
                }
                toCreate.put(NotificationType.values()[i], NotificationChannelType.values());
            }
            Set keys = toCreate.keySet();
            for (NotificationType k : keys) {
                NotificationChannelType[] notChannels = (NotificationChannelType[])toCreate.get(k);
                String[] notChannelsString = new String[notChannels.length];
                for (int i = 0; i < notChannels.length; ++i) {
                    notChannelsString[i] = notChannels[i].toString();
                }
                NotificationPreference notPreference = new NotificationPreference(k.toString(), notChannelsString);
                notificationPreferences.add(notPreference);
            }
            this.setUserNotificationPreferences(userid, notificationPreferences);
            return notificationPreferences;
        }
        _log.trace("Notification preferences Found for  " + userid);
        for (Row row : results) {
            String[] channels = row.getString("preference").split(",");
            if (channels != null && channels.length == 1 && channels[0].toString().equals("")) {
                toReturn.put(SocialDBDatastaxDriver.getNotificationType(row.getString("type")), new NotificationChannelType[0]);
                continue;
            }
            NotificationChannelType[] toAdd = new NotificationChannelType[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                if (channels[i].compareTo("") == 0) continue;
                toAdd[i] = this.getChannelType(channels[i]);
            }
            toReturn.put(SocialDBDatastaxDriver.getNotificationType(row.getString("type")), toAdd);
        }
        Set keys = toReturn.keySet();
        for (NotificationType k : keys) {
            NotificationChannelType[] notChannels = (NotificationChannelType[])toReturn.get(k);
            String[] notChannelsString = new String[notChannels.length];
            for (int i = 0; i < notChannels.length; ++i) {
                notChannelsString[i] = notChannels[i].toString();
            }
            NotificationPreference notPreference = new NotificationPreference(k.toString(), notChannelsString);
            notificationPreferences.add(notPreference);
        }
        return notificationPreferences;
    }

    private boolean setUserNotificationPreferences(String userid, List<NotificationPreference> notificationPreferences) {
        CqlSession session = this.conn.getKeyspaceSession();
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        HashMap<NotificationType, NotificationChannelType[]> enabledChannels = new HashMap<NotificationType, NotificationChannelType[]>();
        for (NotificationPreference notPref : notificationPreferences) {
            NotificationChannelType[] notChannels = new NotificationChannelType[notPref.getNotificationChannelType().length];
            for (int i = 0; i < notPref.getNotificationChannelType().length; ++i) {
                notChannels[i] = NotificationChannelType.valueOf((String)notPref.getNotificationChannelType()[i]);
            }
            enabledChannels.put(NotificationType.valueOf((String)notPref.getNotificationType()), notChannels);
        }
        for (NotificationType nType : enabledChannels.keySet()) {
            Object valueToInsert = "";
            _log.info("Type: " + nType.toString());
            int channelsNo = enabledChannels.get(nType) != null ? ((NotificationChannelType[])enabledChannels.get(nType)).length : 0;
            for (int i = 0; i < channelsNo; ++i) {
                _log.info(((NotificationChannelType[])enabledChannels.get(nType))[i].toString());
                valueToInsert = (String)valueToInsert + NotificationChannelType.valueOf((String)((NotificationChannelType[])enabledChannels.get(nType))[i].toString());
                if (i >= channelsNo - 1) continue;
                valueToInsert = (String)valueToInsert + ",";
            }
            if (channelsNo == 0) {
                valueToInsert = "";
                _log.trace("No Channels selected for " + nType + " by " + userid);
            }
            boundStatements.add(SocialDBDatastaxDriver.createNotificationPreferenceEntry(session).bind(new Object[]{userid, nType.toString(), valueToInsert}));
        }
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().addAll(boundStatements);
        boolean overAllresult = session.execute((Statement)writeBatch).wasApplied();
        if (overAllresult) {
            _log.info("Set Notification Map for " + userid + " OK");
        } else {
            _log.info("Set Notification Map for " + userid + " FAILED");
        }
        return overAllresult;
    }

    private List<Post> getAllPostsByApp(String appid) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, ColumnNameNotFoundException, PostIDNotFoundException {
        return this.getPostsByIds(this.getAppPostIds(appid));
    }

    private Invite readInvite(String inviteid) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        Invite toReturn = null;
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Invites").all().whereColumn("inviteid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(inviteid)}));
            toReturn = SocialDBDatastaxDriver.readAInviteFromRow((Row)result.one());
            if (toReturn == null) {
                throw new InviteStatusNotFoundException("The requested inviteid: " + inviteid + " is not existing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public InviteOperationResult saveInvite(Invite invite) throws ServerException {
        if (invite == null) {
            throw new NullArgumentException("Invite instance is null");
        }
        String email = invite.getInvitedEmail();
        if (!this.verifyEmail(email)) {
            throw new ServerException("Email is not valid ->" + email);
        }
        if (invite.getVreid() == null || invite.getVreid().equals("")) {
            throw new NullArgumentException("VREId is null or empty");
        }
        _log.debug("isExistingInvite? " + invite.getInvitedEmail() + " in " + invite.getVreid());
        if (this.isExistingInvite(invite.getVreid(), invite.getInvitedEmail()) != null) {
            return InviteOperationResult.ALREADY_INVITED;
        }
        _log.debug("Invite not found, proceed to save it ...");
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.initSaveInvite(invite, session);
        boundStatements.add(SocialDBDatastaxDriver.createNewVreInviteEntry(session).bind(new Object[]{invite.getVreid(), UUID.fromString(invite.getKey()), InviteStatus.PENDING.toString()}));
        boundStatements.add(SocialDBDatastaxDriver.createNewEmailInviteEntry(session).bind(new Object[]{email, invite.getVreid(), UUID.fromString(invite.getKey())}));
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().addAll(boundStatements);
        boolean result = session.execute((Statement)writeBatch).wasApplied();
        return result ? InviteOperationResult.SUCCESS : InviteOperationResult.FAILED;
    }

    @Override
    public void closeConnection() {
        this.conn.closeConnection();
    }

    private List<Post> getPostsByIds(List<String> postIds) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException, PostIDNotFoundException, ColumnNameNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        for (String postid : postIds) {
            Post toAdd = this.readPost(postid);
            if (toAdd.getType() != PostType.TWEET && toAdd.getType() != PostType.SHARE && toAdd.getType() != PostType.PUBLISH) continue;
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    private ArrayList<String> getUserPostIds(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserTimeline").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private boolean isPostLiked(String userid, String postid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserLikes").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            if (!row.getUuid("postid").toString().equals(postid)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String> getAppPostIds(String appid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"AppTimeline").all().whereColumn("appid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{appid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private List<Comment> getRecentCommentsByUserAndDateBody(String userid, long timeInMillis, boolean sort) {
        ArrayList<Comment> commentsByUser = new ArrayList<Comment>();
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(QueryBuilder.selectFrom((String)"Comments").all().build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[0]));
            List results = result.all();
            if (!results.isEmpty()) {
                results.parallelStream().forEach(row -> {
                    if (row.getString("userid").equals(userid)) {
                        try {
                            Comment c = this.readComment(row.getUuid("commentid").toString());
                            Post p = this.readPost(c.getPostid());
                            if (c.getTime().getTime() >= timeInMillis && (p.getType() == PostType.TWEET || p.getType() == PostType.SHARE || p.getType() == PostType.PUBLISH)) {
                                commentsByUser.add(c);
                            }
                        }
                        catch (Exception e) {
                            _log.error("Unable to read comment with id" + row.getString("commentid"), (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sort) {
            Collections.sort(commentsByUser, Collections.reverseOrder());
        }
        return commentsByUser;
    }

    private ArrayList<String> getVREPostIds(String vreid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"VRETimeline").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private ArrayList<String> getUserNotificationsIds(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserNotifications").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            toReturn.add(row.getUuid("notid").toString());
        }
        return toReturn;
    }

    private ArrayList<String> getUnreadUserNotificationsIds(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserUnreadNotifications").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            toReturn.add(row.getUuid("notid").toString());
        }
        return toReturn;
    }

    private List<NotificationChannelType> createNewNotificationType(String userid, NotificationType notificationType) {
        ArrayList<NotificationChannelType> toReturn = new ArrayList<NotificationChannelType>();
        _log.info("Create new notification type");
        CqlSession session = this.conn.getKeyspaceSession();
        Object valueToInsert = "";
        NotificationChannelType[] wpTypes = NotificationChannelType.values();
        for (int i = 0; i < wpTypes.length; ++i) {
            valueToInsert = (String)valueToInsert + wpTypes[i];
            if (i < wpTypes.length - 1) {
                valueToInsert = (String)valueToInsert + ",";
            }
            toReturn.add(wpTypes[i]);
        }
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)SocialDBDatastaxDriver.createNotificationPreferenceEntry(session).bind(new Object[]{userid, notificationType.toString(), valueToInsert}));
        boolean res = false;
        try {
            res = session.execute((Statement)writeBatch).wasApplied();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res) {
            _log.info("Set New Notification Setting for " + userid + " OK");
            _log.info("toreturn:" + ((Object)toReturn).toString());
            return toReturn;
        }
        _log.info("empty list");
        return new ArrayList<NotificationChannelType>();
    }

    private List<Invite> getInvitesById(List<String> inviteIds) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        ArrayList<Invite> toReturn = new ArrayList<Invite>();
        for (String inviteid : inviteIds) {
            toReturn.add(this.readInvite(inviteid));
        }
        return toReturn;
    }

    private List<BoundStatement> initSaveInvite(Invite invite, CqlSession session) {
        List<BoundStatement> boundStatements = this.insertIntoInvites(session, invite);
        if (invite == null) {
            throw new NullArgumentException("Invite instance is null");
        }
        return boundStatements;
    }

    private NotificationChannelType getChannelType(String channelName) throws NotificationChannelTypeNotFoundException {
        if (channelName.compareTo("PORTAL") == 0) {
            return NotificationChannelType.PORTAL;
        }
        if (channelName.compareTo("EMAIL") == 0) {
            return NotificationChannelType.EMAIL;
        }
        if (channelName.compareTo("TWITTER") == 0) {
            return NotificationChannelType.TWITTER;
        }
        throw new NotificationChannelTypeNotFoundException("The Notification Channel Type was not recognized should be one of " + NotificationChannelType.values() + " asked for: " + channelName);
    }

    private static PrivacyLevel getPrivacyLevel(String privacyLevel) throws PrivacyLevelTypeNotFoundException {
        if (privacyLevel.compareTo("CONNECTION") == 0) {
            return PrivacyLevel.CONNECTION;
        }
        if (privacyLevel.compareTo("PRIVATE") == 0) {
            return PrivacyLevel.PRIVATE;
        }
        if (privacyLevel.compareTo("PUBLIC") == 0) {
            return PrivacyLevel.PUBLIC;
        }
        if (privacyLevel.compareTo("VRES") == 0) {
            return PrivacyLevel.VRES;
        }
        if (privacyLevel.compareTo("SINGLE_VRE") == 0) {
            return PrivacyLevel.SINGLE_VRE;
        }
        if (privacyLevel.compareTo("PORTAL") == 0) {
            return PrivacyLevel.PORTAL;
        }
        throw new PrivacyLevelTypeNotFoundException("The Privacy Level was not recognized should be one of " + PrivacyLevel.values() + " asked for: " + privacyLevel);
    }

    private static PostType getPostType(String type) throws PostTypeNotFoundException {
        if (type.compareTo("TWEET") == 0) {
            return PostType.TWEET;
        }
        if (type.compareTo("JOIN") == 0) {
            return PostType.JOIN;
        }
        if (type.compareTo("PUBLISH") == 0) {
            return PostType.PUBLISH;
        }
        if (type.compareTo("SHARE") == 0) {
            return PostType.SHARE;
        }
        if (type.compareTo("ACCOUNTING") == 0) {
            return PostType.ACCOUNTING;
        }
        if (type.compareTo("DISABLED") == 0) {
            return PostType.DISABLED;
        }
        throw new PostTypeNotFoundException("The post Type was not recognized should be one of " + PostType.values() + " asked for: " + type);
    }

    private static InviteStatus getInviteStatusType(String type) throws InviteStatusNotFoundException {
        switch (type) {
            case "PENDING": {
                return InviteStatus.PENDING;
            }
            case "ACCEPTED": {
                return InviteStatus.ACCEPTED;
            }
            case "REJECTED": {
                return InviteStatus.REJECTED;
            }
            case "RETRACTED": {
                return InviteStatus.RETRACTED;
            }
        }
        throw new InviteStatusNotFoundException("The Invite Status was not recognized should be one of " + InviteStatus.values() + " asked for: " + type);
    }

    private static NotificationType getNotificationType(String type) throws NotificationTypeNotFoundException {
        if (type.compareTo("WP_FOLDER_SHARE") == 0) {
            return NotificationType.WP_FOLDER_SHARE;
        }
        if (type.compareTo("WP_FOLDER_UNSHARE") == 0) {
            return NotificationType.WP_FOLDER_UNSHARE;
        }
        if (type.compareTo("WP_ADMIN_UPGRADE") == 0) {
            return NotificationType.WP_ADMIN_UPGRADE;
        }
        if (type.compareTo("WP_ADMIN_DOWNGRADE") == 0) {
            return NotificationType.WP_ADMIN_DOWNGRADE;
        }
        if (type.compareTo("WP_FOLDER_RENAMED") == 0) {
            return NotificationType.WP_FOLDER_RENAMED;
        }
        if (type.compareTo("WP_FOLDER_ADDEDUSER") == 0) {
            return NotificationType.WP_FOLDER_ADDEDUSER;
        }
        if (type.compareTo("WP_FOLDER_REMOVEDUSER") == 0) {
            return NotificationType.WP_FOLDER_REMOVEDUSER;
        }
        if (type.compareTo("WP_ITEM_DELETE") == 0) {
            return NotificationType.WP_ITEM_DELETE;
        }
        if (type.compareTo("WP_ITEM_UPDATED") == 0) {
            return NotificationType.WP_ITEM_UPDATED;
        }
        if (type.compareTo("WP_ITEM_NEW") == 0) {
            return NotificationType.WP_ITEM_NEW;
        }
        if (type.compareTo("WP_ITEM_RENAMED") == 0) {
            return NotificationType.WP_ITEM_RENAMED;
        }
        if (type.compareTo("OWN_COMMENT") == 0) {
            return NotificationType.OWN_COMMENT;
        }
        if (type.compareTo("COMMENT") == 0) {
            return NotificationType.COMMENT;
        }
        if (type.compareTo("MENTION") == 0) {
            return NotificationType.MENTION;
        }
        if (type.compareTo("LIKE") == 0) {
            return NotificationType.LIKE;
        }
        if (type.compareTo("CALENDAR_ADDED_EVENT") == 0) {
            return NotificationType.CALENDAR_ADDED_EVENT;
        }
        if (type.compareTo("CALENDAR_UPDATED_EVENT") == 0) {
            return NotificationType.CALENDAR_UPDATED_EVENT;
        }
        if (type.compareTo("CALENDAR_DELETED_EVENT") == 0) {
            return NotificationType.CALENDAR_DELETED_EVENT;
        }
        if (type.compareTo("CALENDAR_ADDED_EVENT") == 0) {
            return NotificationType.CALENDAR_ADDED_EVENT;
        }
        if (type.compareTo("CALENDAR_UPDATED_EVENT") == 0) {
            return NotificationType.CALENDAR_UPDATED_EVENT;
        }
        if (type.compareTo("CALENDAR_DELETED_EVENT") == 0) {
            return NotificationType.CALENDAR_DELETED_EVENT;
        }
        if (type.compareTo("MESSAGE") == 0) {
            return NotificationType.MESSAGE;
        }
        if (type.compareTo("POST_ALERT") == 0) {
            return NotificationType.POST_ALERT;
        }
        if (type.compareTo("REQUEST_CONNECTION") == 0) {
            return NotificationType.REQUEST_CONNECTION;
        }
        if (type.compareTo("JOB_COMPLETED_NOK") == 0) {
            return NotificationType.JOB_COMPLETED_NOK;
        }
        if (type.compareTo("JOB_COMPLETED_OK") == 0) {
            return NotificationType.JOB_COMPLETED_OK;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_EDIT") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_EDIT;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_VIEW") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_VIEW;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_FORWARD_STEP_COMPLETED_OWNER") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_FORWARD_STEP_COMPLETED_OWNER;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_STEP_FORWARD_PEER") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_STEP_FORWARD_PEER;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_STEP_REQUEST_TASK") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_STEP_REQUEST_TASK;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_USER_FORWARD_TO_OWNER") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_USER_FORWARD_TO_OWNER;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_FIRST_STEP_REQUEST_INVOLVMENT") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_FIRST_STEP_REQUEST_INVOLVMENT;
        }
        if (type.compareTo("TDM_TAB_RESOURCE_SHARE") == 0) {
            return NotificationType.TDM_TAB_RESOURCE_SHARE;
        }
        if (type.compareTo("TDM_RULE_SHARE") == 0) {
            return NotificationType.TDM_RULE_SHARE;
        }
        if (type.compareTo("TDM_TEMPLATE_SHARE") == 0) {
            return NotificationType.TDM_TEMPLATE_SHARE;
        }
        if (type.compareTo("CAT_ITEM_SUBMITTED") == 0) {
            return NotificationType.CAT_ITEM_SUBMITTED;
        }
        if (type.compareTo("CAT_ITEM_REJECTED") == 0) {
            return NotificationType.CAT_ITEM_REJECTED;
        }
        if (type.compareTo("CAT_ITEM_PUBLISHED") == 0) {
            return NotificationType.CAT_ITEM_PUBLISHED;
        }
        if (type.compareTo("CAT_ITEM_UPDATED") == 0) {
            return NotificationType.CAT_ITEM_UPDATED;
        }
        if (type.compareTo("CAT_ITEM_DELETE") == 0) {
            return NotificationType.CAT_ITEM_DELETE;
        }
        if (type.compareTo("GENERIC") == 0) {
            return NotificationType.GENERIC;
        }
        throw new NotificationTypeNotFoundException("The Notification Type was not recognized should be one of " + NotificationType.values() + " asked for: " + type);
    }

    private Date getDateFromTimeInMillis(String time) {
        Long timeInMillis = Long.parseLong(time);
        Calendar toSet = Calendar.getInstance();
        toSet.setTimeInMillis(timeInMillis);
        return toSet.getTime();
    }

    private boolean updatePostCommentsCount(Post toUpdate, boolean increment) {
        int newCount = 0;
        try {
            int current = Integer.parseInt(toUpdate.getCommentsNo());
            newCount = increment ? current + 1 : current - 1;
        }
        catch (NumberFormatException e) {
            _log.error("Comments Number found is not a number: " + toUpdate.getCommentsNo());
        }
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            session.execute((Statement)SocialDBDatastaxDriver.updatePostEntry(session, "commentsno").bind(new Object[]{(long)newCount, UUID.fromString(toUpdate.getKey())}));
        }
        catch (Exception e) {
            _log.error("CommentsNo update NOT OK ");
            return false;
        }
        _log.info("CommentsNo update OK to: " + newCount);
        return true;
    }

    private boolean updatePostLikesCount(Post toUpdate, boolean increment) {
        int newCount = 0;
        try {
            int current = Integer.parseInt(toUpdate.getLikesNo());
            newCount = increment ? current + 1 : current - 1;
        }
        catch (NumberFormatException e) {
            _log.error("Likes Number found is not a number: " + toUpdate.getLikesNo());
        }
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            session.execute((Statement)SocialDBDatastaxDriver.updatePostEntry(session, "likesno").bind(new Object[]{(long)newCount, UUID.fromString(toUpdate.getKey())}));
        }
        catch (Exception e) {
            _log.error("LikesNo update NOT OK ");
            return false;
        }
        _log.info("LikesNo update OK to: " + newCount);
        return true;
    }

    private boolean updateVREHashtagCount(String vreid, String hashtag, boolean increment) {
        List<Hashtag> vreHashtagsList = this.getVREHashtagsWithOccurrence(vreid);
        HashMap vreHashtags = new HashMap();
        vreHashtagsList.forEach(x -> vreHashtags.put(x.getId(), x.getOccurrence()));
        int newCount = 0;
        if (!vreHashtags.containsKey(hashtag)) {
            newCount = 1;
        } else {
            try {
                int current = (Integer)vreHashtags.get(hashtag);
                newCount = increment ? current + 1 : current - 1;
            }
            catch (NumberFormatException e) {
                _log.error("Hashtag Number found is not a number: " + newCount);
            }
        }
        _log.debug("Updating counter for " + hashtag + " to " + newCount);
        CqlSession session = this.conn.getKeyspaceSession();
        BoundStatement stmt = SocialDBDatastaxDriver.existRecordbyCompId(session, "hashtag", "vreid", hashtag, vreid, "HashtagsCounter") ? session.prepare(((Update)((Update)QueryBuilder.update((String)"HashtagsCounter").setColumn("count", (Term)QueryBuilder.bindMarker()).whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build()).bind(new Object[]{(long)newCount, hashtag, vreid}) : SocialDBDatastaxDriver.createNewUHashtagCounterEntry(session).bind(new Object[]{vreid, hashtag, (long)newCount});
        BatchStatement writeBatch = SocialDBDatastaxDriver.getBatch().add((BatchableStatement)stmt);
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            _log.error("Hashtag Count update NOT OK ");
            return false;
        }
        _log.debug("Hashtag Count update OK to: " + newCount);
        return true;
    }

    private boolean verifyEmail(String email) {
        boolean isValid = false;
        return true;
    }

    private static PreparedStatement createPostEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linkhost", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).value("likesno", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).value("linkdescription", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).value("isapplicationpost", (Term)QueryBuilder.bindMarker()).value("entityid", (Term)QueryBuilder.bindMarker()).value("privacy", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).value("multifileupload", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).value("commentsno", (Term)QueryBuilder.bindMarker()).value("linktitle", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createUserTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserTimeline").value("userid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createVreTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"VRETimeline").value("vreid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createAppTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"AppTimeline").value("appid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNotificationEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).value("subjectid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).value("senderid", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).value("senderthumbnailurl", (Term)QueryBuilder.bindMarker()).value("isread", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createUserNotificationsEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserNotifications").value("userid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("notid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createUnreadNotificationEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserUnreadNotifications").value("userid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("notid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNotificationPreferenceEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserNotificationsPreferences").value("userid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).value("preference", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewCommentEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).value("comment", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("isedit", (Term)QueryBuilder.bindMarker()).value("lastedittime", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewLikeEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewUserLikesEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserLikes").value("userid", (Term)QueryBuilder.bindMarker()).value("likeid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewHashtagTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"HashtaggedPosts").value("hashtag", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewHashtagCommentEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"HashtaggedComments").value("hashtag", (Term)QueryBuilder.bindMarker()).value("commentid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewEmailInviteEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"EmailInvites").value("email", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).value("inviteid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewInviteEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("senderuserid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).value("controlcode", (Term)QueryBuilder.bindMarker()).value("status", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewVreInviteEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"VREInvites").value("vreid", (Term)QueryBuilder.bindMarker()).value("inviteid", (Term)QueryBuilder.bindMarker()).value("status", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewaAttachEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).value("name", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).value("mimetype", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewUHashtagCounterEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"HashtagsCounter").value("vreid", (Term)QueryBuilder.bindMarker()).value("hashtag", (Term)QueryBuilder.bindMarker()).value("count", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement updatePostEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Posts").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement updateInviteEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Invites").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("inviteid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement updateVreInviteEntry(CqlSession session, String colName) {
        return session.prepare(((Update)((Update)QueryBuilder.update((String)"VREInvites").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("inviteid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement updateCommentEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Comments").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement updateNotificationEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Notifications").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("notid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteHashtagEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"HashtaggedPosts").whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteHashtagCommentEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"HashtaggedComments").whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteLikeEntry(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"Likes").whereColumn("likeid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteAttachmentEntry(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"Attachments").whereColumn("attachid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deletePostEntry(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"Posts").whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteUserLikeEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"UserLikes").whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("likeid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteCommentEntry(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"Comments").whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteUnreadNotEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"UserUnreadNotifications").whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("timestamp").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private List<BoundStatement> insertIntoNotifications(CqlSession session, Notification notification) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("subjectid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("senderid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt8 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt9 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("senderthumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt10 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("isread", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (notification.getType() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getType().toString()}));
        }
        if (notification.getUserid() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getUserid()}));
        }
        if (notification.getSubjectid() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSubjectid()}));
        }
        if (notification.getTime() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getTime().toInstant()}));
        }
        if (notification.getDescription() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getDescription()}));
        }
        if (notification.getUri() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getUri()}));
        }
        if (notification.getSenderid() != null) {
            boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSenderid()}));
        }
        if (notification.getSenderFullName() != null) {
            boundStatements.add(prepStmt8.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSenderFullName()}));
        }
        if (notification.getSenderThumbnail() != null) {
            boundStatements.add(prepStmt9.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSenderThumbnail()}));
        }
        boundStatements.add(prepStmt10.bind(new Object[]{UUID.fromString(notification.getKey()), notification.isRead()}));
        return boundStatements;
    }

    private List<BoundStatement> insertIntoComments(CqlSession session, Comment comment) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("comment", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("isedit", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt8 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("lastedittime", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (comment.getUserid() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getUserid()}));
        }
        if (comment.getFullName() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getFullName()}));
        }
        if (comment.getThumbnailURL() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getThumbnailURL()}));
        }
        if (comment.getText() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getText()}));
        }
        if (comment.getPostid() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(comment.getKey()), UUID.fromString(comment.getPostid())}));
        }
        if (comment.getTime() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getTime().toInstant()}));
        }
        boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(comment.getKey()), comment.isEdit()}));
        if (comment.getLastEditTime() != null) {
            boundStatements.add(prepStmt8.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getLastEditTime().toInstant()}));
        }
        return boundStatements;
    }

    private List<BoundStatement> insertIntoLikes(CqlSession session, Like like) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (like.getUserid() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(like.getKey()), like.getUserid()}));
        }
        if (like.getFullName() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(like.getKey()), like.getFullName()}));
        }
        if (like.getThumbnailURL() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(like.getKey()), like.getThumbnailURL()}));
        }
        if (like.getPostid() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(like.getKey()), UUID.fromString(like.getPostid())}));
        }
        if (like.getTime() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(like.getKey()), like.getTime().toInstant()}));
        }
        return boundStatements;
    }

    private List<BoundStatement> insertIntoInvites(CqlSession session, Invite invite) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("senderuserid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("controlcode", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("status", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (invite.getSenderUserId() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getSenderUserId()}));
        }
        if (invite.getVreid() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getVreid()}));
        }
        if (invite.getInvitedEmail() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getInvitedEmail()}));
        }
        if (invite.getControlCode() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getControlCode()}));
        }
        if (invite.getStatus() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getStatus().toString()}));
        }
        if (invite.getTime() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getTime().toInstant()}));
        }
        if (invite.getSenderFullName() != null) {
            boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getSenderFullName()}));
        }
        return boundStatements;
    }

    private List<BoundStatement> insertIntoAttachments(CqlSession session, Attachment attachment, String postId) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("name", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("mimetype", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(attachment.getId()), UUID.fromString(postId)}));
        if (attachment.getUri() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getUri()}));
        }
        if (attachment.getName() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getName()}));
        }
        if (attachment.getDescription() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getDescription()}));
        }
        if (attachment.getThumbnailURL() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getThumbnailURL()}));
        }
        if (attachment.getMimeType() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getMimeType()}));
        }
        return boundStatements;
    }

    private List<BoundStatement> insertIntoPosts(CqlSession session, Post post) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linkhost", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("likesno", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linkdescription", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt8 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt9 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("isapplicationpost", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt10 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("entityid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt11 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("privacy", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt12 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt13 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt14 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt15 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("multifileupload", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt16 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt17 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("commentsno", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt18 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linktitle", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (post.getLinkHost() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(post.getKey()), post.getLinkHost()}));
        }
        if (post.getDescription() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(post.getKey()), post.getDescription()}));
        }
        if (post.getEmail() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(post.getKey()), post.getEmail()}));
        }
        if (post.getLikesNo() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(post.getKey()), Long.parseLong(post.getLikesNo())}));
        }
        if (post.getThumbnailURL() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(post.getKey()), post.getThumbnailURL()}));
        }
        if (post.getLinkDescription() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(post.getKey()), post.getLinkDescription()}));
        }
        if (post.getTime() != null) {
            boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(post.getKey()), post.getTime().toInstant()}));
        }
        if (post.getUri() != null) {
            boundStatements.add(prepStmt8.bind(new Object[]{UUID.fromString(post.getKey()), post.getUri()}));
        }
        boundStatements.add(prepStmt9.bind(new Object[]{UUID.fromString(post.getKey()), post.isApplicationPost()}));
        if (post.getEntityId() != null) {
            boundStatements.add(prepStmt10.bind(new Object[]{UUID.fromString(post.getKey()), post.getEntityId()}));
        }
        if (post.getPrivacy() != null) {
            boundStatements.add(prepStmt11.bind(new Object[]{UUID.fromString(post.getKey()), post.getPrivacy().toString()}));
        }
        if (post.getType() != null) {
            boundStatements.add(prepStmt12.bind(new Object[]{UUID.fromString(post.getKey()), post.getType().toString()}));
        }
        if (post.getUriThumbnail() != null) {
            boundStatements.add(prepStmt13.bind(new Object[]{UUID.fromString(post.getKey()), post.getUriThumbnail()}));
        }
        if (post.getVreid() != null) {
            boundStatements.add(prepStmt14.bind(new Object[]{UUID.fromString(post.getKey()), post.getVreid()}));
        }
        boundStatements.add(prepStmt15.bind(new Object[]{UUID.fromString(post.getKey()), post.isMultiFileUpload()}));
        if (post.getFullName() != null) {
            boundStatements.add(prepStmt16.bind(new Object[]{UUID.fromString(post.getKey()), post.getFullName()}));
        }
        if (post.getCommentsNo() != null) {
            boundStatements.add(prepStmt17.bind(new Object[]{UUID.fromString(post.getKey()), Long.parseLong(post.getCommentsNo())}));
        }
        if (post.getLinkTitle() != null) {
            boundStatements.add(prepStmt18.bind(new Object[]{UUID.fromString(post.getKey()), post.getLinkTitle()}));
        }
        return boundStatements;
    }

    private static Optional<Post> findPostById(String postid, CqlSession session) throws PrivacyLevelTypeNotFoundException, PostTypeNotFoundException {
        PreparedStatement stmtFindPost = session.prepare(((Select)QueryBuilder.selectFrom((String)"Posts").all().whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet rs = session.execute((Statement)stmtFindPost.bind(new Object[]{UUID.fromString(postid)}));
        Row record = (Row)rs.one();
        return null != record ? Optional.of(SocialDBDatastaxDriver.readPostFromRow(record)) : Optional.empty();
    }

    private static Optional<Notification> findNotById(String notid, CqlSession session) throws NotificationTypeNotFoundException {
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Notifications").all().whereColumn("notid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet rs = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(notid)}));
        Row record = (Row)rs.one();
        return null != record ? Optional.of(SocialDBDatastaxDriver.readNotificationFromRow(record)) : Optional.empty();
    }

    private static Attachment readAttachmentFromRow(Row record) {
        Attachment a = new Attachment();
        a.setId(Objects.requireNonNull(record.getUuid("attachid")).toString());
        a.setUri(record.getString("uri"));
        a.setName(record.getString("name"));
        a.setDescription(record.getString("description"));
        a.setThumbnailURL(record.getString("urithumbnail"));
        a.setMimeType(record.getString("mimetype"));
        return a;
    }

    private static Notification readNotificationFromRow(Row record) throws NotificationTypeNotFoundException {
        Notification a = new Notification();
        a.setKey(Objects.requireNonNull(record.getUuid("notid")).toString());
        a.setType(SocialDBDatastaxDriver.getNotificationType(Objects.requireNonNull(record.getString("type"))));
        a.setUserid(record.getString("userid"));
        a.setSubjectid(record.getString("subjectid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setUri(record.getString("uri"));
        a.setDescription(record.getString("description"));
        a.setRead(record.getBoolean("isread"));
        a.setSenderid(record.getString("senderid"));
        a.setSenderFullName(record.getString("senderfullname"));
        a.setSenderThumbnail(record.getString("senderthumbnailurl"));
        return a;
    }

    private static Post readPostFromRow(Row record) throws PostTypeNotFoundException, PrivacyLevelTypeNotFoundException {
        Post a = new Post();
        a.setKey(Objects.requireNonNull(record.getUuid("postid")).toString());
        a.setType(SocialDBDatastaxDriver.getPostType(Objects.requireNonNull(record.getString("type"))));
        a.setEntityId(record.getString("entityid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setVreid(record.getString("vreid"));
        a.setUri(record.getString("uri"));
        a.setUriThumbnail(record.getString("urithumbnail"));
        a.setDescription(record.getString("description"));
        a.setPrivacy(SocialDBDatastaxDriver.getPrivacyLevel(Objects.requireNonNull(record.getString("privacy"))));
        a.setFullName(record.getString("fullname"));
        a.setEmail(record.getString("email"));
        a.setThumbnailURL(record.getString("thumbnailurl"));
        a.setCommentsNo(String.valueOf(record.getLong("commentsno")));
        a.setLikesNo(String.valueOf(record.getLong("likesno")));
        a.setLinkDescription(record.getString("linkdescription"));
        a.setLinkTitle(record.getString("linktitle"));
        a.setLinkHost(record.getString("linkhost"));
        a.setApplicationPost(record.getBoolean("isapplicationpost"));
        a.setMultiFileUpload(record.getBoolean("multifileupload"));
        return a;
    }

    private static Like readLikeFromRow(Row record) {
        Like a = new Like();
        a.setKey(Objects.requireNonNull(record.getUuid("likeid")).toString());
        a.setUserid(record.getString("userid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setPostid(Objects.requireNonNull(record.getUuid("postid")).toString());
        a.setFullName(record.getString("fullname"));
        a.setThumbnailURL(record.getString("thumbnailurl"));
        return a;
    }

    private static Comment readCommentFromRow(Row record) {
        Comment a = new Comment();
        a.setKey(Objects.requireNonNull(record.getUuid("commentid")).toString());
        a.setUserid(record.getString("userid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setPostid(Objects.requireNonNull(record.getUuid("postid")).toString());
        a.setFullName(record.getString("fullname"));
        a.setThumbnailURL(record.getString("thumbnailurl"));
        a.setText(record.getString("comment"));
        a.setEdit(!record.isNull("isedit") && record.getBoolean("isedit"));
        a.setLastEditTime(record.isNull("lastedittime") ? null : Date.from(Objects.requireNonNull(record.getInstant("lastedittime"))));
        return a;
    }

    private static Invite readAInviteFromRow(Row record) throws InviteStatusNotFoundException {
        Invite a = new Invite();
        a.setKey(Objects.requireNonNull(record.getUuid("inviteid")).toString());
        a.setSenderUserId(record.getString("senderuserid"));
        a.setVreid(record.getString("vreid"));
        a.setInvitedEmail(record.getString("email"));
        a.setControlCode(record.getString("controlcode"));
        a.setStatus(SocialDBDatastaxDriver.getInviteStatusType(Objects.requireNonNull(record.getString("status"))));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setSenderFullName(record.getString("senderfullname"));
        return a;
    }

    private static boolean existRecordbyId(CqlSession session, String id, String tableName, String colName) {
        PreparedStatement stmt = session.prepare(((Select)QueryBuilder.selectFrom((String)tableName).column(colName).whereColumn(colName).isEqualTo((Term)QueryBuilder.bindMarker())).build());
        return session.execute((Statement)stmt.bind(new Object[]{id})).getAvailableWithoutFetching() > 0;
    }

    private static boolean existRecordbyCompId(CqlSession session, String col1, String col2, String id1, String id2, String tableName) {
        PreparedStatement stmt = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)tableName).all().whereColumn(col1).isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn(col2).isEqualTo((Term)QueryBuilder.bindMarker())).build());
        return session.execute((Statement)stmt.bind(new Object[]{id1, id2})).getAvailableWithoutFetching() > 0;
    }

    private static BatchStatement getBatch() {
        return BatchStatement.builder((BatchType)BatchType.LOGGED).build();
    }
}

