/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.collections;

import jakarta.ws.rs.core.Response;
import java.rmi.ServerException;
import java.util.List;
import org.gcube.social_networking.server.CassandraConnection;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.socialnetworking.model.shared.Invite;
import org.gcube.social_networking.socialnetworking.model.shared.InviteOperationResult;
import org.gcube.social_networking.utils.ResourceNames;
import org.gcube.social_networking.utils.ResponseBean;

public class Collection {
    public Response create(IdResource resource) {
        String resourceName = resource.getClass().getSimpleName();
        if (resourceName.equals(ResourceNames.INVITE)) {
            InviteOperationResult result;
            ResponseBean responseBean = new ResponseBean();
            try {
                result = CassandraConnection.getInstance().getDatabookStore().saveInvite((Invite)resource);
            }
            catch (ServerException e) {
                throw new RuntimeException(e);
            }
            Response.Status status = result == InviteOperationResult.SUCCESS ? Response.Status.CREATED : (result == InviteOperationResult.ALREADY_INVITED ? Response.Status.FOUND : Response.Status.INTERNAL_SERVER_ERROR);
            responseBean.setResult((Object)result);
            responseBean.setMessage((String)(result == InviteOperationResult.SUCCESS ? resourceName + " {" + resource.getId() + "} Created Successfully" : (result == InviteOperationResult.ALREADY_INVITED ? resourceName + " {" + resource.getId() + "} already exists" : "Error")));
            responseBean.setSuccess(result == InviteOperationResult.SUCCESS);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().create(resource);
        Response.Status status = result != false ? Response.Status.CREATED : Response.Status.FOUND;
        responseBean.setResult((Object)result);
        responseBean.setMessage(result != false ? resourceName + " {" + resource.getId() + "} Created Successfully" : resourceName + " {" + resource.getId() + "} already exists");
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response createChildOf(String parentid, IdResource childResource, String parentResourceName) {
        ResponseBean responseBean = new ResponseBean();
        String childResourceName = childResource.getClass().getSimpleName();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().createChildOf(parentid, childResource, parentResourceName);
        Response.Status status = result != false ? Response.Status.CREATED : Response.Status.FOUND;
        responseBean.setResult((Object)result);
        responseBean.setMessage(result != false ? childResourceName + " {" + childResource.getId() + "} Created Successfully for " + parentResourceName + "{" + parentid + "}." : childResourceName + " {" + childResource.getId() + "} already exists");
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response BatchCreateChildOfWithParameter(String parentid, String parameterName, String parameterValue, List<IdResource> childResource, String parentResourceName, String childResourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().BatchCreateChildOfWithParameter(parentid, parameterName, parameterValue, childResource, parentResourceName, childResourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? childResourceName + " created Successfully" : childResourceName + " cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response read(String id, String resourceName) {
        ResponseBean responseBean = new ResponseBean();
        IdResource resource = CassandraConnection.getInstance().getDatabookStore().read(id, resourceName);
        Response.Status status = resource != null ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(resource != null ? resourceName + " {" + id + "} fetched Successfully" : resourceName + " {" + id + "} cannot be found");
        responseBean.setSuccess(resource != null);
        responseBean.setResult((Object)resource);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response check(String id, String parameterName, String parameterValue, String resourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().check(id, parameterName, parameterValue, resourceName);
        Response.Status status = result != null ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != null ? resourceName + " {" + id + "} checked Successfully" : resourceName + " {" + id + "} cannot be found");
        responseBean.setSuccess(result != null);
        responseBean.setResult((Object)result);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response checkChildOf(String parentid, String parameterName, String parameterValue, String parentResourceName, String childResourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().checkChildOf(parentid, parameterName, parameterValue, parentResourceName, childResourceName);
        Response.Status status = result != null ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != null ? childResourceName + " {" + parentid + "} checked Successfully" : childResourceName + " {" + parentid + "} cannot be found");
        responseBean.setSuccess(result != null);
        responseBean.setResult((Object)result);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response readAll(String resourceName) {
        ResponseBean responseBean = new ResponseBean();
        List resources = CassandraConnection.getInstance().getDatabookStore().readAll(resourceName);
        Response.Status status = resources != null ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(resources != null ? resourceName + "s {} fetched Successfully" : resourceName + "s {} cannot be found");
        responseBean.setSuccess(resources != null);
        responseBean.setResult((Object)resources);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response readChildOf(String parentid, String parentResourceName, String childResourceName) {
        ResponseBean responseBean = new ResponseBean();
        List resources = CassandraConnection.getInstance().getDatabookStore().readChildOf(parentid, parentResourceName, childResourceName);
        Response.Status status = resources != null ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(resources != null ? childResourceName + " of " + parentResourceName + " {" + parentid + "} fetched Successfully" : parentResourceName + " {" + parentid + "} cannot be found");
        responseBean.setSuccess(resources != null);
        responseBean.setResult((Object)resources);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response readWithParameter(String parameterName, String parameterValue, String resourceName) {
        ResponseBean responseBean = new ResponseBean();
        List resources = CassandraConnection.getInstance().getDatabookStore().readWithParameter(parameterName, parameterValue, resourceName);
        Response.Status status = resources != null ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(resources != null ? resourceName + "with " + parameterName + "=" + parameterValue + " fetched Successfully" : resourceName + "with " + parameterName + "=" + parameterValue + " cannot be found");
        responseBean.setSuccess(resources != null);
        responseBean.setResult((Object)resources);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response readChildOfWithParameter(String parentid, String parameterName, String parameterValue, String parentResourceName, String childResourceName) {
        ResponseBean responseBean = new ResponseBean();
        List resources = CassandraConnection.getInstance().getDatabookStore().readChildOfWithParameter(parentid, parameterName, parameterValue, parentResourceName, childResourceName);
        Response.Status status = resources != null ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(resources != null ? childResourceName + " of " + parentResourceName + "{" + parentid + "}with " + parameterName + "=" + parameterValue + " fetched Successfully" : childResourceName + " of " + parentResourceName + "{" + parentid + "}with " + parameterName + "=" + parameterValue + " cannot be found");
        responseBean.setSuccess(resources != null);
        responseBean.setResult((Object)resources);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response update(String id, IdResource resource) {
        ResponseBean responseBean = new ResponseBean();
        String resourceName = resource.getClass().getSimpleName();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().update(resource);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? resourceName + " {" + id + "} updated Successfully" : resourceName + " {" + id + "} cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response updateChildOf(String parentid, String childid, IdResource childResource, String parentResourceName) {
        ResponseBean responseBean = new ResponseBean();
        String childResourceName = childResource.getClass().getSimpleName();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().updateChildOf(parentid, childid, childResource, parentResourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? childResourceName + " {" + childid + "} updated Successfully" : childResourceName + " {" + childid + "} cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response BatchUpdateChildOf(String parentid, List<IdResource> childResource, String parentResourceName) {
        ResponseBean responseBean = new ResponseBean();
        String childResourceName = childResource.get(0).getClass().getSimpleName();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().BatchUpdateChildOf(parentid, childResource, parentResourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? childResourceName + " updated Successfully" : childResourceName + " cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response updateWithParameter(String parameterName, String parameterValue, IdResource resource) {
        ResponseBean responseBean = new ResponseBean();
        String resourceName = resource.getClass().getSimpleName();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().updateWithParameter(parameterName, parameterValue, resource);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? resourceName + " with" + parameterName + "=" + parameterValue + " updated Successfully" : resourceName + " with" + parameterName + "=" + parameterValue + " cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response updateChildOfWithParameter(String parentid, String parameterName, String parameterValue, IdResource childResource, String parentResourceName) {
        ResponseBean responseBean = new ResponseBean();
        String childResourceName = childResource.getClass().getSimpleName();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().updateChildOfWithParameter(parentid, parameterName, parameterValue, childResource, parentResourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? childResourceName + " of " + parentResourceName + "{" + parentid + "}with " + parameterName + "=" + parameterValue + " updated Successfully" : childResourceName + " of " + parentResourceName + "{" + parentid + "}with " + parameterName + "=" + parameterValue + " cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response delete(String id, String resourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().delete(id, resourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? resourceName + " {" + id + "} deleted Successfully" : resourceName + " {" + id + "} cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response deleteChildOf(String parentid, String childid, String parentResourceName, String childResourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().deleteChildOf(parentid, childid, childResourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? childResourceName + " {" + childid + "} deleted Successfully for " + parentResourceName + "{" + parentid + "}." : childResourceName + " {" + childid + "} cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response deleteWithParameter(String parameterName, String parameterValue, String resourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().deleteWithParameter(parameterName, parameterValue, resourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? resourceName + " with" + parameterName + "=" + parameterValue + " deleted Successfully" : resourceName + " with" + parameterName + "=" + parameterValue + " cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response deleteChildOfWithParameter(String parentid, String childid, String parameterName, String parameterValue, String parentResourceName, String childResourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().deleteChildOfWithParameter(parentid, childid, parameterName, parameterValue, parentResourceName, childResourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? childResourceName + " of " + parentResourceName + "{" + parentid + "}with " + parameterName + "=" + parameterValue + " deleted Successfully" : childResourceName + " of " + parentResourceName + "{" + parentid + "}with " + parameterName + "=" + parameterValue + " cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    public Response BatchDeleteChildOfWithParameter(String parentid, String parameterName, String parameterValue, List<IdResource> childResource, String parentResourceName, String childResourceName) {
        ResponseBean responseBean = new ResponseBean();
        Boolean result = CassandraConnection.getInstance().getDatabookStore().BatchDeleteChildOfWithParameter(parentid, parameterName, parameterValue, childResource, parentResourceName, childResourceName);
        Response.Status status = result != false ? Response.Status.OK : Response.Status.NOT_FOUND;
        responseBean.setMessage(result != false ? childResourceName + " deleted Successfully" : childResourceName + " cannot be found");
        responseBean.setResult((Object)result);
        responseBean.setSuccess(result.booleanValue());
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

