/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.rest.collections;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceGroup;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.gcube.social_networking.rest.collections.Collection;
import org.gcube.social_networking.socialnetworking.model.shared.IdResource;
import org.gcube.social_networking.socialnetworking.model.shared.Notification;
import org.gcube.social_networking.socialnetworking.model.shared.NotificationPreference;
import org.gcube.social_networking.socialnetworking.model.shared.NotificationType;
import org.gcube.social_networking.utils.ResourceNames;
import org.gcube.social_networking.utils.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="entities")
@ResourceGroup(value="Entities APIs")
@ResourceLabel(value="Entities APIs")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
public class Entities
extends Collection {
    private static final Logger logger = LoggerFactory.getLogger(Entities.class);

    private Response ErrorHandler(Exception e, String entity, String action, String id) {
        ResponseBean responseBean = new ResponseBean();
        logger.info("Unable to " + action + " " + entity + " {}.", (Object)id);
        logger.info(e.getMessage());
        responseBean.setMessage(e.getMessage());
        responseBean.setSuccess(false);
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="users/{id}/allposts")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getAllPostsByUser(@NotNull @PathParam(value="id") String id, @QueryParam(value="liked") boolean liked, @QueryParam(value="limit") int limit) {
        String action = "fetch posts of";
        try {
            if (liked) {
                action = "fetch liked posts of";
                logger.info("Getting all liked posts of user: " + id);
                return super.readChildOfWithParameter(id, "all_like", String.valueOf(limit), "User", ResourceNames.POST);
            }
            logger.info("Getting all posts of user: " + id);
            return super.readChildOf(id, "User", ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", action, id);
        }
    }

    @GET
    @Path(value="apps/{id}/posts")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getAllPostsByApp(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Getting all posts of app: " + id);
            return super.readChildOf(id, "App", ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "app", "fetch posts of", id);
        }
    }

    @GET
    @Path(value="users/{id}/posts/")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getRecentPosts(@NotNull @PathParam(value="id") String id, @NotNull @QueryParam(value="recent_comment") boolean recent_comment, @NotNull @QueryParam(value="recent_like") boolean recent_like, @NotNull @QueryParam(value="recent_limit") boolean recent_limit, @QueryParam(value="time") long time, @QueryParam(value="limit") int limit) {
        String action = "fetch recent posts of";
        try {
            if (recent_comment) {
                action = "fetch recently commented posts of";
                logger.info("Getting recently commented posts of user: " + id);
                return super.readChildOfWithParameter(id, "recent_comment", String.valueOf(time), "User", ResourceNames.POST);
            }
            if (recent_like) {
                action = "fetch recently liked posts of";
                logger.info("Getting recently liked posts of user: " + id);
                return super.readChildOfWithParameter(id, "recent_like", String.valueOf(time), "User", ResourceNames.POST);
            }
            if (recent_limit) {
                action = "fetch n recent posts of";
                logger.info("Getting recent {} posts of user {}", (Object)limit, (Object)id);
                return super.readChildOfWithParameter(id, "recent_limit", String.valueOf(limit), "User", ResourceNames.POST);
            }
            action = "fetch filtered_recent posts of";
            logger.info("Getting recent posts of user {}", (Object)id);
            return super.readChildOfWithParameter(id, "time", String.valueOf(time), "User", ResourceNames.POST);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", action, id);
        }
    }

    @GET
    @Path(value="users/{id}/comments/")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getRecentComments(@NotNull @PathParam(value="id") String id, @QueryParam(value="time") long time) {
        String action = "fetch recent comments of";
        try {
            logger.info("Getting recent comments of user {}", (Object)id);
            return super.readChildOfWithParameter(id, "time", String.valueOf(time), "User", ResourceNames.COMMENT);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", action, id);
        }
    }

    @GET
    @Path(value="users/{id}/notifications")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getAllNotificationByUser(@NotNull @PathParam(value="id") String id, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="unread") boolean unread, @QueryParam(value="check") boolean check, @QueryParam(value="message") boolean message) {
        String action = "fetch notifications of";
        try {
            if (unread) {
                if (check) {
                    if (message) {
                        action = "check unread message notifications of";
                        logger.info("Checking unread message notifications of user: " + id);
                        return super.checkChildOf(id, "unread_message", String.valueOf(true), "User", ResourceNames.NOTIFICATION);
                    }
                    action = "check unread notifications of";
                    logger.info("Checking unread notifications of user: " + id);
                    return super.checkChildOf(id, "unread", String.valueOf(true), "User", ResourceNames.NOTIFICATION);
                }
                action = "fetch unread notifications of";
                logger.info("Getting all unread notifications of user: " + id);
                return super.readChildOfWithParameter(id, "unread", "", "User", ResourceNames.NOTIFICATION);
            }
            logger.info("Getting all notifications of user: " + id);
            return super.readChildOfWithParameter(id, "recent_limit", String.valueOf(limit), "User", ResourceNames.NOTIFICATION);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", action, id);
        }
    }

    @PUT
    @Path(value="users/{id}/notifications")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response setAllNotificationReadByUser(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Setting all notifications to read of user: " + id);
            Notification notification = new Notification();
            notification.setRead(true);
            return super.updateChildOf(id, "", (IdResource)notification, "User");
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", "mark notifications read of", id);
        }
    }

    @GET
    @Path(value="users/{id}/notifications/channels")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getUserNotificationChannels(@NotNull @PathParam(value="id") String id, @NotNull NotificationType notificationType) {
        try {
            logger.info("Getting notification channels of user {} with type {} ", (Object)id, (Object)notificationType.toString());
            return super.readChildOfWithParameter(id, "notification_type", String.valueOf(notificationType), "User", ResourceNames.NOTIFICATION);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", "read notification channels of", id);
        }
    }

    @GET
    @Path(value="users/{id}/notifications/preferences")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getUserNotificationPreferences(@NotNull @PathParam(value="id") String id) {
        try {
            logger.info("Getting notification preferences of user {}", (Object)id);
            return super.readChildOf(id, "User", ResourceNames.NOTIFICATION_PREFERENCES);
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", "read notification preferences of", id);
        }
    }

    @PUT
    @Path(value="users/{id}/notifications/preferences")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @Consumes(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response setUserNotificationPreferences(@NotNull @PathParam(value="id") String id, @NotNull List<NotificationPreference> notificationPreferences) {
        try {
            logger.info("Setting notification preferences of user {}", (Object)id);
            return super.BatchUpdateChildOf(id, new ArrayList<NotificationPreference>(notificationPreferences), "User");
        }
        catch (Exception e) {
            return this.ErrorHandler(e, "user", "set notification preferences of", id);
        }
    }
}

