/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.socialnetworking.socialdataindexer.utils;

import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendNotification
extends PluginStateNotification {
    private Map<String, String> pluginInputs;
    private static Logger logger = LoggerFactory.getLogger(SendNotification.class);
    private static final String NOTIFY_METHOD = "/2/notifications/notify-job-status";
    private static final String resource = "jersey-servlet";
    private static final String serviceName = "SocialNetworking";
    private static final String serviceClass = "Portal";
    private static final String RECIPIENT_KEY = "recipient";
    private static final String SERVICE_NAME = "Smart Executor";

    public SendNotification(Map<String, String> inputs) {
        super(inputs);
        this.pluginInputs = inputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pluginStateEvolution(PluginStateEvolution pluginStateEvolution, Exception exception) throws Exception {
        switch (pluginStateEvolution.getPluginState()) {
            case STOPPED: 
            case FAILED: 
            case DISCARDED: {
                String recipient = this.pluginInputs.get(RECIPIENT_KEY);
                String basePath = SendNotification.discoverEndPoint();
                logger.info("Recipient of the notification is " + recipient + ". Base path found for the notification service is " + basePath);
                if (basePath == null || recipient == null) break;
                DefaultHttpClient httpClient = new DefaultHttpClient();
                JSONObject obj = new JSONObject();
                obj.put((Object)"job_id", (Object)pluginStateEvolution.getUuid());
                obj.put((Object)RECIPIENT_KEY, (Object)recipient);
                obj.put((Object)"job_name", (Object)pluginStateEvolution.getPluginDeclaration().getName());
                obj.put((Object)"service_name", (Object)SERVICE_NAME);
                obj.put((Object)"status", (Object)"FAILED");
                obj.put((Object)"status_message", (Object)("original status reported by Smart Executor was " + pluginStateEvolution.getPluginState() + ". Exception is " + exception != null ? exception.getMessage() : null));
                try {
                    HttpPost request = new HttpPost(basePath + NOTIFY_METHOD);
                    StringEntity params = new StringEntity(obj.toJSONString());
                    request.setEntity((HttpEntity)params);
                    HttpResponse response = httpClient.execute((HttpUriRequest)request);
                    logger.debug(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
                    break;
                }
                catch (Exception ex) {
                    logger.error("Error while sending notification ", (Throwable)ex);
                    break;
                }
                finally {
                    if (httpClient != null) {
                        httpClient.getConnectionManager().shutdown();
                    }
                }
            }
            default: {
                logger.info("No notification is going to be sent, because the status of the plugin execution is " + pluginStateEvolution.getPluginState().name());
            }
        }
    }

    private static String discoverEndPoint() {
        String context = ScopeProvider.instance.get();
        String basePath = null;
        try {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition(String.format("$resource/Profile/ServiceClass/text() eq '%s'", serviceClass));
            query.addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'");
            query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s'", serviceName));
            query.setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces//Endpoint[@EntryName/string() eq \"jersey-servlet\"]/text()");
            DiscoveryClient client = ICFactory.client();
            List endpoints = client.submit((Query)query);
            if (endpoints == null || endpoints.isEmpty()) {
                throw new Exception("Cannot retrieve the GCoreEndpoint serviceName: SocialNetworking, serviceClass: Portal, in scope: " + context);
            }
            basePath = (String)endpoints.get(0);
            if (basePath == null) {
                throw new Exception("Endpoint:jersey-servlet, is null for serviceName: SocialNetworking, serviceClass: Portal, in scope: " + context);
            }
            logger.info("found entyname " + basePath + " for ckanResource: " + resource);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such service endpoint information!", (Throwable)e);
        }
        return basePath;
    }
}

