/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.PropertyWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedDynamicProperty {
    private static final Logger logger = LoggerFactory.getLogger(ChainedDynamicProperty.class);

    public static class DynamicBooleanPropertyThatSupportsNull
    extends PropertyWrapper<Boolean> {
        DynamicBooleanPropertyThatSupportsNull(String propName, Boolean defaultValue) {
            super(propName, defaultValue);
        }

        public Boolean get() {
            return this.prop.getBoolean((Boolean)this.defaultValue);
        }

        @Override
        public Boolean getValue() {
            return this.get();
        }
    }

    public static class BooleanProperty
    extends ChainLink<Boolean> {
        private final DynamicBooleanPropertyThatSupportsNull sProp;

        public BooleanProperty(DynamicBooleanPropertyThatSupportsNull sProperty) {
            this.sProp = sProperty;
        }

        public BooleanProperty(String name, DynamicBooleanPropertyThatSupportsNull sProperty) {
            this(name, new BooleanProperty(sProperty));
        }

        public BooleanProperty(String name, BooleanProperty next) {
            super(next);
            this.sProp = new DynamicBooleanPropertyThatSupportsNull(name, null);
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Property changed: '" + BooleanProperty.this.getName() + " = " + BooleanProperty.this.getValue() + "'");
                    logger.info("Property changed: '" + BooleanProperty.this.getName() + " = " + BooleanProperty.this.getValue() + "'");
                    BooleanProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.getValue() != null;
        }

        @Override
        public Boolean getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static class FloatProperty
    extends ChainLink<Float> {
        private final DynamicFloatProperty sProp;

        public FloatProperty(DynamicFloatProperty sProperty) {
            this.sProp = sProperty;
        }

        public FloatProperty(String name, DynamicFloatProperty sProperty) {
            this(name, new FloatProperty(sProperty));
        }

        public FloatProperty(String name, FloatProperty next) {
            super(next);
            this.sProp = DynamicPropertyFactory.getInstance().getFloatProperty(name, Float.MIN_VALUE);
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + FloatProperty.this.getName() + " = " + FloatProperty.this.getValue() + "'");
                    FloatProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return Math.abs(this.sProp.get() - Float.MIN_VALUE) > 1.0E-6f;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.sProp.get());
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static class IntProperty
    extends ChainLink<Integer> {
        private final DynamicIntProperty sProp;

        public IntProperty(DynamicIntProperty sProperty) {
            this.sProp = sProperty;
        }

        public IntProperty(String name, DynamicIntProperty sProperty) {
            this(name, new IntProperty(sProperty));
        }

        public IntProperty(String name, IntProperty next) {
            super(next);
            this.sProp = DynamicPropertyFactory.getInstance().getIntProperty(name, Integer.MIN_VALUE);
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + IntProperty.this.getName() + " = " + IntProperty.this.getValue() + "'");
                    IntProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != Integer.MIN_VALUE;
        }

        @Override
        public Integer getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static class StringProperty
    extends ChainLink<String> {
        private final DynamicStringProperty sProp;

        public StringProperty(DynamicStringProperty sProperty) {
            this.sProp = sProperty;
        }

        public StringProperty(String name, DynamicStringProperty sProperty) {
            this(name, new StringProperty(sProperty));
        }

        public StringProperty(String name, StringProperty next) {
            super(next);
            this.sProp = DynamicPropertyFactory.getInstance().getStringProperty(name, null);
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + StringProperty.this.getName() + " = " + StringProperty.this.getValue() + "'");
                    StringProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != null;
        }

        @Override
        protected String getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static abstract class ChainLink<T> {
        private final AtomicReference<ChainLink<T>> pReference;
        private final ChainLink<T> next;
        private final List<Runnable> callbacks;

        public abstract String getName();

        protected abstract T getValue();

        public abstract boolean isValueAcceptable();

        public ChainLink() {
            this.next = null;
            this.pReference = new AtomicReference<ChainLink>(this);
            this.callbacks = new ArrayList<Runnable>();
        }

        public ChainLink(ChainLink<T> nextProperty) {
            this.next = nextProperty;
            this.pReference = new AtomicReference<ChainLink<T>>(this.next);
            this.callbacks = new ArrayList<Runnable>();
        }

        protected void checkAndFlip() {
            if (this.next == null) {
                this.pReference.set(this);
                return;
            }
            if (this.isValueAcceptable()) {
                logger.info("Flipping property: " + this.getName() + " to use it's current value:" + this.getValue());
                this.pReference.set(this);
            } else {
                logger.info("Flipping property: " + this.getName() + " to use NEXT property: " + this.next);
                this.pReference.set(this.next);
            }
            for (Runnable r : this.callbacks) {
                r.run();
            }
        }

        public T get() {
            if (this.pReference.get() == this) {
                return this.getValue();
            }
            return this.pReference.get().get();
        }

        public void addCallback(Runnable r) {
            this.callbacks.add(r);
        }

        public String toString() {
            return this.getName() + " = " + this.get();
        }
    }
}

