/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DynamicListProperty<T> {
    private volatile List<T> values;
    private List<T> defaultValues;
    private DynamicStringProperty delegate;
    private Splitter splitter;
    public static final String DEFAULT_DELIMITER = ",";

    public DynamicListProperty(String propName, String defaultValue) {
        this(propName, defaultValue, DEFAULT_DELIMITER);
    }

    public DynamicListProperty(String propName, String defaultValue, String delimiterRegex) {
        this.splitter = Splitter.onPattern((String)delimiterRegex).omitEmptyStrings().trimResults();
        this.setup(propName, this.transform(this.split(defaultValue)), this.splitter);
    }

    public DynamicListProperty(String propName, List<T> defaultValue) {
        this(propName, defaultValue, DEFAULT_DELIMITER);
    }

    public DynamicListProperty(String propName, List<T> defaultValue, String delimiterRegex) {
        this.setup(propName, defaultValue, delimiterRegex);
    }

    public DynamicListProperty(String propName, List<T> defaultValue, Splitter splitter) {
        this.setup(propName, defaultValue, splitter);
    }

    private void setup(String propName, List<T> defaultValue, String delimiterRegex) {
        this.setup(propName, defaultValue, Splitter.onPattern((String)delimiterRegex).omitEmptyStrings().trimResults());
    }

    private void setup(String propName, List<T> defaultValue, Splitter splitter) {
        this.defaultValues = defaultValue;
        this.splitter = splitter;
        this.delegate = DynamicPropertyFactory.getInstance().getStringProperty(propName, null);
        this.load();
        this.delegate.addCallback(new Runnable(){

            @Override
            public void run() {
                DynamicListProperty.this.propertyChangedInternal();
            }
        });
    }

    private void propertyChangedInternal() {
        this.load();
        this.propertyChanged();
    }

    protected void propertyChanged() {
    }

    public List<T> get() {
        return this.values;
    }

    private List<String> split(String value) {
        return Lists.newArrayList((Iterable)this.splitter.split((CharSequence)Strings.nullToEmpty((String)value)));
    }

    protected List<T> transform(List<String> stringValues) {
        ArrayList<T> list = new ArrayList<T>(stringValues.size());
        for (String s : stringValues) {
            list.add(this.from(s));
        }
        return Collections.unmodifiableList(list);
    }

    protected void load() {
        this.values = this.delegate.get() == null ? this.defaultValues : this.transform(this.split(this.delegate.get()));
    }

    public long getChangedTimestamp() {
        return this.delegate.getChangedTimestamp();
    }

    public void addCallback(Runnable callback) {
        if (callback != null) {
            this.delegate.addCallback(callback);
        }
    }

    protected abstract T from(String var1);
}

