/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.examples;

import com.google.common.collect.Lists;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.publish.CounterToRateMetricTransform;
import com.netflix.servo.publish.MemoryMetricObserver;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import com.netflix.servo.util.ThreadCpuStats;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class ManyMetricsExample {
    private ManyMetricsExample() {
    }

    private static Counter newCounter(int tagsPerMetric, int i) {
        MonitorConfig cfg = MonitorConfig.builder("nameOfCounter." + i).withTag("class", ManyMetricsExample.class.getSimpleName()).withTag("id", "idForCounter." + i).build();
        return new BasicCounter(cfg);
    }

    private static void startPolling() {
        PollScheduler scheduler = PollScheduler.getInstance();
        scheduler.start();
        int heartbeatInterval = 20;
        CounterToRateMetricTransform transform = new CounterToRateMetricTransform(new MemoryMetricObserver("test", 1), 20L, TimeUnit.SECONDS);
        MetricFilter filter = new MetricFilter(){

            @Override
            public boolean matches(MonitorConfig config) {
                String id = config.getTags().getValue("id");
                return id != null && id.endsWith("0");
            }
        };
        PollRunnable task = new PollRunnable((MetricPoller)new MonitorRegistryMetricPoller(), filter, transform);
        boolean samplingInterval = true;
        scheduler.addPoller(task, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: ManyMetricsExample <tagsPerMetric> <numMetrics>");
            System.exit(1);
        }
        int tagsPerMetric = Integer.valueOf(args[0]);
        int numMetrics = Integer.valueOf(args[1]);
        ArrayList counters = Lists.newArrayList();
        for (int i = 0; i < numMetrics; ++i) {
            Counter c = ManyMetricsExample.newCounter(tagsPerMetric, i);
            counters.add(c);
            DefaultMonitorRegistry.getInstance().register(c);
        }
        ManyMetricsExample.startPolling();
        ThreadCpuStats stats = ThreadCpuStats.getInstance();
        stats.start();
        Timer t = Monitors.newTimer("updateCounts");
        DefaultMonitorRegistry.getInstance().register(t);
        long delay = 500L;
        int report = 120;
        int count = 0;
        while (true) {
            Stopwatch s = t.start();
            try {
                for (Counter c : counters) {
                    c.increment();
                }
                if (count % 120 == 0) {
                    stats.printThreadCpuUsages();
                }
                Thread.sleep(500L);
                ++count;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                s.stop();
                continue;
            }
            break;
        }
    }
}

