/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.contrib.dualwrites.FailedWritesLogger;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassBasedFailedWritesLogger
implements FailedWritesLogger {
    private static final Logger Logger = LoggerFactory.getLogger(CassBasedFailedWritesLogger.class);
    private final AstyanaxContext<Keyspace> ksContext;
    private Keyspace ks;
    private final CircularCounter counter;

    public CassBasedFailedWritesLogger(AstyanaxContext<Keyspace> ctx) {
        this(ctx, 10);
    }

    public CassBasedFailedWritesLogger(AstyanaxContext<Keyspace> ctx, int numShards) {
        if (numShards <= 0) {
            throw new RuntimeException("numShards must be > 0");
        }
        this.ksContext = ctx;
        this.counter = new CircularCounter(numShards);
    }

    @Override
    public void logFailedWrite(WriteMetadata failedWrite) {
        MutationBatch mutationBatch = this.ks.prepareMutationBatch();
        this.addToBatch(mutationBatch, failedWrite);
        try {
            mutationBatch.execute();
        }
        catch (ConnectionException e) {
            Logger.error("Failed to log failed write to fallback cluster: " + failedWrite, (Throwable)e);
        }
    }

    private void addToBatch(MutationBatch batch, WriteMetadata failedWrite) {
        if (failedWrite.getCFName() == null || failedWrite.getRowKey() == null) {
            return;
        }
        String cfName = failedWrite.getPrimaryCluster() + "-" + failedWrite.getPrimaryKeyspace();
        ColumnFamily CF_FAILED_WRITES = ColumnFamily.newColumnFamily((String)cfName, (Serializer)StringSerializer.get(), (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());
        String rowKey = failedWrite.getCFName() + "_" + this.counter.getNext();
        Long column = failedWrite.getUuid();
        String value = failedWrite.getRowKey();
        batch.withRow(CF_FAILED_WRITES, (Object)rowKey).putColumn((Object)column, value);
    }

    @Override
    public void init() {
        this.ks = (Keyspace)this.ksContext.getClient();
        this.ksContext.start();
    }

    @Override
    public void shutdown() {
        this.ksContext.shutdown();
    }

    private class CircularCounter {
        private final int maxLimit;
        private final AtomicInteger counter = new AtomicInteger(0);

        private CircularCounter(int limit) {
            this.maxLimit = limit;
        }

        private int getNext() {
            int count = this.counter.incrementAndGet();
            return count % this.maxLimit;
        }
    }
}

