/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

public class DualKeyspaceMetadata {
    private final String primaryCluster;
    private final String primaryKeyspaceName;
    private final String secondaryCluster;
    private final String secondaryKeyspaceName;

    public DualKeyspaceMetadata(String primaryCluster, String primaryKeyspaceName, String secondaryCluster, String secondaryKeyspaceName) {
        if (primaryCluster == null || primaryKeyspaceName == null) {
            throw new RuntimeException("primaryCluster and primaryKeyspaceName cannot be NULL");
        }
        if (secondaryCluster == null || secondaryKeyspaceName == null) {
            throw new RuntimeException("secondaryCluster and secondaryKeyspaceName cannot be NULL");
        }
        this.primaryCluster = primaryCluster;
        this.primaryKeyspaceName = primaryKeyspaceName;
        this.secondaryCluster = secondaryCluster;
        this.secondaryKeyspaceName = secondaryKeyspaceName;
    }

    public String getPrimaryCluster() {
        return this.primaryCluster;
    }

    public String getPrimaryKeyspaceName() {
        return this.primaryKeyspaceName;
    }

    public String getSecondaryCluster() {
        return this.secondaryCluster;
    }

    public String getSecondaryKeyspaceName() {
        return this.secondaryKeyspaceName;
    }

    public boolean isReverse(DualKeyspaceMetadata newDualKeyspaceSetup) {
        return !this.equals(newDualKeyspaceSetup) && this.primaryCluster.equals(newDualKeyspaceSetup.getSecondaryCluster()) && this.secondaryCluster.equals(newDualKeyspaceSetup.getPrimaryCluster());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.primaryCluster == null ? 0 : this.primaryCluster.hashCode());
        result = 31 * result + (this.primaryKeyspaceName == null ? 0 : this.primaryKeyspaceName.hashCode());
        result = 31 * result + (this.secondaryCluster == null ? 0 : this.secondaryCluster.hashCode());
        result = 31 * result + (this.secondaryKeyspaceName == null ? 0 : this.secondaryKeyspaceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DualKeyspaceMetadata other = (DualKeyspaceMetadata)obj;
        boolean equals = true;
        equals &= this.primaryCluster != null ? this.primaryCluster.equals(other.primaryCluster) : other.primaryCluster == null;
        equals &= this.primaryKeyspaceName != null ? this.primaryKeyspaceName.equals(other.primaryKeyspaceName) : other.primaryKeyspaceName == null;
        equals &= this.secondaryCluster != null ? this.secondaryCluster.equals(other.secondaryCluster) : other.secondaryCluster == null;
        return equals &= this.secondaryKeyspaceName != null ? this.secondaryKeyspaceName.equals(other.secondaryKeyspaceName) : other.secondaryKeyspaceName == null;
    }

    public String toString() {
        return "DualKeyspaceMetadata [primaryCluster=" + this.primaryCluster + ", primaryKeyspaceName=" + this.primaryKeyspaceName + ", secondaryCluster=" + this.secondaryCluster + ", secondaryKeyspaceName=" + this.secondaryKeyspaceName + "]";
    }
}

