/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.netflix.astyanax.contrib.dualwrites.DualKeyspaceMetadata;

public class WriteMetadata {
    private final DualKeyspaceMetadata dualKeyspaceMetadata;
    private final String cfName;
    private final String rowKey;
    private final Long uuid;

    public WriteMetadata(DualKeyspaceMetadata keyspaceMetadata, String cfName, String rowKey) {
        this.dualKeyspaceMetadata = keyspaceMetadata;
        this.rowKey = rowKey;
        this.cfName = cfName;
        this.uuid = System.currentTimeMillis();
    }

    public String getPrimaryCluster() {
        return this.dualKeyspaceMetadata.getPrimaryCluster();
    }

    public String getSecondaryCluster() {
        return this.dualKeyspaceMetadata.getSecondaryCluster();
    }

    public String getPrimaryKeyspace() {
        return this.dualKeyspaceMetadata.getPrimaryKeyspaceName();
    }

    public String getSecondaryKeyspace() {
        return this.dualKeyspaceMetadata.getSecondaryKeyspaceName();
    }

    public String getCFName() {
        return this.cfName;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public Long getUuid() {
        return this.uuid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dualKeyspaceMetadata.hashCode();
        result = 31 * result + (this.cfName == null ? 0 : this.cfName.hashCode());
        result = 31 * result + (this.rowKey == null ? 0 : this.rowKey.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WriteMetadata other = (WriteMetadata)obj;
        boolean equals = true;
        equals &= this.dualKeyspaceMetadata != null ? this.dualKeyspaceMetadata.equals(other.dualKeyspaceMetadata) : other.dualKeyspaceMetadata == null;
        equals &= this.cfName != null ? this.cfName.equals(other.cfName) : other.cfName == null;
        equals &= this.rowKey != null ? this.rowKey.equals(other.rowKey) : other.rowKey == null;
        return equals &= this.uuid != null ? this.uuid.equals(other.uuid) : other.uuid == null;
    }

    public String toString() {
        return "FailedWriteMetadata [" + this.dualKeyspaceMetadata + ", cfName=" + this.cfName + ", rowKey=" + this.rowKey + ", uuid=" + this.uuid + "]";
    }
}

