/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.delete;

import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.warmer.IndexWarmerMissingException;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteWarmerAction
extends TransportMasterNodeAction<DeleteWarmerRequest, DeleteWarmerResponse> {
    @Inject
    public TransportDeleteWarmerAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/warmers/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteWarmerRequest.class);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected DeleteWarmerResponse newResponse() {
        return new DeleteWarmerResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteWarmerRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndices(state, request));
    }

    @Override
    protected void masterOperation(final DeleteWarmerRequest request, ClusterState state, ActionListener<DeleteWarmerResponse> listener) {
        final String[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        this.clusterService.submitStateUpdateTask("delete_warmer [" + Arrays.toString(request.names()) + "]", new AckedClusterStateUpdateTask<DeleteWarmerResponse>((AckedRequest)request, listener){

            @Override
            protected DeleteWarmerResponse newResponse(boolean acknowledged) {
                return new DeleteWarmerResponse(acknowledged);
            }

            @Override
            public void onFailure(String source, Throwable t) {
                TransportDeleteWarmerAction.this.logger.debug("failed to delete warmer [{}] on indices [{}]", t, Arrays.toString(request.names()), concreteIndices);
                super.onFailure(source, t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                IndexWarmersMetaData warmers;
                IndexMetaData indexMetaData;
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                boolean globalFoundAtLeastOne = false;
                boolean deleteAll = false;
                for (int i = 0; i < request.names().length; ++i) {
                    if (!request.names()[i].equals("_all")) continue;
                    deleteAll = true;
                    break;
                }
                for (String index : concreteIndices) {
                    indexMetaData = currentState.metaData().index(index);
                    if (indexMetaData == null) {
                        throw new IndexNotFoundException(index);
                    }
                    warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                    if (warmers == null) continue;
                    ArrayList<IndexWarmersMetaData.Entry> entries = new ArrayList<IndexWarmersMetaData.Entry>();
                    for (IndexWarmersMetaData.Entry entry : warmers.entries()) {
                        boolean keepWarmer = true;
                        for (String warmer : request.names()) {
                            if (!Regex.simpleMatch(warmer, entry.name()) && !warmer.equals("_all")) continue;
                            globalFoundAtLeastOne = true;
                            keepWarmer = false;
                            break;
                        }
                        if (!keepWarmer) continue;
                        entries.add(entry);
                    }
                    if (entries.size() == warmers.entries().size()) continue;
                    warmers = new IndexWarmersMetaData(entries.toArray(new IndexWarmersMetaData.Entry[entries.size()]));
                    IndexMetaData.Builder indexBuilder = IndexMetaData.builder(indexMetaData).putCustom("warmers", warmers);
                    mdBuilder.put(indexBuilder);
                }
                if (!globalFoundAtLeastOne && !deleteAll) {
                    throw new IndexWarmerMissingException(request.names());
                }
                if (TransportDeleteWarmerAction.this.logger.isInfoEnabled()) {
                    for (String index : concreteIndices) {
                        indexMetaData = currentState.metaData().index(index);
                        if (indexMetaData == null) {
                            throw new IndexNotFoundException(index);
                        }
                        warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                        if (warmers != null) {
                            for (IndexWarmersMetaData.Entry entry : warmers.entries()) {
                                for (String warmer : request.names()) {
                                    if (!Regex.simpleMatch(warmer, entry.name()) && !warmer.equals("_all")) continue;
                                    TransportDeleteWarmerAction.this.logger.info("[{}] delete warmer [{}]", index, entry.name());
                                }
                            }
                            continue;
                        }
                        if (!deleteAll) continue;
                        TransportDeleteWarmerAction.this.logger.debug("no warmers to delete on index [{}]", index);
                    }
                }
                return ClusterState.builder(currentState).metaData(mdBuilder).build();
            }
        });
    }
}

