/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class TransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends AbstractComponent {
    protected final ThreadPool threadPool;
    protected final String actionName;
    private final ActionFilter[] filters;
    protected final ParseFieldMatcher parseFieldMatcher;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;

    protected TransportAction(Settings settings, String actionName, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings);
        this.threadPool = threadPool;
        this.actionName = actionName;
        this.filters = actionFilters.filters();
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public final ActionFuture<Response> execute(Request request) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        this.execute(request, future);
        return future;
    }

    public final void execute(Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException = ((ActionRequest)request).validate();
        if (validationException != null) {
            listener.onFailure(validationException);
            return;
        }
        if (this.filters.length == 0) {
            try {
                this.doExecute(request, listener);
            }
            catch (Throwable t) {
                this.logger.trace("Error during transport action execution.", t, new Object[0]);
                listener.onFailure(t);
            }
        } else {
            RequestFilterChain requestFilterChain = new RequestFilterChain(this, this.logger);
            requestFilterChain.proceed(this.actionName, (ActionRequest)request, (ActionListener)listener);
        }
    }

    protected abstract void doExecute(Request var1, ActionListener<Response> var2);

    private static class FilteredActionListener<Response extends ActionResponse>
    implements ActionListener<Response> {
        private final String actionName;
        private final ActionListener listener;
        private final ResponseFilterChain chain;

        private FilteredActionListener(String actionName, ActionListener listener, ResponseFilterChain chain) {
            this.actionName = actionName;
            this.listener = listener;
            this.chain = chain;
        }

        @Override
        public void onResponse(Response response) {
            this.chain.proceed(this.actionName, (ActionResponse)response, this.listener);
        }

        @Override
        public void onFailure(Throwable e) {
            this.listener.onFailure(e);
        }
    }

    private static class ResponseFilterChain
    implements ActionFilterChain {
        private final ActionFilter[] filters;
        private final AtomicInteger index;
        private final ESLogger logger;

        private ResponseFilterChain(ActionFilter[] filters, ESLogger logger) {
            this.filters = filters;
            this.index = new AtomicInteger(filters.length);
            this.logger = logger;
        }

        @Override
        public void proceed(String action, ActionRequest request, ActionListener listener) {
            assert (false) : "response filter chain should never be called on the request side";
        }

        @Override
        public void proceed(String action, ActionResponse response, ActionListener listener) {
            int i = this.index.decrementAndGet();
            try {
                if (i >= 0) {
                    this.filters[i].apply(action, response, listener, (ActionFilterChain)this);
                } else if (i == -1) {
                    listener.onResponse(response);
                } else {
                    listener.onFailure(new IllegalStateException("proceed was called too many times"));
                }
            }
            catch (Throwable t) {
                this.logger.trace("Error during transport action execution.", t, new Object[0]);
                listener.onFailure(t);
            }
        }
    }

    private static class RequestFilterChain<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain {
        private final TransportAction<Request, Response> action;
        private final AtomicInteger index = new AtomicInteger();
        private final ESLogger logger;

        private RequestFilterChain(TransportAction<Request, Response> action, ESLogger logger) {
            this.action = action;
            this.logger = logger;
        }

        @Override
        public void proceed(String actionName, ActionRequest request, ActionListener listener) {
            int i = this.index.getAndIncrement();
            try {
                if (i < ((TransportAction)this.action).filters.length) {
                    ((TransportAction)this.action).filters[i].apply(actionName, request, listener, (ActionFilterChain)this);
                } else if (i == ((TransportAction)this.action).filters.length) {
                    this.action.doExecute(request, new FilteredActionListener(actionName, listener, new ResponseFilterChain(((TransportAction)this.action).filters, this.logger)));
                } else {
                    listener.onFailure(new IllegalStateException("proceed was called too many times"));
                }
            }
            catch (Throwable t) {
                this.logger.trace("Error during transport action execution.", t, new Object[0]);
                listener.onFailure(t);
            }
        }

        @Override
        public void proceed(String action, ActionResponse response, ActionListener listener) {
            assert (false) : "request filter chain should never be called on the response side";
        }
    }
}

