/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.regex.Regex;

public class DynamicSettings {
    private final Map<String, Validator> dynamicSettings;

    private DynamicSettings(Map<String, Validator> settings) {
        this.dynamicSettings = Collections.unmodifiableMap(settings);
    }

    public boolean isDynamicOrLoggingSetting(String key) {
        return this.hasDynamicSetting(key) || key.startsWith("logger.");
    }

    public boolean hasDynamicSetting(String key) {
        for (String dynamicSetting : this.dynamicSettings.keySet()) {
            if (!Regex.simpleMatch(dynamicSetting, key)) continue;
            return true;
        }
        return false;
    }

    public String validateDynamicSetting(String dynamicSetting, String value, ClusterState clusterState) {
        for (Map.Entry<String, Validator> setting : this.dynamicSettings.entrySet()) {
            if (!Regex.simpleMatch(setting.getKey(), dynamicSetting)) continue;
            return setting.getValue().validate(dynamicSetting, value, clusterState);
        }
        return null;
    }

    public static class Builder {
        private Map<String, Validator> settings = new HashMap<String, Validator>();

        public void addSetting(String setting, Validator validator) {
            Validator old = this.settings.put(setting, validator);
            if (old != null) {
                throw new IllegalArgumentException("Cannot register setting [" + setting + "] twice");
            }
        }

        public DynamicSettings build() {
            return new DynamicSettings(this.settings);
        }
    }
}

