/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.MatchQuery;
import org.elasticsearch.index.search.MultiMatchQuery;

public class MultiMatchQueryParser
implements QueryParser {
    public static final String NAME = "multi_match";

    @Inject
    public MultiMatchQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "multiMatch"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Object value = null;
        float boost = 1.0f;
        Float tieBreaker = null;
        MultiMatchQueryBuilder.Type type = null;
        MultiMatchQuery multiMatchQuery = new MultiMatchQuery(parseContext);
        String minimumShouldMatch = null;
        HashMap fieldNameWithBoosts = Maps.newHashMap();
        String queryName = null;
        String currentFieldName = null;
        Boolean useDisMax = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("fields".equals(currentFieldName)) {
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        this.extractFieldAndBoost(parseContext, parser, fieldNameWithBoosts);
                    }
                    continue;
                }
                if (token.isValue()) {
                    this.extractFieldAndBoost(parseContext, parser, fieldNameWithBoosts);
                    continue;
                }
                throw new QueryParsingException(parseContext, "[multi_match] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if ("query".equals(currentFieldName)) {
                value = parser.objectText();
                continue;
            }
            if ("type".equals(currentFieldName)) {
                type = MultiMatchQueryBuilder.Type.parse(parser.text(), parseContext.parseFieldMatcher());
                continue;
            }
            if ("analyzer".equals(currentFieldName)) {
                String analyzer = parser.text();
                if (parseContext.analysisService().analyzer(analyzer) == null) {
                    throw new QueryParsingException(parseContext, "[multi_match] analyzer [" + parser.text() + "] not found", new Object[0]);
                }
                multiMatchQuery.setAnalyzer(analyzer);
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("slop".equals(currentFieldName) || "phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                multiMatchQuery.setPhraseSlop(parser.intValue());
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, Fuzziness.FIELD)) {
                multiMatchQuery.setFuzziness(Fuzziness.parse(parser));
                continue;
            }
            if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                multiMatchQuery.setFuzzyPrefixLength(parser.intValue());
                continue;
            }
            if ("max_expansions".equals(currentFieldName) || "maxExpansions".equals(currentFieldName)) {
                multiMatchQuery.setMaxExpansions(parser.intValue());
                continue;
            }
            if ("operator".equals(currentFieldName)) {
                String op = parser.text();
                if ("or".equalsIgnoreCase(op)) {
                    multiMatchQuery.setOccur(BooleanClause.Occur.SHOULD);
                    continue;
                }
                if ("and".equalsIgnoreCase(op)) {
                    multiMatchQuery.setOccur(BooleanClause.Occur.MUST);
                    continue;
                }
                throw new QueryParsingException(parseContext, "text query requires operator to be either 'and' or 'or', not [" + op + "]", new Object[0]);
            }
            if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if ("fuzzy_rewrite".equals(currentFieldName) || "fuzzyRewrite".equals(currentFieldName)) {
                multiMatchQuery.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(parseContext.parseFieldMatcher(), parser.textOrNull(), null));
                continue;
            }
            if ("use_dis_max".equals(currentFieldName) || "useDisMax".equals(currentFieldName)) {
                useDisMax = parser.booleanValue();
                continue;
            }
            if ("tie_breaker".equals(currentFieldName) || "tieBreaker".equals(currentFieldName)) {
                tieBreaker = Float.valueOf(parser.floatValue());
                multiMatchQuery.setTieBreaker(tieBreaker.floatValue());
                continue;
            }
            if ("cutoff_frequency".equals(currentFieldName)) {
                multiMatchQuery.setCommonTermsCutoff(parser.floatValue());
                continue;
            }
            if ("lenient".equals(currentFieldName)) {
                multiMatchQuery.setLenient(parser.booleanValue());
                continue;
            }
            if ("zero_terms_query".equals(currentFieldName)) {
                String zeroTermsDocs = parser.text();
                if ("none".equalsIgnoreCase(zeroTermsDocs)) {
                    multiMatchQuery.setZeroTermsQuery(MatchQuery.ZeroTermsQuery.NONE);
                    continue;
                }
                if ("all".equalsIgnoreCase(zeroTermsDocs)) {
                    multiMatchQuery.setZeroTermsQuery(MatchQuery.ZeroTermsQuery.ALL);
                    continue;
                }
                throw new QueryParsingException(parseContext, "Unsupported zero_terms_docs value [" + zeroTermsDocs + "]", new Object[0]);
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[match] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (value == null) {
            throw new QueryParsingException(parseContext, "No text specified for multi_match query", new Object[0]);
        }
        if (fieldNameWithBoosts.isEmpty()) {
            throw new QueryParsingException(parseContext, "No fields specified for multi_match query", new Object[0]);
        }
        if (type == null) {
            type = MultiMatchQueryBuilder.Type.BEST_FIELDS;
        }
        if (useDisMax != null) {
            boolean typeUsesDismax;
            boolean bl = typeUsesDismax = type.tieBreaker() != 1.0f;
            if (typeUsesDismax != useDisMax) {
                if (useDisMax.booleanValue() && tieBreaker == null) {
                    multiMatchQuery.setTieBreaker(0.0f);
                } else {
                    multiMatchQuery.setTieBreaker(1.0f);
                }
            }
        }
        if ((query = multiMatchQuery.parse(type, fieldNameWithBoosts, value, minimumShouldMatch)) == null) {
            return null;
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }

    private void extractFieldAndBoost(QueryParseContext parseContext, XContentParser parser, Map<String, Float> fieldNameWithBoosts) throws IOException {
        String fField = null;
        Float fBoost = null;
        char[] fieldText = parser.textCharacters();
        int end = parser.textOffset() + parser.textLength();
        for (int i = parser.textOffset(); i < end; ++i) {
            if (fieldText[i] != '^') continue;
            int relativeLocation = i - parser.textOffset();
            fField = new String(fieldText, parser.textOffset(), relativeLocation);
            fBoost = Float.valueOf(Float.parseFloat(new String(fieldText, i + 1, parser.textLength() - relativeLocation - 1)));
            break;
        }
        if (fField == null) {
            fField = parser.text();
        }
        if (Regex.isSimpleMatchPattern(fField)) {
            for (String field : parseContext.mapperService().simpleMatchToIndexNames(fField)) {
                fieldNameWithBoosts.put(field, fBoost);
            }
        } else {
            fieldNameWithBoosts.put(fField, fBoost);
        }
    }
}

