/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;

public enum ValueType {
    ANY("any", ValuesSource.class, IndexFieldData.class, ValueFormat.RAW),
    STRING("string", ValuesSource.Bytes.class, IndexFieldData.class, ValueFormat.RAW),
    LONG("byte|short|integer|long", ValuesSource.Numeric.class, IndexNumericFieldData.class, ValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    DOUBLE("float|double", ValuesSource.Numeric.class, IndexNumericFieldData.class, ValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }
    }
    ,
    NUMBER("number", ValuesSource.Numeric.class, IndexNumericFieldData.class, ValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    DATE("date", ValuesSource.Numeric.class, IndexNumericFieldData.class, (ValueFormat)ValueFormat.DateTime.DEFAULT){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    IP("ip", ValuesSource.Numeric.class, IndexNumericFieldData.class, ValueFormat.IPv4){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    NUMERIC("numeric", ValuesSource.Numeric.class, IndexNumericFieldData.class, ValueFormat.RAW){

        @Override
        public boolean isNumeric() {
            return true;
        }
    }
    ,
    GEOPOINT("geo_point", ValuesSource.GeoPoint.class, IndexGeoPointFieldData.class, ValueFormat.RAW){

        @Override
        public boolean isGeoPoint() {
            return true;
        }
    };

    final String description;
    final Class<? extends ValuesSource> valuesSourceType;
    final Class<? extends IndexFieldData> fieldDataType;
    final ValueFormat defaultFormat;

    private ValueType(String description, Class<? extends ValuesSource> valuesSourceType, Class<? extends IndexFieldData> fieldDataType, ValueFormat defaultFormat) {
        this.description = description;
        this.valuesSourceType = valuesSourceType;
        this.fieldDataType = fieldDataType;
        this.defaultFormat = defaultFormat;
    }

    public String description() {
        return this.description;
    }

    public Class<? extends ValuesSource> getValuesSourceType() {
        return this.valuesSourceType;
    }

    public boolean compatibleWith(IndexFieldData fieldData) {
        return this.fieldDataType.isInstance(fieldData);
    }

    public boolean isA(ValueType valueType) {
        return valueType.valuesSourceType.isAssignableFrom(this.valuesSourceType) && valueType.fieldDataType.isAssignableFrom(this.fieldDataType);
    }

    public boolean isNotA(ValueType valueType) {
        return !this.isA(valueType);
    }

    public ValueFormat defaultFormat() {
        return this.defaultFormat;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public boolean isGeoPoint() {
        return false;
    }

    public static ValueType resolveForScript(String type) {
        switch (type) {
            case "string": {
                return STRING;
            }
            case "double": 
            case "float": {
                return DOUBLE;
            }
            case "long": 
            case "integer": 
            case "short": 
            case "byte": {
                return LONG;
            }
            case "date": {
                return DATE;
            }
            case "ip": {
                return IP;
            }
        }
        return null;
    }

    public String toString() {
        return this.description;
    }
}

