/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool;

import java.util.Arrays;
import java.util.List;

public class SSLConnectionContext {
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final List<String> DEFAULT_SSL_CIPHER_SUITES = Arrays.asList("TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA");
    private final String sslProtocol;
    private final List<String> sslCipherSuites;
    private final String sslTruststore;
    private final String sslTruststorePassword;

    public SSLConnectionContext(String sslTruststore, String sslTruststorePassword) {
        this(sslTruststore, sslTruststorePassword, DEFAULT_SSL_PROTOCOL, DEFAULT_SSL_CIPHER_SUITES);
    }

    public SSLConnectionContext(String sslTruststore, String sslTruststorePassword, String sslProtocol, List<String> sslCipherSuites) {
        this.sslTruststore = sslTruststore;
        this.sslTruststorePassword = sslTruststorePassword;
        this.sslProtocol = sslProtocol;
        this.sslCipherSuites = sslCipherSuites;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public List<String> getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public String getSslTruststore() {
        return this.sslTruststore;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }
}

