/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.impl.TokenHostConnectionPoolPartition;
import com.netflix.astyanax.connectionpool.impl.Topology;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AbstractTopology<CL>
implements Topology<CL> {
    private TokenHostConnectionPoolPartition<CL> allPools;
    private LatencyScoreStrategy strategy;

    public AbstractTopology(LatencyScoreStrategy strategy) {
        this.strategy = strategy;
        this.allPools = new TokenHostConnectionPoolPartition(null, this.strategy);
    }

    @Override
    public synchronized boolean setPools(Collection<HostConnectionPool<CL>> ring) {
        boolean didChange = false;
        HashSet allPools = Sets.newHashSet();
        for (HostConnectionPool<CL> pool : ring) {
            allPools.add(pool);
            if (this.allPools.hasPool(pool)) continue;
            didChange = true;
        }
        return didChange;
    }

    @Override
    public synchronized void resumePool(HostConnectionPool<CL> pool) {
        this.refresh();
    }

    @Override
    public synchronized void suspendPool(HostConnectionPool<CL> pool) {
        this.refresh();
    }

    @Override
    public synchronized void refresh() {
        this.allPools.refresh();
    }

    @Override
    public TokenHostConnectionPoolPartition<CL> getPartition(ByteBuffer rowkey) {
        return this.getAllPools();
    }

    @Override
    public TokenHostConnectionPoolPartition<CL> getAllPools() {
        return this.allPools;
    }

    @Override
    public int getPartitionCount() {
        return 1;
    }

    @Override
    public synchronized void removePool(HostConnectionPool<CL> pool) {
        this.allPools.removePool(pool);
        this.refresh();
    }

    @Override
    public synchronized void addPool(HostConnectionPool<CL> pool) {
        this.allPools.addPool(pool);
        this.allPools.refresh();
    }

    @Override
    public List<String> getPartitionNames() {
        return Lists.newArrayList((Object[])new String[]{this.allPools.id().toString()});
    }

    @Override
    public TokenHostConnectionPoolPartition<CL> getPartition(String token) {
        return this.allPools;
    }

    @Override
    public Map<String, TokenHostConnectionPoolPartition<CL>> getPartitions() {
        return ImmutableMap.of((Object)this.allPools.id().toString(), this.allPools);
    }
}

