/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.test;

import com.google.common.collect.Lists;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.impl.TokenRangeImpl;
import com.netflix.astyanax.test.TestHostType;
import com.netflix.astyanax.util.TokenGenerator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TestTokenRange
implements TokenRange {
    private String start;
    private String end;
    private List<String> endpoints;

    public TestTokenRange(String start, String end, List<String> endpoints) {
        this.start = start;
        this.end = end;
        this.endpoints = endpoints;
    }

    @Override
    public String getStartToken() {
        return this.start;
    }

    @Override
    public String getEndToken() {
        return this.end;
    }

    @Override
    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public static List<Host> makeRing(int nHosts, int replication_factor, int id, BigInteger minInitialToken, BigInteger maxInitialToken) {
        int i;
        ArrayList hosts = Lists.newArrayList();
        for (i = 0; i < nHosts; ++i) {
            hosts.add(new Host("127.0." + id + "." + i + ":" + TestHostType.GOOD_FAST.ordinal(), 9160));
        }
        for (i = 0; i < nHosts; ++i) {
            String startToken = TokenGenerator.initialToken(nHosts, i, minInitialToken, maxInitialToken);
            String endToken = TokenGenerator.initialToken(nHosts, i + 1, minInitialToken, maxInitialToken);
            if (endToken.equals(maxInitialToken.toString())) {
                endToken = minInitialToken.toString();
            }
            TokenRangeImpl range = new TokenRangeImpl(startToken, endToken, null);
            for (int j = 0; j < replication_factor; ++j) {
                ((Host)hosts.get((i + j) % nHosts)).getTokenRanges().add(range);
            }
        }
        return hosts;
    }

    public static String getRingDetails(List<Host> hosts) {
        StringBuilder sb = new StringBuilder();
        for (Host host : hosts) {
            sb.append(host.toString()).append("\n");
            for (TokenRange range : host.getTokenRanges()) {
                sb.append("  ").append(range.toString()).append("\n");
            }
        }
        return sb.toString();
    }
}

