/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.cql.reads.CqlColumnQueryImpl;
import com.netflix.astyanax.cql.reads.QueryGenCache;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class CFColumnQueryGen {
    private AtomicReference<Session> sessionRef = new AtomicReference<Object>(null);
    private final String keyspace;
    private final CqlColumnFamilyDefinitionImpl cfDef;
    private final String partitionKeyCol;
    private final List<ColumnDefinition> clusteringKeyCols;
    private final List<ColumnDefinition> regularCols;
    private boolean isCompositeColumn = false;
    private boolean isFlatTable = false;
    private static final String BIND_MARKER = "?";
    private QueryGenCache<CqlColumnQueryImpl<?>> ColumnQueryWithClusteringKey = new QueryGenCache<CqlColumnQueryImpl<?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(CqlColumnQueryImpl<?> columnQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    if (CFColumnQueryGen.this.clusteringKeyCols.size() != 1) {
                        throw new RuntimeException("Cannot use this query for this schema, clustetingKeyCols.size: " + CFColumnQueryGen.this.clusteringKeyCols.size());
                    }
                    String valueColName = ((ColumnDefinition)CFColumnQueryGen.this.regularCols.get(0)).getName();
                    return QueryBuilder.select().column(valueColName).ttl(valueColName).writeTime(valueColName).from(CFColumnQueryGen.this.keyspace, CFColumnQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)CFColumnQueryGen.this.partitionKeyCol, (Object)CFColumnQueryGen.BIND_MARKER)).and(QueryBuilder.eq((String)((ColumnDefinition)CFColumnQueryGen.this.clusteringKeyCols.get(0)).getName(), (Object)CFColumnQueryGen.BIND_MARKER));
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnQueryImpl<?> columnQuery) {
            return pStatement.bind(new Object[]{columnQuery.getRowKey(), columnQuery.getColumnName()});
        }
    };
    private QueryGenCache<CqlColumnQueryImpl<?>> ColumnQueryWithCompositeColumn = new QueryGenCache<CqlColumnQueryImpl<?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlColumnQueryImpl<?> columnQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    if (CFColumnQueryGen.this.clusteringKeyCols.size() <= 1) {
                        throw new RuntimeException("Cannot use this query for this schema, clustetingKeyCols.size: " + CFColumnQueryGen.this.clusteringKeyCols.size());
                    }
                    String valueColName = ((ColumnDefinition)CFColumnQueryGen.this.regularCols.get(0)).getName();
                    ColumnFamily cf = columnQuery.getCF();
                    AnnotatedCompositeSerializer compSerializer = (AnnotatedCompositeSerializer)cf.getColumnSerializer();
                    List components = compSerializer.getComponents();
                    Select.SelectionOrAlias select = QueryBuilder.select().column(valueColName).ttl(valueColName).writeTime(valueColName);
                    Select.Where where = select.from(CFColumnQueryGen.this.keyspace, CFColumnQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)CFColumnQueryGen.this.partitionKeyCol, (Object)CFColumnQueryGen.BIND_MARKER));
                    for (int index = 0; index < components.size(); ++index) {
                        where.and(QueryBuilder.eq((String)((ColumnDefinition)CFColumnQueryGen.this.clusteringKeyCols.get(index)).getName(), (Object)CFColumnQueryGen.BIND_MARKER));
                    }
                    return where;
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnQueryImpl<?> columnQuery) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(columnQuery.getRowKey());
            ColumnFamily<?, ?> cf = columnQuery.getCF();
            AnnotatedCompositeSerializer compSerializer = (AnnotatedCompositeSerializer)cf.getColumnSerializer();
            List components = compSerializer.getComponents();
            Object columnName = columnQuery.getColumnName();
            for (AnnotatedCompositeSerializer.ComponentSerializer component : components) {
                values.add(component.getFieldValueDirectly(columnName));
            }
            return pStatement.bind(values.toArray());
        }
    };
    private QueryGenCache<CqlColumnQueryImpl<?>> FlatTableColumnQuery = new QueryGenCache<CqlColumnQueryImpl<?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlColumnQueryImpl<?> columnQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    if (CFColumnQueryGen.this.clusteringKeyCols.size() != 0) {
                        throw new RuntimeException("Cannot use this query for this schema, clustetingKeyCols.size: " + CFColumnQueryGen.this.clusteringKeyCols.size());
                    }
                    String columnNameString = (String)columnQuery.getColumnName();
                    return QueryBuilder.select().column(columnNameString).ttl(columnNameString).writeTime(columnNameString).from(CFColumnQueryGen.this.keyspace, CFColumnQueryGen.this.cfDef.getName()).where(QueryBuilder.eq((String)CFColumnQueryGen.this.partitionKeyCol, (Object)CFColumnQueryGen.BIND_MARKER));
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnQueryImpl<?> columnQuery) {
            return pStatement.bind(new Object[]{columnQuery.getRowKey()});
        }
    };

    public CFColumnQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        this.keyspace = keyspaceName;
        this.cfDef = cfDefinition;
        this.sessionRef.set(session);
        this.partitionKeyCol = this.cfDef.getPartitionKeyColumnDefinition().getName();
        this.clusteringKeyCols = this.cfDef.getClusteringKeyColumnDefinitionList();
        this.regularCols = this.cfDef.getRegularColumnDefinitionList();
        this.isCompositeColumn = this.clusteringKeyCols.size() > 1;
        this.isFlatTable = this.clusteringKeyCols.size() == 0;
    }

    public BoundStatement getQueryStatement(CqlColumnQueryImpl<?> columnQuery, boolean useCaching) {
        if (this.isFlatTable) {
            return this.FlatTableColumnQuery.getBoundStatement(columnQuery, useCaching);
        }
        if (this.isCompositeColumn) {
            return this.ColumnQueryWithCompositeColumn.getBoundStatement(columnQuery, useCaching);
        }
        return this.ColumnQueryWithClusteringKey.getBoundStatement(columnQuery, useCaching);
    }
}

