/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.cql.reads.CFRowSliceQueryGen;
import com.netflix.astyanax.cql.reads.CqlRowSliceQueryImpl;
import com.netflix.astyanax.cql.reads.QueryGenCache;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;

public class CFRowKeysQueryGen
extends CFRowSliceQueryGen {
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectAllColumnsForRowKeys;
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectColumnSetForRowKeys;
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectColumnRangeForRowKeys;
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectCompositeColumnRangeForRowKeys;

    public CFRowKeysQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        super(session, keyspaceName, cfDefinition);
        this.SelectAllColumnsForRowKeys = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        Select select = CFRowKeysQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        return select.where(QueryBuilder.in((String)CFRowKeysQueryGen.this.partitionKeyCol, (Object[])CFRowKeysQueryGen.this.bindMarkerArray(rowSliceQuery.getRowSlice().getKeys().size())));
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return pStatement.bind(rowSliceQuery.getRowSlice().getKeys().toArray());
            }
        };
        this.SelectColumnSetForRowKeys = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        if (CFRowKeysQueryGen.this.clusteringKeyCols.size() != 1) {
                            throw new RuntimeException("Cannot perform row slice with col slice query for this schema, clusteringKeyCols.size(): " + CFRowKeysQueryGen.this.clusteringKeyCols.size());
                        }
                        Collection rowKeys = rowSliceQuery.getRowSlice().getKeys();
                        Collection cols = rowSliceQuery.getColumnSlice().getColumns();
                        Object[] columns = cols.toArray(new Object[cols.size()]);
                        String clusteringCol = ((ColumnDefinition)CFRowKeysQueryGen.this.clusteringKeyCols.get(0)).getName();
                        Select select = CFRowKeysQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        return select.where(QueryBuilder.in((String)CFRowKeysQueryGen.this.partitionKeyCol, (Object[])CFRowKeysQueryGen.this.bindMarkerArray(rowKeys.size()))).and(QueryBuilder.in((String)clusteringCol, (Object[])CFRowKeysQueryGen.this.bindMarkerArray(columns.length)));
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                if (CFRowKeysQueryGen.this.clusteringKeyCols.size() != 1) {
                    throw new RuntimeException("Cannot perform row slice with col slice query for this schema, clusteringKeyCols.size(): " + CFRowKeysQueryGen.this.clusteringKeyCols.size());
                }
                ArrayList values = new ArrayList();
                values.addAll(rowSliceQuery.getRowSlice().getKeys());
                values.addAll(rowSliceQuery.getColumnSlice().getColumns());
                return pStatement.bind(values.toArray());
            }
        };
        this.SelectColumnRangeForRowKeys = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        if (CFRowKeysQueryGen.this.clusteringKeyCols.size() != 1) {
                            throw new RuntimeException("Cannot perform row slice with col slice query for this schema, clusteringKeyCols.size(): " + CFRowKeysQueryGen.this.clusteringKeyCols.size());
                        }
                        Select select = CFRowKeysQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        Select.Where where = select.where(QueryBuilder.in((String)CFRowKeysQueryGen.this.partitionKeyCol, (Object[])CFRowKeysQueryGen.this.bindMarkerArray(rowSliceQuery.getRowSlice().getKeys().size())));
                        where = CFRowKeysQueryGen.this.addWhereClauseForColumnRange(where, rowSliceQuery.getColumnSlice());
                        return where;
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                if (CFRowKeysQueryGen.this.clusteringKeyCols.size() != 1) {
                    throw new RuntimeException("Cannot perform row slice with col slice query for this schema, clusteringKeyCols.size(): " + CFRowKeysQueryGen.this.clusteringKeyCols.size());
                }
                ArrayList<Object> values = new ArrayList<Object>();
                values.addAll(rowSliceQuery.getRowSlice().getKeys());
                CFRowKeysQueryGen.this.bindWhereClauseForColumnRange(values, rowSliceQuery.getColumnSlice());
                return pStatement.bind(values.toArray());
            }
        };
        this.SelectCompositeColumnRangeForRowKeys = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

            @Override
            public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                return new Callable<RegularStatement>(){

                    @Override
                    public RegularStatement call() throws Exception {
                        Select select = CFRowKeysQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                        Select.Where stmt = select.where(QueryBuilder.in((String)CFRowKeysQueryGen.this.partitionKeyCol, (Object[])CFRowKeysQueryGen.this.bindMarkerArray(rowSliceQuery.getRowSlice().getKeys().size())));
                        stmt = CFRowKeysQueryGen.this.addWhereClauseForCompositeColumnRange(stmt, rowSliceQuery.getCompositeRange());
                        return stmt;
                    }
                };
            }

            @Override
            public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
                ArrayList<Object> values = new ArrayList<Object>();
                values.addAll(rowSliceQuery.getRowSlice().getKeys());
                CFRowKeysQueryGen.this.bindWhereClauseForCompositeColumnRange(values, rowSliceQuery.getCompositeRange());
                return pStatement.bind(values.toArray());
            }
        };
    }

    public BoundStatement getQueryStatement(CqlRowSliceQueryImpl<?, ?> rowSliceQuery, boolean useCaching) {
        switch (rowSliceQuery.getColQueryType()) {
            case AllColumns: {
                return this.SelectAllColumnsForRowKeys.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnSet: {
                return this.SelectColumnSetForRowKeys.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnRange: {
                if (this.isCompositeColumn) {
                    return this.SelectCompositeColumnRangeForRowKeys.getBoundStatement(rowSliceQuery, useCaching);
                }
                return this.SelectColumnRangeForRowKeys.getBoundStatement(rowSliceQuery, useCaching);
            }
        }
        throw new RuntimeException("RowSliceQuery with row keys use case not supported.");
    }
}

