/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.RowCopier;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.reads.CqlColumnCountQueryImpl;
import com.netflix.astyanax.cql.reads.CqlColumnQueryImpl;
import com.netflix.astyanax.cql.reads.CqlRowCopier;
import com.netflix.astyanax.cql.reads.model.CqlColumnListImpl;
import com.netflix.astyanax.cql.reads.model.CqlColumnSlice;
import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.reads.model.CqlRangeImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.query.ColumnCountQuery;
import com.netflix.astyanax.query.ColumnQuery;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.serializers.CompositeRangeBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CqlRowQueryImpl<K, C>
implements RowQuery<K, C> {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<K, C> cfContext;
    private final Object rowKey;
    private final CqlColumnSlice<C> columnSlice = new CqlColumnSlice();
    private CompositeRangeBuilder.CompositeByteBufferRange compositeRange;
    private final PaginationContext paginationContext = new PaginationContext();
    private RowQueryType queryType = RowQueryType.AllColumns;
    private boolean useCaching = false;

    public CqlRowQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<K, C> cfCtx, K rKey, boolean useCaching) {
        this.ksContext = ksCtx;
        this.cfContext = cfCtx;
        this.rowKey = cfCtx.checkRowKey(rKey);
        this.useCaching = useCaching;
    }

    public OperationResult<ColumnList<C>> execute() throws ConnectionException {
        if (this.paginationContext.isPaginating() && !this.paginationContext.isFirstPage()) {
            return new CqlOperationResultImpl<ColumnList<C>>(this.paginationContext.getResultSet(), this.paginationContext.getNextColumns());
        }
        return new InternalRowQueryExecutionImpl(this).execute();
    }

    public ListenableFuture<OperationResult<ColumnList<C>>> executeAsync() throws ConnectionException {
        return new InternalRowQueryExecutionImpl(this).executeAsync();
    }

    public ColumnQuery<C> getColumn(C column) {
        this.queryType = RowQueryType.SingleColumn;
        return new CqlColumnQueryImpl<C>(this.ksContext, this.cfContext, this.rowKey, column, this.useCaching);
    }

    public RowQuery<K, C> withColumnSlice(Collection<C> columns) {
        this.queryType = RowQueryType.ColumnSlice;
        this.columnSlice.setColumns(columns);
        return this;
    }

    public RowQuery<K, C> withColumnSlice(C ... columns) {
        this.queryType = RowQueryType.ColumnSlice;
        return this.withColumnSlice((Collection<C>)Arrays.asList(columns));
    }

    public RowQuery<K, C> withColumnSlice(ColumnSlice<C> colSlice) {
        if (colSlice.getColumns() != null) {
            return this.withColumnSlice(colSlice.getColumns());
        }
        return this.withColumnRange(colSlice.getStartColumn(), colSlice.getEndColumn(), colSlice.getReversed(), colSlice.getLimit());
    }

    public RowQuery<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
        this.queryType = RowQueryType.ColumnRange;
        this.columnSlice.setCqlRange(new CqlRangeBuilder().setColumn("column1").setStart(startColumn).setEnd(endColumn).setReversed(reversed).setLimit(count).build());
        return this;
    }

    public RowQuery<K, C> withColumnRange(ByteBuffer startColumn, ByteBuffer endColumn, boolean reversed, int limit) {
        this.queryType = RowQueryType.ColumnRange;
        Serializer colSerializer = this.cfContext.getColumnFamily().getColumnSerializer();
        Object start = startColumn != null && startColumn.capacity() > 0 ? colSerializer.fromByteBuffer(startColumn) : null;
        Object end = endColumn != null && endColumn.capacity() > 0 ? colSerializer.fromByteBuffer(endColumn) : null;
        return this.withColumnRange(start, end, reversed, limit);
    }

    public RowQuery<K, C> withColumnRange(ByteBufferRange range) {
        this.queryType = RowQueryType.ColumnRange;
        if (range instanceof CompositeRangeBuilder.CompositeByteBufferRange) {
            this.compositeRange = (CompositeRangeBuilder.CompositeByteBufferRange)range;
        } else if (range instanceof CompositeRangeBuilder) {
            this.compositeRange = ((CompositeRangeBuilder)range).build();
        } else if (range instanceof CqlRangeImpl) {
            this.columnSlice.setCqlRange((CqlRangeImpl)range);
        } else {
            return this.withColumnRange(range.getStart(), range.getEnd(), range.isReversed(), range.getLimit());
        }
        return this;
    }

    @Deprecated
    public RowQuery<K, C> setIsPaginating() {
        return this.autoPaginate(true);
    }

    public RowQuery<K, C> autoPaginate(boolean enabled) {
        this.paginationContext.setPaginating(enabled);
        return this;
    }

    public RowCopier<K, C> copyTo(ColumnFamily<K, C> columnFamily, K rowKey) {
        return new CqlRowCopier<K, C>(columnFamily, rowKey, this, this.ksContext);
    }

    public ColumnCountQuery getCount() {
        return new CqlColumnCountQueryImpl(this.ksContext, this.cfContext, new InternalRowQueryExecutionImpl(this).getQuery());
    }

    public Object getRowKey() {
        return this.rowKey;
    }

    public CqlColumnSlice<C> getColumnSlice() {
        return this.columnSlice;
    }

    public CompositeRangeBuilder.CompositeByteBufferRange getCompositeRange() {
        return this.compositeRange;
    }

    public RowQueryType getQueryType() {
        return this.queryType;
    }

    public boolean isPaginating() {
        return this.paginationContext.isPaginating();
    }

    private class PaginationContext {
        private int fetchSize = Integer.MAX_VALUE;
        private boolean paginate = false;
        private boolean isFirstPage = true;
        private ResultSet resultSet = null;
        private Iterator<Row> rowIter = null;

        private PaginationContext() {
        }

        private void setPaginating(boolean condition) {
            this.paginate = condition;
        }

        private boolean isPaginating() {
            return this.paginate;
        }

        private boolean isFirstPage() {
            return this.isFirstPage;
        }

        private void firstPageConsumed() {
            this.isFirstPage = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CqlColumnListImpl<C> getNextColumns() {
            try {
                ArrayList<Row> rows = new ArrayList<Row>();
                for (int count = 0; count < this.fetchSize && this.rowIter.hasNext(); ++count) {
                    rows.add(this.rowIter.next());
                }
                CqlColumnListImpl cqlColumnListImpl = new CqlColumnListImpl(rows, CqlRowQueryImpl.this.cfContext.getColumnFamily());
                return cqlColumnListImpl;
            }
            finally {
                this.firstPageConsumed();
            }
        }

        private void init(ResultSet rs, int size) {
            this.resultSet = rs;
            this.rowIter = this.resultSet.iterator();
            if (size > 0) {
                this.fetchSize = size;
            }
        }

        private ResultSet getResultSet() {
            return this.resultSet;
        }
    }

    private class InternalRowQueryExecutionImpl
    extends CqlAbstractExecutionImpl<ColumnList<C>> {
        private final CqlColumnFamilyDefinitionImpl cfDef;
        private final String[] allPkColumnNames;
        private final List<ColumnDefinition> regularCols;
        private final CqlRowQueryImpl<?, ?> rowQuery;

        public InternalRowQueryExecutionImpl(CqlRowQueryImpl<?, ?> rQuery) {
            super(CqlRowQueryImpl.this.ksContext, CqlRowQueryImpl.this.cfContext);
            this.cfDef = (CqlColumnFamilyDefinitionImpl)this.cf.getColumnFamilyDefinition();
            this.allPkColumnNames = this.cfDef.getAllPkColNames();
            this.regularCols = this.cfDef.getRegularColumnDefinitionList();
            this.rowQuery = rQuery;
        }

        @Override
        public CassandraOperationType getOperationType() {
            return CassandraOperationType.GET_ROW;
        }

        @Override
        public Statement getQuery() {
            Statement stmt = this.cfDef.getRowQueryGenerator().getQueryStatement(this.rowQuery, CqlRowQueryImpl.this.useCaching);
            if (!CqlRowQueryImpl.this.paginationContext.isPaginating() || CqlRowQueryImpl.this.columnSlice.isRangeQuery()) {
                // empty if block
            }
            return stmt;
        }

        @Override
        public ColumnList<C> parseResultSet(ResultSet resultSet) throws NotFoundException {
            if (this.allPkColumnNames.length == 1 || this.regularCols.size() > 1) {
                List rows = resultSet.all();
                if (rows == null || rows.isEmpty()) {
                    return new CqlColumnListImpl();
                }
                return new CqlColumnListImpl((Row)rows.get(0), this.cf);
            }
            if (CqlRowQueryImpl.this.paginationContext.isPaginating()) {
                CqlRowQueryImpl.this.paginationContext.init(resultSet, CqlRowQueryImpl.this.columnSlice.getFetchSize());
                return CqlRowQueryImpl.this.paginationContext.getNextColumns();
            }
            List rows = resultSet.all();
            if (rows == null || rows.isEmpty()) {
                return new CqlColumnListImpl();
            }
            return new CqlColumnListImpl(rows, this.cf);
        }
    }

    public static enum RowQueryType {
        AllColumns,
        ColumnSlice,
        ColumnRange,
        SingleColumn;

    }
}

