/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.query.RowSliceColumnCountQuery;
import java.util.HashMap;
import java.util.Map;

public class CqlRowSliceColumnCountQueryImpl<K>
implements RowSliceColumnCountQuery<K> {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<?, ?> cfContext;
    private final Statement query;

    public CqlRowSliceColumnCountQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<?, ?> cfCtx, Statement query) {
        this.ksContext = ksCtx;
        this.cfContext = cfCtx;
        this.query = query;
    }

    public OperationResult<Map<K, Integer>> execute() throws ConnectionException {
        return new InternalQueryExecutionImpl().execute();
    }

    public ListenableFuture<OperationResult<Map<K, Integer>>> executeAsync() throws ConnectionException {
        return new InternalQueryExecutionImpl().executeAsync();
    }

    private class InternalQueryExecutionImpl
    extends CqlAbstractExecutionImpl<Map<K, Integer>> {
        public InternalQueryExecutionImpl() {
            super(CqlRowSliceColumnCountQueryImpl.this.ksContext, CqlRowSliceColumnCountQueryImpl.this.cfContext);
        }

        @Override
        public CassandraOperationType getOperationType() {
            return CassandraOperationType.GET_ROWS_SLICE;
        }

        @Override
        public Statement getQuery() {
            return CqlRowSliceColumnCountQueryImpl.this.query;
        }

        @Override
        public Map<K, Integer> parseResultSet(ResultSet resultSet) {
            HashMap<Object, Integer> columnCountPerRow = new HashMap<Object, Integer>();
            for (Row row : resultSet.all()) {
                Object key = CqlTypeMapping.getDynamicColumn(row, this.cf.getKeySerializer(), 0, this.cf);
                Integer colCount = (Integer)columnCountPerRow.get(key);
                if (colCount == null) {
                    colCount = new Integer(0);
                }
                colCount = colCount + 1;
                columnCountPerRow.put(key, colCount);
            }
            return columnCountPerRow;
        }
    }
}

