/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.retrypolicies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.policies.RetryPolicy;
import com.netflix.astyanax.cql.ConsistencyLevelMapping;
import com.netflix.astyanax.cql.retrypolicies.JavaDriverBasedRetryPolicy;

public class ChangeConsistencyLevelRetryPolicy
extends JavaDriverBasedRetryPolicy {
    private boolean retryOnAllConditions = true;
    private boolean retryOnReads = false;
    private boolean retryOnWrites = false;
    private boolean retryOnUnavailable = false;
    private int retryCount = 0;
    private ConsistencyLevel nextConsistencyLevel;
    private boolean suppressFinalFailure = false;
    private RetryPolicy jdRetry = new RetryPolicy(){

        public RetryPolicy.RetryDecision onReadTimeout(Statement query, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            boolean shouldRetry = ChangeConsistencyLevelRetryPolicy.this.retryOnAllConditions || ChangeConsistencyLevelRetryPolicy.this.retryOnReads;
            return ChangeConsistencyLevelRetryPolicy.this.checkRetry(query, cl, shouldRetry);
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement query, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            boolean shouldRetry = ChangeConsistencyLevelRetryPolicy.this.retryOnAllConditions || ChangeConsistencyLevelRetryPolicy.this.retryOnWrites;
            return ChangeConsistencyLevelRetryPolicy.this.checkRetry(query, cl, shouldRetry);
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement query, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            boolean shouldRetry = ChangeConsistencyLevelRetryPolicy.this.retryOnAllConditions || ChangeConsistencyLevelRetryPolicy.this.retryOnUnavailable;
            return ChangeConsistencyLevelRetryPolicy.this.checkRetry(query, cl, shouldRetry);
        }
    };

    public ChangeConsistencyLevelRetryPolicy retryOnAllConditions(boolean condition) {
        this.retryOnAllConditions = condition;
        return this;
    }

    public ChangeConsistencyLevelRetryPolicy retryOnReadTimeouts(boolean condition) {
        this.retryOnReads = condition;
        this.retryOnAllConditions = false;
        return this;
    }

    public ChangeConsistencyLevelRetryPolicy retryOnWriteTimeouts(boolean condition) {
        this.retryOnWrites = condition;
        this.retryOnAllConditions = false;
        return this;
    }

    public ChangeConsistencyLevelRetryPolicy retryOnUnavailable(boolean condition) {
        this.retryOnUnavailable = condition;
        this.retryOnAllConditions = false;
        return this;
    }

    public ChangeConsistencyLevelRetryPolicy withNumRetries(int retries) {
        this.retryCount = retries;
        return this;
    }

    public ChangeConsistencyLevelRetryPolicy withNextConsistencyLevel(com.netflix.astyanax.model.ConsistencyLevel cl) {
        this.nextConsistencyLevel = ConsistencyLevelMapping.getCL(cl);
        return this;
    }

    public ChangeConsistencyLevelRetryPolicy suppressFinalFailure(boolean condition) {
        this.suppressFinalFailure = condition;
        return this;
    }

    @Override
    public RetryPolicy getJDRetryPolicy() {
        return this.jdRetry;
    }

    private RetryPolicy.RetryDecision checkRetry(Statement query, ConsistencyLevel cl, boolean shouldRetry) {
        if (!shouldRetry || this.retryCount <= 0) {
            if (this.suppressFinalFailure) {
                return RetryPolicy.RetryDecision.ignore();
            }
            return RetryPolicy.RetryDecision.rethrow();
        }
        --this.retryCount;
        if (this.nextConsistencyLevel != null) {
            return RetryPolicy.RetryDecision.retry((ConsistencyLevel)this.nextConsistencyLevel);
        }
        return RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
    }
}

