/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.schema;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.FieldMetadata;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlKeyspaceDefinitionImpl
implements KeyspaceDefinition {
    private static final Logger Log = LoggerFactory.getLogger(CqlKeyspaceDefinitionImpl.class);
    private final Session session;
    private boolean alterKeyspace;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final List<CqlColumnFamilyDefinitionImpl> cfDefList = new ArrayList<CqlColumnFamilyDefinitionImpl>();

    public CqlKeyspaceDefinitionImpl(Session session) {
        this.session = session;
    }

    public CqlKeyspaceDefinitionImpl(Session session, Map<String, Object> input) {
        this.session = session;
        this.checkOptionsMap(input);
    }

    public CqlKeyspaceDefinitionImpl(Session session, Properties props) {
        this.session = session;
        this.checkOptionsMap(CqlKeyspaceDefinitionImpl.propertiesToMap(props));
    }

    public CqlKeyspaceDefinitionImpl(Session session, Row row) {
        this.session = session;
        this.setName(row.getString("keyspace_name"));
        this.setStrategyClass(row.getString("strategy_class"));
        this.setStrategyOptionsMap(this.parseStrategyOptions(row.getString("strategy_options")));
        this.options.put("durable_writes", row.getBool("durable_writes"));
    }

    public CqlKeyspaceDefinitionImpl alterKeyspace() {
        this.alterKeyspace = true;
        return this;
    }

    public CqlKeyspaceDefinitionImpl setName(String name) {
        this.options.put("name", name.toLowerCase());
        return this;
    }

    public String getName() {
        return (String)this.options.get("name");
    }

    public CqlKeyspaceDefinitionImpl setStrategyClass(String strategyClass) {
        this.getOrCreateReplicationMap().put("class", strategyClass);
        return this;
    }

    public String getStrategyClass() {
        return (String)this.getOrCreateReplicationMap().get("class");
    }

    public CqlKeyspaceDefinitionImpl setStrategyOptions(Map<String, String> strategyOptions) {
        this.getOrCreateReplicationMap().putAll(strategyOptions);
        return this;
    }

    public CqlKeyspaceDefinitionImpl setStrategyOptionsMap(Map<String, Object> strategyOptions) {
        this.getOrCreateReplicationMap().putAll(strategyOptions);
        return this;
    }

    public CqlKeyspaceDefinitionImpl addStrategyOption(String name, String value) {
        this.getOrCreateReplicationMap().put(name, value);
        return this;
    }

    public Map<String, String> getStrategyOptions() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Object> repMap = this.getOrCreateReplicationMap();
        for (String key : repMap.keySet()) {
            map.put(key, (String)repMap.get(key));
        }
        return map;
    }

    public List<ColumnFamilyDefinition> getColumnFamilyList() {
        Select.Where query = QueryBuilder.select().all().from("system", "schema_columnfamilies").where(QueryBuilder.eq((String)"keyspace_name", (Object)this.getName()));
        ResultSet rs = this.session.execute((Statement)query);
        ArrayList<ColumnFamilyDefinition> cfDefs = new ArrayList<ColumnFamilyDefinition>();
        List rows = rs.all();
        if (rows != null) {
            for (Row row : rows) {
                cfDefs.add(new CqlColumnFamilyDefinitionImpl(this.session, row));
            }
        }
        return cfDefs;
    }

    public ColumnFamilyDefinition getColumnFamily(String columnFamilyName) {
        Select.Where query = QueryBuilder.select().all().from("system", "schema_columnfamilies").where(QueryBuilder.eq((String)"keyspace_name", (Object)this.getName())).and(QueryBuilder.eq((String)"columnfamily_name", (Object)columnFamilyName.toLowerCase()));
        Row row = this.session.execute((Statement)query).one();
        if (row == null) {
            throw new RuntimeException("CF not found: " + columnFamilyName);
        }
        return new CqlColumnFamilyDefinitionImpl(this.session, row);
    }

    public KeyspaceDefinition addColumnFamily(ColumnFamilyDefinition cfDef) {
        CqlColumnFamilyDefinitionImpl cqlCfDef = (CqlColumnFamilyDefinitionImpl)cfDef;
        cqlCfDef.execute();
        return this;
    }

    public Collection<String> getFieldNames() {
        return this.options.keySet();
    }

    public Object getFieldValue(String name) {
        return this.options.get(name);
    }

    public KeyspaceDefinition setFieldValue(String name, Object value) {
        this.options.put(name, value);
        return this;
    }

    public Collection<FieldMetadata> getFieldsMetadata() {
        ArrayList<FieldMetadata> list = new ArrayList<FieldMetadata>();
        for (String key : this.options.keySet()) {
            Object value = this.options.get(key);
            Class<?> clazz = value.getClass();
            String name = key.toUpperCase();
            String type = clazz.getSimpleName().toUpperCase();
            boolean isContainer = Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
            list.add(new FieldMetadata(name, type, isContainer));
        }
        return list;
    }

    public void setFields(Map<String, Object> optionsMap) {
        this.checkOptionsMap(optionsMap);
    }

    public Properties getProperties() throws Exception {
        return CqlKeyspaceDefinitionImpl.mapToProperties(this.options);
    }

    public void setProperties(Properties props) throws Exception {
        this.options.clear();
        this.options.putAll(CqlKeyspaceDefinitionImpl.propertiesToMap(props));
    }

    public OperationResult<SchemaChangeResult> execute() {
        String query = this.getQuery();
        if (Log.isDebugEnabled()) {
            Log.debug("Query : " + query);
        }
        CqlOperationResultImpl<Object> result = new CqlOperationResultImpl<Object>(this.session.execute(query), null);
        for (CqlColumnFamilyDefinitionImpl cfDef : this.cfDefList) {
            cfDef.execute();
        }
        return result;
    }

    private String getQuery() {
        String cmd = this.alterKeyspace ? "ALTER" : "CREATE";
        StringBuilder sb = new StringBuilder(cmd);
        sb.append(" KEYSPACE ");
        sb.append(this.getName());
        Map replicationOptions = (Map)this.options.get("replication");
        this.appendReplicationOptions(sb, replicationOptions);
        Object durableWrites = this.options.get("durable_writes");
        if (durableWrites != null) {
            sb.append(" AND durable_writes = ").append(durableWrites);
        }
        return sb.toString();
    }

    private void appendReplicationOptions(StringBuilder sb, Map<String, Object> replicationOptions) {
        if (replicationOptions == null || replicationOptions.size() == 0) {
            throw new RuntimeException("Missing properties for 'replication'");
        }
        sb.append(" WITH replication = {");
        Iterator<Map.Entry<String, Object>> iter = replicationOptions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            sb.append("'").append(entry.getKey()).append("' : '").append(entry.getValue()).append("'");
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
    }

    private void checkOptionsMap(Map<String, Object> input) {
        Object strategyOptions = input.get("strategy_options");
        if (strategyOptions == null) {
            Preconditions.checkArgument((input.get("replication") != null ? 1 : 0) != 0, (Object)"Invalid CREATE KEYSPACE properties");
            this.options.clear();
            this.options.putAll(input);
        } else {
            this.options.clear();
            HashMap<String, String> replicationOptions = new HashMap<String, String>();
            this.options.put("replication", replicationOptions);
            Map oldStrategyOptions = (Map)input.get("strategy_options");
            replicationOptions.putAll(oldStrategyOptions);
            String strategyClass = (String)input.get("strategy_class");
            replicationOptions.put("class", strategyClass);
        }
    }

    private Map<String, Object> getOrCreateReplicationMap() {
        HashMap replicationMap = (HashMap)this.options.get("replication");
        if (replicationMap == null) {
            replicationMap = new HashMap();
            this.options.put("replication", replicationMap);
        }
        return replicationMap;
    }

    private static Map<String, Object> propertiesToMap(Properties props) {
        TreeMap root = Maps.newTreeMap();
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String[] parts = StringUtils.split((String)((String)prop.getKey()), (String)".");
            Map node = root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!node.containsKey(parts[i])) {
                    node.put(parts[i], new LinkedHashMap());
                }
                node = (Map)node.get(parts[i]);
            }
            node.put(parts[parts.length - 1], (String)prop.getValue());
        }
        return root;
    }

    private static Properties mapToProperties(Map<String, Object> map) {
        Properties props = new Properties();
        CqlKeyspaceDefinitionImpl.addProperties(props, null, map);
        return props;
    }

    private static void addProperties(Properties props, String prefix, Map<String, Object> subMap) {
        for (Map.Entry<String, Object> entry : subMap.entrySet()) {
            String key;
            String string = key = prefix != null ? prefix + "." + entry.getKey() : entry.getKey();
            if (entry.getValue() instanceof Map) {
                CqlKeyspaceDefinitionImpl.addProperties(props, key, (Map)entry.getValue());
                continue;
            }
            props.put(key, entry.getValue().toString());
        }
    }

    private Map<String, Object> parseStrategyOptions(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject json = new JSONObject(jsonString);
            Iterator iter = json.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object obj = json.get(key);
                map.put(key, obj);
            }
            return map;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "CqlKeyspaceDefinition=[ " + this.options.toString() + " ]";
    }
}

